/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;

public class ORecordIteratorCluster<REC extends ORecordInternal<?>>
extends OIdentifiableIterator<REC> {
    private ORecord<?> currentRecord;

    public ORecordIteratorCluster(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, int iClusterId, boolean iUseCache) {
        this(iDatabase, iLowLevelDatabase, iClusterId, OClusterPosition.INVALID_POSITION, OClusterPosition.INVALID_POSITION, iUseCache, false);
    }

    public ORecordIteratorCluster(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, int iClusterId, OClusterPosition firstClusterEntry, OClusterPosition lastClusterEntry, boolean iUseCache, boolean iterateThroughTombstones) {
        super(iDatabase, iLowLevelDatabase, iUseCache, iterateThroughTombstones);
        if (iClusterId == -1) {
            throw new IllegalArgumentException("The clusterId is invalid");
        }
        this.current.clusterId = iClusterId;
        OClusterPosition[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        if (firstClusterEntry.equals(OClusterPosition.INVALID_POSITION)) {
            this.firstClusterEntry = range[0];
        } else {
            OClusterPosition oClusterPosition = this.firstClusterEntry = firstClusterEntry.compareTo(range[0]) > 0 ? firstClusterEntry : range[0];
        }
        this.lastClusterEntry = lastClusterEntry.equals(OClusterPosition.INVALID_POSITION) ? range[1] : (lastClusterEntry.compareTo(range[1]) < 0 ? lastClusterEntry : range[1]);
        this.totalAvailableRecords = this.database.countClusterElements(this.current.clusterId, iterateThroughTombstones);
        this.txEntries = iDatabase.getTransaction().getNewRecordEntriesByClusterIds(new int[]{iClusterId});
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                switch (entry.type) {
                    case 3: {
                        ++this.totalAvailableRecords;
                        break;
                    }
                    case 2: {
                        --this.totalAvailableRecords;
                    }
                }
            }
        }
        this.begin();
    }

    @Override
    public boolean hasPrevious() {
        boolean thereAreRecordsToBrowse;
        this.checkDirection(false);
        this.updateRangesOnLiveUpdate();
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        boolean bl = thereAreRecordsToBrowse = this.getCurrentEntry().compareTo(this.firstClusterEntry) > 0;
        if (thereAreRecordsToBrowse) {
            ORecordInternal<?> record = this.getRecord();
            this.currentRecord = this.readCurrentRecord(record, -1);
        }
        return this.currentRecord != null;
    }

    private void updateRangesOnLiveUpdate() {
        if (this.liveUpdated) {
            OClusterPosition[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
            this.firstClusterEntry = range[0];
            this.lastClusterEntry = range[1];
        }
    }

    @Override
    public boolean hasNext() {
        this.checkDirection(true);
        if (Thread.interrupted()) {
            return false;
        }
        this.updateRangesOnLiveUpdate();
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (!this.current.clusterPosition.isTemporary() && this.getCurrentEntry().compareTo(this.lastClusterEntry) < 0) {
            ORecordInternal<?> record = this.getRecord();
            this.currentRecord = this.readCurrentRecord(record, 1);
            if (this.currentRecord != null) {
                return true;
            }
        }
        if (this.txEntries != null) {
            return this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REC previous() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            try {
                ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                return (REC)oRecordInternal;
            }
            finally {
                this.currentRecord = null;
            }
        }
        if (this.hasPrevious()) {
            try {
                ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                return (REC)oRecordInternal;
            }
            finally {
                this.currentRecord = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REC next() {
        this.checkDirection(true);
        while (this.hasNext()) {
            if (this.currentRecord != null) {
                try {
                    ORecordInternal oRecordInternal = (ORecordInternal)this.currentRecord;
                    return (REC)oRecordInternal;
                }
                finally {
                    this.currentRecord = null;
                }
            }
            ORecordInternal<?> record = this.getTransactionEntry();
            if (record == null) continue;
            return (REC)record;
        }
        return null;
    }

    @Override
    public ORecordIteratorCluster<REC> begin() {
        this.updateRangesOnLiveUpdate();
        this.resetCurrentPosition();
        this.currentRecord = this.readCurrentRecord(this.getRecord(), 1);
        return this;
    }

    @Override
    public ORecordIteratorCluster<REC> last() {
        this.updateRangesOnLiveUpdate();
        this.resetCurrentPosition();
        this.currentRecord = this.readCurrentRecord(this.getRecord(), -1);
        return this;
    }

    @Override
    public ORecordIteratorCluster<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        if (iLiveUpdated) {
            this.firstClusterEntry = OClusterPositionFactory.INSTANCE.valueOf(0L);
            this.lastClusterEntry = OClusterPositionFactory.INSTANCE.getMaxValue();
        } else {
            OClusterPosition[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
            this.firstClusterEntry = range[0];
            this.lastClusterEntry = range[1];
        }
        this.totalAvailableRecords = this.database.countClusterElements(this.current.clusterId, this.isIterateThroughTombstones());
        return this;
    }
}

