/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.memory;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class OMemoryWatchDog
extends Thread {
    private final Map<ListenerWrapper, Object> listeners = new WeakHashMap<ListenerWrapper, Object>(128);
    private static long lastGC = 0L;
    private int alertTimes = 0;
    protected final ReferenceQueue<Object> monitorQueue = new ReferenceQueue();
    protected SoftReference<Object> monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);

    public OMemoryWatchDog() {
        super("OrientDB MemoryWatchDog");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        Orient.instance().getProfiler().registerHookValue("system.memory.alerts", "Number of alerts received by JVM to free memory resources", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMemoryWatchDog.this.alertTimes;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.memory.lastGC", "Date of last System.gc() invocation", OProfiler.METRIC_TYPE.STAT, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return lastGC;
            }
        });
        while (true) {
            block18: {
                this.monitorQueue.remove();
                if (!Thread.interrupted()) break block18;
                this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                break;
            }
            try {
                ++this.alertTimes;
                long maxMemory = Runtime.getRuntime().maxMemory();
                long freeMemory = Runtime.getRuntime().freeMemory();
                int freeMemoryPer = (int)(freeMemory * 100L / maxMemory);
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Free memory is low %s of %s (%d%%), calling listeners to free memory...", new Object[]{OFileUtils.getSizeAsString((long)freeMemory), OFileUtils.getSizeAsString((long)maxMemory), freeMemoryPer});
                }
                long timer = Orient.instance().getProfiler().startChrono();
                Map<ListenerWrapper, Object> map = this.listeners;
                synchronized (map) {
                    for (ListenerWrapper listener : this.listeners.keySet()) {
                        try {
                            listener.listener.memoryUsageLow(freeMemory, freeMemoryPer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Orient.instance().getProfiler().stopChrono("OMemoryWatchDog.freeResources", "WatchDog free resources", timer);
            }
            catch (InterruptedException e) {
                this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                break;
            }
            catch (Exception exception) {
                this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                continue;
                catch (Throwable throwable) {
                    this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                    throw throwable;
                }
            }
            this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
            continue;
            break;
        }
        OLogManager.instance().debug((Object)this, "[OMemoryWatchDog] shutdowning...", new Object[0]);
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            this.listeners.clear();
        }
        this.monitorRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener addListener(Listener listener) {
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            this.listeners.put(new ListenerWrapper(listener), listener);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Listener listener) {
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            return this.listeners.remove(new ListenerWrapper(listener)) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Listener> getListeners() {
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            ArrayList<Listener> listenerList = new ArrayList<Listener>();
            for (ListenerWrapper wrapper : this.listeners.keySet()) {
                listenerList.add(wrapper.listener);
            }
            return listenerList;
        }
    }

    public static void freeMemoryForOptimization(long iDelayTime) {
        OMemoryWatchDog.freeMemory(iDelayTime, OGlobalConfiguration.JVM_GC_DELAY_FOR_OPTIMIZE.getValueAsLong());
    }

    public static void freeMemoryForResourceCleanup(long iDelayTime) {
        OMemoryWatchDog.freeMemory(iDelayTime, 0L);
    }

    private static void freeMemory(long iDelayTime, long minimalTimeAmount) {
        long dateLastGC = System.currentTimeMillis();
        if (dateLastGC - lastGC > minimalTimeAmount * 1000L) {
            lastGC = dateLastGC;
            System.gc();
            if (iDelayTime > 0L) {
                try {
                    Thread.sleep(iDelayTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);
    }

    private static class ListenerWrapper {
        final Listener listener;

        private ListenerWrapper(Listener listener) {
            this.listener = listener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerWrapper that = (ListenerWrapper)o;
            return this.listener == that.listener;
        }

        public int hashCode() {
            return this.listener != null ? System.identityHashCode(this.listener) : 0;
        }
    }
}

