/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class OSchemaShared
extends ODocumentWrapperNoClass
implements OSchema,
OCloseable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION_NUMBER = 4;
    private static final String DROP_INDEX_QUERY = "drop index ";
    protected Map<String, OClass> classes = new HashMap<String, OClass>();

    public OSchemaShared(int schemaClusterId) {
        super(new ODocument());
    }

    @Override
    public int countClasses() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        return this.getDatabase().getStorage().callInLock(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return OSchemaShared.this.classes.size();
            }
        }, false);
    }

    @Override
    public OClass createClass(Class<?> iClass) {
        Class<?> superClass = iClass.getSuperclass();
        OClass cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
        return this.createClass(iClass.getSimpleName(), cls, OStorage.CLUSTER_TYPE.PHYSICAL);
    }

    @Override
    public OClass createClass(Class<?> iClass, int iDefaultClusterId) {
        Class<?> superClass = iClass.getSuperclass();
        OClass cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
        return this.createClass(iClass.getSimpleName(), cls, iDefaultClusterId);
    }

    @Override
    public OClass createClass(String iClassName) {
        return this.createClass(iClassName, null, OStorage.CLUSTER_TYPE.PHYSICAL);
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass) {
        return this.createClass(iClassName, iSuperClass, OStorage.CLUSTER_TYPE.PHYSICAL);
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, OStorage.CLUSTER_TYPE iType) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create class " + iClassName + " inside a transaction");
        }
        int clusterId = this.getDatabase().getClusterIdByName(iClassName);
        if (clusterId == -1) {
            clusterId = this.createCluster(iType.toString(), iClassName);
        }
        return this.createClass(iClassName, iSuperClass, clusterId);
    }

    @Override
    public OClass createClass(String iClassName, int iDefaultClusterId) {
        return this.createClass(iClassName, null, new int[]{iDefaultClusterId});
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, int iDefaultClusterId) {
        return this.createClass(iClassName, iSuperClass, new int[]{iDefaultClusterId});
    }

    @Override
    public OClass getOrCreateClass(String iClassName) {
        return this.getOrCreateClass(iClassName, null);
    }

    @Override
    public OClass getOrCreateClass(final String iClassName, final OClass iSuperClass) {
        return this.getDatabase().getStorage().callInLock(new Callable<OClass>(){

            @Override
            public OClass call() throws Exception {
                OClass cls = OSchemaShared.this.classes.get(iClassName.toLowerCase());
                if (cls == null) {
                    cls = OSchemaShared.this.createClass(iClassName, iSuperClass);
                } else if (iSuperClass != null && !cls.isSubClassOf(iSuperClass)) {
                    throw new IllegalArgumentException("Class '" + iClassName + "' is not an instance of " + iSuperClass.getShortName());
                }
                return cls;
            }
        }, true);
    }

    @Override
    public OClass createAbstractClass(Class<?> iClass) {
        Class<?> superClass = iClass.getSuperclass();
        OClass cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
        return this.createClass(iClass.getSimpleName(), cls, -1);
    }

    @Override
    public OClass createAbstractClass(String iClassName) {
        return this.createClass(iClassName, null, -1);
    }

    @Override
    public OClass createAbstractClass(String iClassName, OClass iSuperClass) {
        return this.createClass(iClassName, iSuperClass, -1);
    }

    private int createCluster(String iType, String iClassName) {
        return (Integer)this.getDatabase().command(new OCommandSQL("create cluster " + iClassName + " " + iType)).execute(new Object[0]);
    }

    @Override
    public OClass createClass(final String iClassName, final OClass iSuperClass, final int[] iClusterIds) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_CREATE);
        final String key = iClassName.toLowerCase();
        return this.getDatabase().getStorage().callInLock(new Callable<OClass>(){

            @Override
            public OClass call() throws Exception {
                if (OSchemaShared.this.classes.containsKey(key)) {
                    throw new OSchemaException("Class " + iClassName + " already exists in current database");
                }
                StringBuilder cmd = new StringBuilder("create class ");
                cmd.append(iClassName);
                if (iSuperClass != null) {
                    cmd.append(" extends ");
                    cmd.append(iSuperClass.getName());
                }
                if (iClusterIds != null) {
                    if (iClusterIds.length == 1 && iClusterIds[0] == -1) {
                        cmd.append(" abstract");
                    } else {
                        cmd.append(" cluster ");
                        int i = 0;
                        while (i < iClusterIds.length) {
                            if (i > 0) {
                                cmd.append(',');
                            } else {
                                cmd.append(' ');
                            }
                            cmd.append(iClusterIds[i]);
                            ++i;
                        }
                    }
                }
                OSchemaShared.this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
                if (!(OSchemaShared.this.getDatabase().getStorage() instanceof OStorageEmbedded)) {
                    OSchemaShared.this.getDatabase().reload();
                }
                if (OSchemaShared.this.classes.containsKey(key)) {
                    return OSchemaShared.this.classes.get(key);
                }
                OSchemaShared.this.createClassInternal(iClassName, iSuperClass, iClusterIds);
                return OSchemaShared.this.classes.get(key);
            }
        }, true);
    }

    public OClass createClassInternal(final String iClassName, final OClass iSuperClass, int[] iClusterIds) {
        if (iClassName == null || iClassName.length() == 0) {
            throw new OSchemaException("Found class name null");
        }
        Character wrongCharacter = OSchemaShared.checkNameIfValid(iClassName);
        if (wrongCharacter != null) {
            throw new OSchemaException("Found invalid class name. Character '" + wrongCharacter + "' cannot be used in class name.");
        }
        final ODatabaseRecord database = this.getDatabase();
        final int[] clusterIds = iClusterIds == null || iClusterIds.length == 0 ? new int[]{database.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), iClassName, null, null, new Object[0])} : iClusterIds;
        database.checkSecurity("database.schema", ORole.PERMISSION_CREATE);
        final String key = iClassName.toLowerCase();
        final OSchemaShared me = this;
        return this.getDatabase().getStorage().callInLock(new Callable<OClass>(){

            @Override
            public OClass call() throws Exception {
                if (OSchemaShared.this.classes.containsKey(key)) {
                    throw new OSchemaException("Class " + iClassName + " already exists in current database");
                }
                OClassImpl cls = new OClassImpl(me, iClassName, clusterIds);
                OSchemaShared.this.classes.put(key, cls);
                if (cls.getShortName() != null) {
                    OSchemaShared.this.classes.put(cls.getShortName().toLowerCase(), cls);
                }
                if (iSuperClass != null) {
                    cls.setSuperClassInternal(iSuperClass);
                    int[] clustersToIndex = iSuperClass.getPolymorphicClusterIds();
                    String[] clusterNames = new String[clustersToIndex.length];
                    int i = 0;
                    while (i < clustersToIndex.length) {
                        clusterNames[i] = database.getClusterNameById(clustersToIndex[i]);
                        ++i;
                    }
                    for (OIndex<?> index : iSuperClass.getIndexes()) {
                        String[] stringArray = clusterNames;
                        int n = clusterNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String clusterName = stringArray[n2];
                            if (clusterName != null) {
                                index.getInternal().addCluster(clusterName);
                            }
                            ++n2;
                        }
                    }
                }
                return cls;
            }
        }, true);
    }

    public static Character checkNameIfValid(String iName) {
        if (iName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        int nameSize = (iName = iName.trim()).length();
        if (nameSize == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        int i = 0;
        while (i < nameSize) {
            char c = iName.charAt(i);
            if (c == ':' || c == ',' || c == ' ') {
                return Character.valueOf(c);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void dropClass(final String iClassName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a class inside a transaction");
        }
        if (iClassName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        final String key = iClassName.toLowerCase();
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OClass cls = OSchemaShared.this.classes.get(key);
                if (cls == null) {
                    throw new OSchemaException("Class " + iClassName + " was not found in current database");
                }
                if (cls.getBaseClasses().hasNext()) {
                    throw new OSchemaException("Class " + iClassName + " cannot be dropped because it has sub classes. Remove the dependencies before trying to drop it again");
                }
                StringBuilder cmd = new StringBuilder("drop class ");
                cmd.append(iClassName);
                Object result = OSchemaShared.this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
                if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                    OSchemaShared.this.classes.remove(key);
                }
                OSchemaShared.this.getDatabase().reload();
                OSchemaShared.this.reload();
                return null;
            }
        }, true);
    }

    public void dropClassInternal(final String iClassName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a class inside a transaction");
        }
        if (iClassName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        final String key = iClassName.toLowerCase();
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OClass cls = OSchemaShared.this.classes.get(key);
                if (cls == null) {
                    throw new OSchemaException("Class " + iClassName + " was not found in current database");
                }
                if (cls.getBaseClasses().hasNext()) {
                    throw new OSchemaException("Class " + iClassName + " cannot be dropped because it has sub classes. Remove the dependencies before trying to drop it again");
                }
                if (cls.getSuperClass() != null) {
                    ((OClassImpl)cls.getSuperClass()).removeBaseClassInternal(cls);
                }
                OSchemaShared.this.dropClassIndexes(cls);
                OSchemaShared.this.classes.remove(key);
                if (cls.getShortName() != null) {
                    OSchemaShared.this.classes.remove(cls.getShortName().toLowerCase());
                }
                return null;
            }
        }, true);
    }

    private void dropClassIndexes(OClass cls) {
        for (OIndex<?> index : this.getDatabase().getMetadata().getIndexManager().getClassIndexes(cls.getName())) {
            this.getDatabase().command(new OCommandSQL(DROP_INDEX_QUERY + index.getName()));
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OSchemaShared.this.reload(null);
                return null;
            }
        }, true);
        return (RET)this;
    }

    @Override
    public boolean existsClass(final String iClassName) {
        return this.getDatabase().getStorage().callInLock(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return OSchemaShared.this.classes.containsKey(iClassName.toLowerCase());
            }
        }, false);
    }

    @Override
    public OClass getClass(Class<?> iClass) {
        return this.getClass(iClass.getSimpleName());
    }

    @Override
    public OClass getClass(final String iClassName) {
        if (iClassName == null) {
            return null;
        }
        OClass cls = this.getDatabase().getStorage().callInLock(new Callable<OClass>(){

            @Override
            public OClass call() throws Exception {
                return OSchemaShared.this.classes.get(iClassName.toLowerCase());
            }
        }, false);
        if (cls == null) {
            cls = this.getDatabase().getStorage().callInLock(new Callable<OClass>(){

                @Override
                public OClass call() throws Exception {
                    Class<?> javaClass;
                    ODatabaseComplex<?> ownerDb;
                    OClass cls = OSchemaShared.this.classes.get(iClassName.toLowerCase());
                    if (cls == null && (ownerDb = OSchemaShared.this.getDatabase().getDatabaseOwner()) instanceof ODatabaseObject && (javaClass = ((ODatabaseObject)ownerDb).getEntityManager().getEntityClass(iClassName)) != null) {
                        cls = OSchemaShared.this.cascadeCreate(javaClass);
                    }
                    return cls;
                }
            }, true);
        }
        return cls;
    }

    public void changeClassName(final String iOldName, final String iNewName) {
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OClass clazz = OSchemaShared.this.classes.remove(iOldName.toLowerCase());
                OSchemaShared.this.classes.put(iNewName.toLowerCase(), clazz);
                return null;
            }
        }, true);
    }

    @Override
    public void fromStream() {
        final OSchemaShared me = this;
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OClassImpl cls;
                Integer schemaVersion = (Integer)OSchemaShared.this.document.field("schemaVersion");
                if (schemaVersion == null) {
                    OLogManager.instance().error((Object)this, "Database's schema is empty! Recreating the system classes and allow the opening of the database but double check the integrity of the database", new Object[0]);
                    return null;
                }
                if (schemaVersion != 4) {
                    throw new OConfigurationException("Database schema is different. Please export your old database with the previous version of OrientDB and reimport it using the current one.");
                }
                OSchemaShared.this.classes.clear();
                Collection storedClasses = (Collection)OSchemaShared.this.document.field("classes");
                for (ODocument c : storedClasses) {
                    cls = new OClassImpl(me, c);
                    cls.fromStream();
                    OSchemaShared.this.classes.put(cls.getName().toLowerCase(), cls);
                    if (cls.getShortName() == null) continue;
                    OSchemaShared.this.classes.put(cls.getShortName().toLowerCase(), cls);
                }
                for (ODocument c : storedClasses) {
                    String superClassName = (String)c.field("superClass");
                    if (superClassName == null) continue;
                    cls = (OClassImpl)OSchemaShared.this.classes.get(((String)c.field("name")).toLowerCase());
                    OClass superClass = OSchemaShared.this.classes.get(superClassName.toLowerCase());
                    if (superClass == null) {
                        throw new OConfigurationException("Super class '" + superClassName + "' was declared in class '" + cls.getName() + "' but was not found in schema. Remove the dependency or create the class to continue.");
                    }
                    cls.setSuperClassInternal(superClass);
                }
                return null;
            }
        }, true);
    }

    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        return this.getDatabase().getStorage().callInLock(new Callable<ODocument>(){

            @Override
            public ODocument call() throws Exception {
                OSchemaShared.this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
                try {
                    OSchemaShared.this.document.field("schemaVersion", 4);
                    HashSet<ODocument> cc = new HashSet<ODocument>();
                    for (OClass c : OSchemaShared.this.classes.values()) {
                        cc.add(((OClassImpl)c).toStream());
                    }
                    OSchemaShared.this.document.field("classes", cc, OType.EMBEDDEDSET);
                }
                finally {
                    OSchemaShared.this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
                }
                return OSchemaShared.this.document;
            }
        }, false);
    }

    @Override
    public Collection<OClass> getClasses() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        return this.getDatabase().getStorage().callInLock(new Callable<Collection<OClass>>(){

            @Override
            public HashSet<OClass> call() throws Exception {
                return new HashSet<OClass>(OSchemaShared.this.classes.values());
            }
        }, false);
    }

    @Override
    public Set<OClass> getClassesRelyOnCluster(final String iClusterName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        return this.getDatabase().getStorage().callInLock(new Callable<Set<OClass>>(){

            @Override
            public Set<OClass> call() throws Exception {
                int clusterId = OSchemaShared.this.getDatabase().getClusterIdByName(iClusterName);
                HashSet<OClass> result = new HashSet<OClass>();
                for (OClass c : OSchemaShared.this.classes.values()) {
                    if (!OArrays.contains((int[])c.getPolymorphicClusterIds(), (int)clusterId)) continue;
                    result.add(c);
                }
                return result;
            }
        }, false);
    }

    public OSchemaShared load() {
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OSchemaShared.this.getDatabase();
                ((ORecordId)OSchemaShared.this.document.getIdentity()).fromString(((OSchemaShared)OSchemaShared.this).getDatabase().getStorage().getConfiguration().schemaRecordId);
                OSchemaShared.this.reload("*:-1 index:0");
                return null;
            }
        }, true);
        return this;
    }

    @Override
    public void create() {
        ODatabaseRecord db = this.getDatabase();
        super.save("internal");
        db.getStorage().getConfiguration().schemaRecordId = this.document.getIdentity().toString();
        db.getStorage().getConfiguration().update();
    }

    public void close() {
        this.classes.clear();
        this.document.clear();
    }

    public void saveInternal() {
        ODatabaseRecord db = this.getDatabase();
        if (db.getTransaction().isActive()) {
            throw new OSchemaException("Cannot change the schema while a transaction is active. Schema changes are not transactional");
        }
        db.getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                OSchemaShared.this.saveInternal("internal");
                return null;
            }
        }, true);
    }

    @Override
    @Deprecated
    public int getVersion() {
        return this.getDatabase().getStorage().callInLock(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return OSchemaShared.this.document.getRecordVersion().getCounter();
            }
        }, false);
    }

    @Override
    public ORID getIdentity() {
        return this.document.getIdentity();
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        return (RET)this;
    }

    @Override
    public <RET extends ODocumentWrapper> RET save(String iClusterName) {
        return (RET)this;
    }

    public OSchemaShared setDirty() {
        this.document.setDirty();
        return this;
    }

    private OClass cascadeCreate(Class<?> javaClass) {
        OClassImpl cls = (OClassImpl)this.createClass(javaClass.getSimpleName());
        Class<?> javaSuperClass = javaClass.getSuperclass();
        if (javaSuperClass != null && !javaSuperClass.getName().equals("java.lang.Object") && !javaSuperClass.getName().startsWith("com.orientechnologies")) {
            OClass superClass = this.classes.get(javaSuperClass.getSimpleName().toLowerCase());
            if (superClass == null) {
                superClass = this.cascadeCreate(javaSuperClass);
            }
            cls.setSuperClass(superClass);
        }
        return cls;
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private void saveInternal(String iClusterName) {
        this.document.setDirty();
        int retry = 0;
        while (retry < 10) {
            try {
                super.save("internal");
                break;
            }
            catch (OConcurrentModificationException e) {
                this.reload(null, true);
                ++retry;
            }
        }
        super.save("internal");
    }
}

