/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Set;

public class ORestrictedAccessHook
extends ODocumentHookAbstract {
    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        OClass cls = iDocument.getSchemaClass();
        if (cls != null && cls.isSubClassOf("ORestricted")) {
            String fieldNames = ((OClassImpl)cls).getCustom("onCreate.fields");
            if (fieldNames == null) {
                fieldNames = "_allow";
            }
            String[] fields = fieldNames.split(",");
            String identityType = ((OClassImpl)cls).getCustom("onCreate.identityType");
            if (identityType == null) {
                identityType = "user";
            }
            ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
            ODocument identity = null;
            if (identityType.equals("user")) {
                identity = db.getUser().getDocument();
            } else if (identityType.equals("role")) {
                Set<ORole> roles = db.getUser().getRoles();
                if (!roles.isEmpty()) {
                    identity = roles.iterator().next().getDocument();
                }
            } else {
                throw new OConfigurationException("Wrong custom field 'onCreate.identityType' in class '" + cls.getName() + "' with value '" + identityType + "'. Supported ones are: 'user', 'role'");
            }
            if (identity != null) {
                for (String f : fields) {
                    db.getMetadata().getSecurity().allowIdentity(iDocument, f, identity);
                }
                return ORecordHook.RESULT.RECORD_CHANGED;
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument) {
        return this.isAllowed(iDocument, "_allowRead", false) ? ORecordHook.RESULT.RECORD_NOT_CHANGED : ORecordHook.RESULT.SKIP;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        if (!this.isAllowed(iDocument, "_allowUpdate", true)) {
            throw new OSecurityException("Cannot update record " + iDocument.getIdentity() + ": the resource has restricted access");
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        if (!this.isAllowed(iDocument, "_allowDelete", true)) {
            throw new OSecurityException("Cannot delete record " + iDocument.getIdentity() + ": the resource has restricted access");
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    protected boolean isAllowed(ODocument iDocument, String iAllowOperation, boolean iReadOriginal) {
        OClass cls = iDocument.getSchemaClass();
        if (cls != null && cls.isSubClassOf("ORestricted")) {
            ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.get();
            if (db.getUser() == null) {
                return true;
            }
            if (db.getUser().checkIfAllowed("database.bypassRestricted", ORole.PERMISSION_READ) != null) {
                return true;
            }
            ODocument doc = iReadOriginal ? (ODocument)db.load(iDocument.getIdentity()) : iDocument;
            return db.getMetadata().getSecurity().isAllowed((Set)doc.field("_allow"), (Set)doc.field(iAllowOperation));
        }
        return true;
    }
}

