/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OUser
extends ODocumentWrapper {
    private static final long serialVersionUID = 1L;
    public static final String ADMIN = "admin";
    public static final String CLASS_NAME = "OUser";
    protected Set<ORole> roles = new HashSet<ORole>();

    public OUser() {
    }

    public OUser(String iName) {
        super(CLASS_NAME);
        this.document.field("name", iName);
        this.setAccountStatus(STATUSES.ACTIVE);
    }

    public OUser(String iUserName, String iUserPassword) {
        super(CLASS_NAME);
        this.document.field("name", iUserName);
        this.setPassword(iUserPassword);
        this.setAccountStatus(STATUSES.ACTIVE);
    }

    public OUser(ODocument iSource) {
        this.fromStream(iSource);
    }

    @Override
    @OAfterDeserialization
    public void fromStream(ODocument iSource) {
        if (this.document != null) {
            return;
        }
        this.document = iSource;
        this.roles = new HashSet<ORole>();
        Collection loadedRoles = (Collection)iSource.field("roles");
        if (loadedRoles != null) {
            for (ODocument d : loadedRoles) {
                ORole role = this.document.getDatabase().getMetadata().getSecurity().getRole((String)d.field("name"));
                if (role == null) {
                    OLogManager.instance().warn((Object)this, "User '%s' declare to have the role '%s' but it does not exist in database, skipt it", new Object[]{this.getName(), d.field("name")});
                    this.document.getDatabase().getMetadata().getSecurity().repair();
                    continue;
                }
                this.roles.add(role);
            }
        }
    }

    public ORole allow(String iResource, int iOperation) {
        if (this.roles == null || this.roles.isEmpty()) {
            throw new OSecurityAccessException(this.document.getDatabase().getName(), "User '" + this.document.field("name") + "' has no role defined");
        }
        ORole role = this.checkIfAllowed(iResource, iOperation);
        if (role == null) {
            throw new OSecurityAccessException(this.document.getDatabase().getName(), "User '" + this.document.field("name") + "' has no the permission to execute the operation '" + ORole.permissionToString(iOperation) + "' against the resource: " + iResource);
        }
        return role;
    }

    public ORole checkIfAllowed(String iResource, int iOperation) {
        for (ORole r : this.roles) {
            if (r == null) {
                OLogManager.instance().warn((Object)this, "User '%s' has a null role, bypass it. Consider to fix this user roles before to continue", new Object[]{this.getName()});
                continue;
            }
            if (!r.allow(iResource, iOperation)) continue;
            return r;
        }
        return null;
    }

    public boolean isRuleDefined(String iResource) {
        for (ORole r : this.roles) {
            if (r == null) {
                OLogManager.instance().warn((Object)this, "User '%s' has a null role, bypass it. Consider to fix this user roles before to continue", new Object[]{this.getName()});
                continue;
            }
            if (!r.hasRule(iResource)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPassword(String iPassword) {
        return OSecurityManager.instance().check(iPassword, (String)this.document.field("password"));
    }

    public String getName() {
        return (String)this.document.field("name");
    }

    public String getPassword() {
        return (String)this.document.field("password");
    }

    public OUser setPassword(String iPassword) {
        this.document.field("password", iPassword);
        return this;
    }

    public static final String encryptPassword(String iPassword) {
        return OSecurityManager.instance().digest2String(iPassword, true);
    }

    public STATUSES getAccountStatus() {
        String status = (String)this.document.field("status");
        if (status == null) {
            throw new OSecurityException("User '" + this.getName() + "' has no status");
        }
        return STATUSES.valueOf(status);
    }

    public void setAccountStatus(STATUSES accountStatus) {
        this.document.field("status", (Object)accountStatus);
    }

    public Set<ORole> getRoles() {
        return this.roles;
    }

    public OUser addRole(String iRole) {
        if (iRole != null) {
            this.addRole(this.document.getDatabase().getMetadata().getSecurity().getRole(iRole));
        }
        return this;
    }

    public OUser addRole(ORole iRole) {
        if (iRole != null) {
            this.roles.add(iRole);
        }
        HashSet<ODocument> persistentRoles = new HashSet<ODocument>();
        for (ORole r : this.roles) {
            persistentRoles.add(r.toStream());
        }
        this.document.field("roles", persistentRoles);
        return this;
    }

    public OUser save() {
        this.document.save(OUser.class.getSimpleName());
        return this;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static enum STATUSES {
        SUSPENDED,
        ACTIVE;

    }
}

