/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.nativ;

import com.orientechnologies.orient.core.query.OQueryContext;
import com.orientechnologies.orient.core.query.OQueryHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class OQueryContextNative
extends OQueryContext {
    protected Boolean finalResult;
    protected Boolean partialResult;
    protected Object currentValue;

    public OQueryContextNative column(String iName) {
        this.field(iName);
        return this;
    }

    @Override
    public void setRecord(ODocument iRecord) {
        super.setRecord(iRecord);
        this.finalResult = null;
        this.partialResult = null;
        this.currentValue = null;
    }

    public OQueryContextNative field(String iName) {
        if (this.finalResult != null && this.finalResult.booleanValue()) {
            return this;
        }
        if (iName == null) {
            return this.error();
        }
        ODocument currentRecord = this.currentValue != null && this.currentValue instanceof ODocument ? (ODocument)this.currentValue : this.initialRecord;
        this.currentValue = currentRecord.field(iName);
        return this;
    }

    public OQueryContextNative key(Object iKey) {
        if (this.finalResult != null && this.finalResult.booleanValue()) {
            return this;
        }
        if (iKey == null) {
            return this.error();
        }
        if (this.currentValue != null && this.currentValue instanceof Map) {
            this.currentValue = ((Map)this.currentValue).get(iKey);
        }
        return this;
    }

    public OQueryContextNative contains(Object iKey) {
        if (this.finalResult != null && this.finalResult.booleanValue()) {
            return this;
        }
        if (iKey == null) {
            return this.error();
        }
        if (this.currentValue != null) {
            if (this.currentValue instanceof Map) {
                this.currentValue = ((Map)this.currentValue).containsKey(iKey);
            } else if (this.currentValue instanceof Collection) {
                this.currentValue = ((Collection)this.currentValue).contains(iKey);
            } else if (this.currentValue instanceof ODocument) {
                this.currentValue = ((ODocument)this.currentValue).containsField(iKey.toString());
            }
        }
        return this;
    }

    public OQueryContextNative and() {
        if (this.finalResult == null && this.partialResult != null && !this.partialResult.booleanValue()) {
            this.finalResult = false;
        }
        return this;
    }

    public OQueryContextNative or() {
        if (this.finalResult == null && this.partialResult != null && this.partialResult.booleanValue()) {
            this.finalResult = true;
        }
        return this;
    }

    public OQueryContextNative not() {
        if (this.finalResult == null && this.partialResult != null) {
            this.partialResult = this.partialResult == false;
        }
        return this;
    }

    public OQueryContextNative like(String iValue) {
        if (this.checkOperator()) {
            this.partialResult = OQueryHelper.like(this.currentValue.toString(), iValue);
        }
        return this;
    }

    public OQueryContextNative matches(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = this.currentValue.toString().matches(iValue.toString());
        }
        return this;
    }

    public OQueryContextNative eq(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = this.currentValue.equals(iValue);
        }
        return this;
    }

    public OQueryContextNative different(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = !this.currentValue.equals(iValue);
        }
        return this;
    }

    public OQueryContextNative between(Object iFrom, Object iTo) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iFrom) >= 0 && ((Comparable)this.currentValue).compareTo(iTo) <= 0;
        }
        return this;
    }

    public OQueryContextNative minor(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) < 0;
        }
        return this;
    }

    public OQueryContextNative minorEq(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) <= 0;
        }
        return this;
    }

    public OQueryContextNative major(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) > 0;
        }
        return this;
    }

    public OQueryContextNative majorEq(Object iValue) {
        if (this.checkOperator()) {
            this.partialResult = ((Comparable)this.currentValue).compareTo(iValue) >= 0;
        }
        return this;
    }

    public OQueryContextNative toInt() {
        if (this.checkOperator()) {
            this.currentValue = Integer.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative toLong() {
        if (this.checkOperator()) {
            this.currentValue = Long.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative toFloat() {
        if (this.checkOperator()) {
            this.currentValue = Float.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative toDouble() {
        if (this.checkOperator()) {
            this.currentValue = Double.valueOf(this.currentValue.toString());
        }
        return this;
    }

    public OQueryContextNative toChar() {
        if (this.checkOperator()) {
            this.currentValue = Character.valueOf(this.currentValue.toString().charAt(0));
        }
        return this;
    }

    public OQueryContextNative toDate() {
        if (this.checkOperator()) {
            this.currentValue = new Date(Long.valueOf(this.currentValue.toString()));
        }
        return this;
    }

    public boolean go() {
        return this.finalResult != null ? this.finalResult : (this.partialResult != null ? this.partialResult : false);
    }

    protected boolean checkOperator() {
        if (this.finalResult != null) {
            return false;
        }
        if (this.currentValue == null) {
            this.finalResult = false;
            return false;
        }
        return true;
    }

    protected OQueryContextNative error() {
        this.currentValue = null;
        this.finalResult = Boolean.FALSE;
        this.partialResult = null;
        return this;
    }
}

