/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ORecordSchemaAwareAbstract<T>
extends ORecordAbstract<T>
implements ORecordSchemaAware<T> {
    protected OClass _clazz;

    @Override
    public void validate() throws OValidationException {
        if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && !this.getDatabase().isValidationEnabled()) {
            return;
        }
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if (this._clazz != null) {
            if (this._clazz.isStrictMode()) {
                for (String f : this.fieldNames()) {
                    if (this._clazz.getProperty(f) != null) continue;
                    throw new OValidationException("Found additional field '" + f + "'. It cannot be added because the schema class '" + this._clazz.getName() + "' is defined as STRICT");
                }
            }
            for (OProperty p : this._clazz.properties()) {
                ORecordSchemaAwareAbstract.validateField(this, p);
            }
        }
    }

    @Override
    public OClass getSchemaClass() {
        if (this._clazz == null) {
            this.checkForLoading();
            this.checkForFields("@class");
        }
        return this._clazz;
    }

    @Override
    public String getClassName() {
        if (this._clazz != null) {
            return this._clazz.getName();
        }
        this.checkForLoading();
        this.checkForFields("@class");
        return this._clazz != null ? this._clazz.getName() : null;
    }

    @Override
    public void setClassName(String iClassName) {
        if (iClassName == null) {
            this._clazz = null;
            return;
        }
        this.setClass(this.getDatabase().getMetadata().getSchema().getOrCreateClass(iClassName));
    }

    @Override
    public void setClassNameIfExists(String iClassName) {
        if (iClassName == null) {
            this._clazz = null;
            return;
        }
        this.setClass(this.getDatabase().getMetadata().getSchema().getClass(iClassName));
    }

    @Override
    public ORecordSchemaAwareAbstract<T> reset() {
        super.reset();
        this._clazz = null;
        return this;
    }

    @Override
    public byte[] toStream() {
        return this.toStream(false);
    }

    public byte[] toStream(boolean iOnlyDelta) {
        if (this._source == null) {
            this._source = this._recordFormat.toStream(this, iOnlyDelta);
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected boolean checkForFields(String ... iFields) {
        if (this._status == ORecordElement.STATUS.LOADED && this.fields() == 0) {
            return this.deserializeFields(iFields);
        }
        return true;
    }

    public boolean deserializeFields(String ... iFields) {
        if (this._source == null) {
            return false;
        }
        this._status = ORecordElement.STATUS.UNMARSHALLING;
        this._recordFormat.fromStream(this._source, this, iFields);
        this._status = ORecordElement.STATUS.LOADED;
        return true;
    }

    protected void setClass(OClass iClass) {
        if (iClass != null && iClass.isAbstract()) {
            throw new OSchemaException("Cannot create a document of an abstract class");
        }
        this._clazz = iClass;
    }

    protected void checkFieldAccess(int iIndex) {
        if (iIndex < 0 || iIndex >= this.fields()) {
            throw new IndexOutOfBoundsException("Index " + iIndex + " is outside the range allowed: 0-" + this.fields());
        }
    }

    public static void validateField(ORecordSchemaAwareAbstract<?> iRecord, OProperty p) throws OValidationException {
        Object fieldValue;
        if (iRecord.containsField(p.getName())) {
            fieldValue = iRecord instanceof ODocument ? (Object)((ODocument)iRecord).rawField(p.getName()) : (Object)iRecord.field(p.getName());
            if (p.isNotNull() && fieldValue == null) {
                throw new OValidationException("The field '" + p.getFullName() + "' cannot be null");
            }
            if (fieldValue != null && p.getRegexp() != null && !fieldValue.toString().matches(p.getRegexp())) {
                throw new OValidationException("The field '" + p.getFullName() + "' does not match the regular expression '" + p.getRegexp() + "'. Field value is: " + fieldValue);
            }
        } else {
            if (p.isMandatory()) {
                throw new OValidationException("The field '" + p.getFullName() + "' is mandatory");
            }
            fieldValue = null;
        }
        OType type = p.getType();
        if (fieldValue != null && type != null) {
            switch (type) {
                case LINK: {
                    ORecordSchemaAwareAbstract.validateLink(p, fieldValue);
                    break;
                }
                case LINKLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() == null) break;
                    for (Object object : (List)fieldValue) {
                        ORecordSchemaAwareAbstract.validateLink(p, object);
                    }
                    break;
                }
                case LINKSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() == null) break;
                    for (Object object : (Set)fieldValue) {
                        ORecordSchemaAwareAbstract.validateLink(p, object);
                    }
                    break;
                }
                case LINKMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() == null) break;
                    for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                        ORecordSchemaAwareAbstract.validateLink(p, entry.getValue());
                    }
                    break;
                }
                case EMBEDDED: {
                    ORecordSchemaAwareAbstract.validateEmbedded(p, fieldValue);
                    break;
                }
                case EMBEDDEDLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object object : (List)fieldValue) {
                            ORecordSchemaAwareAbstract.validateEmbedded(p, object);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object object : (List)fieldValue) {
                            ORecordSchemaAwareAbstract.validateType(p, object);
                        }
                    }
                    break;
                }
                case EMBEDDEDSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object object : (Set)fieldValue) {
                            ORecordSchemaAwareAbstract.validateEmbedded(p, object);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object object : (Set)fieldValue) {
                            ORecordSchemaAwareAbstract.validateType(p, object);
                        }
                    }
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                            ORecordSchemaAwareAbstract.validateEmbedded(p, entry.getValue());
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                            ORecordSchemaAwareAbstract.validateType(p, entry.getValue());
                        }
                    }
                    break;
                }
            }
        }
        if (p.getMin() != null) {
            String min = p.getMin();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains fewer characters than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains fewer bytes than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) < Long.parseLong(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) < Float.parseFloat(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) < Double.parseDouble(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which precedes the first acceptable date (" + min + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the datetime " + fieldValue + " which precedes the first acceptable datetime (" + min + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if ((p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET)) && fieldValue != null && ((Collection)fieldValue).size() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains fewer items than " + min + " requested");
            }
        }
        if (p.getMax() != null) {
            String max = p.getMax();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains more characters than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains more bytes than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) > Long.parseLong(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) > Float.parseFloat(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) > Double.parseDouble(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which is after the last acceptable date (" + max + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the datetime " + fieldValue + " which is after the last acceptable datetime (" + max + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if ((p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET)) && fieldValue != null && ((Collection)fieldValue).size() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains more items than " + max + " requested");
            }
        }
        if (p.isReadonly() && iRecord instanceof ODocument && !iRecord.getRecordVersion().isTombstone()) {
            for (String f : ((ODocument)iRecord).getDirtyFields()) {
                boolean simple;
                if (!f.equals(p.getName())) continue;
                Object orgVal = ((ODocument)iRecord).getOriginalValue(f);
                boolean bl = simple = fieldValue != null ? OType.isSimpleType(fieldValue) : OType.isSimpleType(orgVal);
                if (!(simple || fieldValue != null && orgVal == null || fieldValue == null && orgVal != null) && fieldValue.equals(orgVal)) continue;
                throw new OValidationException("The field '" + p.getFullName() + "' is immutable and cannot be altered. Field value is: " + ((ODocument)iRecord).field(f));
            }
        }
    }

    protected static void validateType(OProperty p, Object value) {
        if (value != null && OType.convert(value, p.getLinkedType().getDefaultJavaType()) == null) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + (Object)((Object)p.getLinkedType()) + "' but the value is " + value);
        }
    }

    protected static void validateLink(OProperty p, Object fieldValue) {
        Object linkedRecord;
        if (fieldValue == null) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but contains a null record (probably a deleted record?)");
        }
        if (fieldValue instanceof OIdentifiable) {
            linkedRecord = ((OIdentifiable)fieldValue).getRecord();
        } else if (fieldValue instanceof String) {
            linkedRecord = new ORecordId((String)fieldValue).getRecord();
        } else {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is not a record or a record-id");
        }
        if (linkedRecord != null && p.getLinkedClass() != null) {
            if (!(linkedRecord instanceof ODocument)) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + p.getLinkedClass() + "' but the value is the record " + linkedRecord.getIdentity() + " that is not a document");
            }
            ODocument doc = (ODocument)linkedRecord;
            if (doc.getSchemaClass() != null && !p.getLinkedClass().isSuperClassOf(doc.getSchemaClass())) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + p.getLinkedClass().getName() + "' but the value is the document " + linkedRecord.getIdentity() + " of class '" + doc.getSchemaClass() + "'");
            }
        }
    }

    protected static void validateEmbedded(OProperty p, Object fieldValue) {
        if (fieldValue instanceof ORecordId) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is the RecordID " + fieldValue);
        }
        if (fieldValue instanceof OIdentifiable) {
            if (((OIdentifiable)fieldValue).getIdentity().isValid()) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is a document with the valid RecordID " + fieldValue);
            }
            OClass embeddedClass = p.getLinkedClass();
            if (embeddedClass != null) {
                Object rec = ((OIdentifiable)fieldValue).getRecord();
                if (!(rec instanceof ODocument)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record was not a document");
                }
                ODocument doc = (ODocument)rec;
                if (!doc.getSchemaClass().isSubClassOf(embeddedClass)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record is of class '" + doc.getSchemaClass().getName() + "' that is not a subclass of that");
                }
            }
        } else {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but an incompatible type is used. Value: " + fieldValue);
        }
    }
}

