/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.compression.impl;

import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.compression.OCompression;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class OGZIPCompression
implements OCompression {
    public static final String NAME = "gzip";
    public static final OGZIPCompression INSTANCE = new OGZIPCompression();

    @Override
    public byte[] compress(byte[] content) {
        try {
            OMemoryStream memoryOutputStream = new OMemoryStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(memoryOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.finish();
            return memoryOutputStream.toByteArray();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception during data compression.", ioe);
        }
    }

    @Override
    public byte[] uncompress(byte[] content) {
        try {
            int bytesRead;
            OMemoryInputStream memoryInputStream = new OMemoryInputStream(content);
            GZIPInputStream gzipInputStream = new GZIPInputStream(memoryInputStream);
            byte[] buffer = new byte[1024];
            byte[] result = new byte[1024];
            int len = 0;
            while ((bytesRead = gzipInputStream.read(buffer, 0, buffer.length)) > -1) {
                if (len + bytesRead > result.length) {
                    int newSize = 2 * result.length;
                    if (newSize < len + bytesRead) {
                        newSize = Integer.MAX_VALUE;
                    }
                    byte[] oldResult = result;
                    result = new byte[newSize];
                    System.arraycopy(oldResult, 0, result, 0, oldResult.length);
                }
                System.arraycopy(buffer, 0, result, len, bytesRead);
                len += bytesRead;
            }
            return Arrays.copyOf(result, len);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Exception during data uncompression.", ioe);
        }
    }

    @Override
    public String name() {
        return NAME;
    }
}

