/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBinaryTypeSerializer;
import com.orientechnologies.common.serialization.types.OBooleanSerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OCharSerializer;
import com.orientechnologies.common.serialization.types.ODateSerializer;
import com.orientechnologies.common.serialization.types.ODateTimeSerializer;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.ODoubleSerializer;
import com.orientechnologies.common.serialization.types.OFloatSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.common.serialization.types.OStringSerializer;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterPositionSerializer;
import com.orientechnologies.orient.core.storage.impl.local.eh.OPhysicalPositionSerializer;
import java.util.HashMap;
import java.util.Map;

public class OBinarySerializerFactory {
    private final Map<Byte, OBinarySerializer<?>> serializerIdMap = new HashMap();
    private final Map<Byte, Class<? extends OBinarySerializer<?>>> serializerClassesIdMap = new HashMap();
    private final Map<OType, OBinarySerializer<?>> serializerTypeMap = new HashMap();
    public static final OBinarySerializerFactory INSTANCE = new OBinarySerializerFactory();
    public static final int TYPE_IDENTIFIER_SIZE = 1;

    private OBinarySerializerFactory() {
        this.registerSerializer((OBinarySerializer<?>)new ONullSerializer(), null);
        this.registerSerializer((OBinarySerializer<?>)OBooleanSerializer.INSTANCE, OType.BOOLEAN);
        this.registerSerializer((OBinarySerializer<?>)OIntegerSerializer.INSTANCE, OType.INTEGER);
        this.registerSerializer((OBinarySerializer<?>)OShortSerializer.INSTANCE, OType.SHORT);
        this.registerSerializer((OBinarySerializer<?>)OLongSerializer.INSTANCE, OType.LONG);
        this.registerSerializer((OBinarySerializer<?>)OFloatSerializer.INSTANCE, OType.FLOAT);
        this.registerSerializer((OBinarySerializer<?>)ODoubleSerializer.INSTANCE, OType.DOUBLE);
        this.registerSerializer((OBinarySerializer<?>)ODateTimeSerializer.INSTANCE, OType.DATETIME);
        this.registerSerializer((OBinarySerializer<?>)OCharSerializer.INSTANCE, null);
        this.registerSerializer((OBinarySerializer<?>)OStringSerializer.INSTANCE, OType.STRING);
        this.registerSerializer((OBinarySerializer<?>)OByteSerializer.INSTANCE, OType.BYTE);
        this.registerSerializer((OBinarySerializer<?>)ODateSerializer.INSTANCE, OType.DATE);
        this.registerSerializer(OLinkSerializer.INSTANCE, OType.LINK);
        this.registerSerializer(OCompositeKeySerializer.INSTANCE, null);
        this.registerSerializer(OStreamSerializerRID.INSTANCE, null);
        this.registerSerializer((OBinarySerializer<?>)OBinaryTypeSerializer.INSTANCE, OType.BINARY);
        this.registerSerializer((OBinarySerializer<?>)ODecimalSerializer.INSTANCE, OType.DECIMAL);
        this.registerSerializer(OStreamSerializerListRID.INSTANCE, null);
        this.registerSerializer(OPhysicalPositionSerializer.INSTANCE, null);
        this.registerSerializer(OClusterPositionSerializer.INSTANCE, null);
        this.registerSerializer((byte)15, OSimpleKeySerializer.class);
    }

    public void registerSerializer(OBinarySerializer<?> iInstance, OType iType) {
        if (this.serializerIdMap.containsKey(iInstance.getId())) {
            throw new IllegalArgumentException("Binary serializer with id " + iInstance.getId() + " has been already registered.");
        }
        this.serializerIdMap.put(iInstance.getId(), iInstance);
        if (iType != null) {
            this.serializerTypeMap.put(iType, iInstance);
        }
    }

    public void registerSerializer(byte iId, Class<? extends OBinarySerializer> iClass) {
        if (this.serializerClassesIdMap.containsKey(iId)) {
            throw new IllegalStateException("Serializer with id " + iId + " has been already registered.");
        }
        this.serializerClassesIdMap.put(iId, iClass);
    }

    public OBinarySerializer<?> getObjectSerializer(byte identifier) {
        Class<OBinarySerializer<?>> cls;
        OBinarySerializer<?> impl = this.serializerIdMap.get(identifier);
        if (impl == null && (cls = this.serializerClassesIdMap.get(identifier)) != null) {
            try {
                impl = cls.newInstance();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot create an instance of class %s invoking the empty constructor", new Object[]{cls});
            }
        }
        return impl;
    }

    public OBinarySerializer<?> getObjectSerializer(OType type) {
        return this.serializerTypeMap.get((Object)type);
    }
}

