/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;

public class OLinkSerializer
implements OBinarySerializer<OIdentifiable> {
    private static final int CLUSTER_POS_SIZE = OClusterPositionFactory.INSTANCE.getSerializedSize();
    public static OLinkSerializer INSTANCE = new OLinkSerializer();
    public static final byte ID = 9;
    public static final int RID_SIZE = 2 + CLUSTER_POS_SIZE;

    public int getObjectSize(OIdentifiable rid) {
        return RID_SIZE;
    }

    public void serialize(OIdentifiable rid, byte[] stream, int startPosition) {
        ORID r = rid.getIdentity();
        OBinaryProtocol.short2bytes((short)r.getClusterId(), stream, startPosition);
        System.arraycopy(r.getClusterPosition().toStream(), 0, stream, startPosition + 2, CLUSTER_POS_SIZE);
    }

    public ORecordId deserialize(byte[] stream, int startPosition) {
        return new ORecordId(OBinaryProtocol.bytes2short(stream, startPosition), OClusterPositionFactory.INSTANCE.fromStream(stream, startPosition + 2));
    }

    public int getObjectSize(byte[] stream, int startPosition) {
        return RID_SIZE;
    }

    public byte getId() {
        return 9;
    }

    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return RID_SIZE;
    }

    public void serializeNative(OIdentifiable rid, byte[] stream, int startPosition) {
        ORID r = rid.getIdentity();
        OShortSerializer.INSTANCE.serializeNative(Short.valueOf((short)r.getClusterId()), stream, startPosition);
        System.arraycopy(r.getClusterPosition().toStream(), 0, stream, startPosition + 2, CLUSTER_POS_SIZE);
    }

    public ORecordId deserializeNative(byte[] stream, int startPosition) {
        short clusterId = OShortSerializer.INSTANCE.deserializeNative(stream, startPosition);
        OClusterPosition clusterPosition = OClusterPositionFactory.INSTANCE.fromStream(stream, startPosition + 2);
        return new ORecordId(clusterId, clusterPosition);
    }

    public void serializeInDirectMemory(OIdentifiable rid, ODirectMemory memory, long pointer) {
        ORID r = rid.getIdentity();
        OShortSerializer.INSTANCE.serializeInDirectMemory(Short.valueOf((short)r.getClusterId()), memory, pointer);
        memory.set(pointer + 2L, r.getClusterPosition().toStream(), 0, CLUSTER_POS_SIZE);
    }

    public OIdentifiable deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        short clusterId = OShortSerializer.INSTANCE.deserializeFromDirectMemory(memory, pointer);
        OClusterPosition clusterPosition = OClusterPositionFactory.INSTANCE.fromStream(memory.get(pointer + 2L, CLUSTER_POS_SIZE));
        return new ORecordId(clusterId, clusterPosition);
    }

    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return RID_SIZE;
    }

    public boolean isFixedLength() {
        return true;
    }

    public int getFixedLength() {
        return RID_SIZE;
    }
}

