/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;

public class OSimpleKeySerializer<T extends Comparable<?>>
implements OBinarySerializer<T> {
    private OType type;
    private OBinarySerializer binarySerializer;
    public static final byte ID = 15;
    public static final String NAME = "bsks";

    public OSimpleKeySerializer() {
    }

    public OSimpleKeySerializer(OType iType) {
        this.type = iType;
        this.binarySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.type);
    }

    public int getObjectSize(T key) {
        this.init(key);
        return 1 + this.binarySerializer.getObjectSize(key);
    }

    public void serialize(T key, byte[] stream, int startPosition) {
        this.init(key);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serialize(key, stream, ++startPosition);
        startPosition += this.binarySerializer.getObjectSize(key);
    }

    public T deserialize(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserialize(stream, ++startPosition));
    }

    public int getObjectSize(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSize(stream, startPosition + 1);
    }

    public byte getId() {
        return 15;
    }

    protected void init(T key) {
        if (this.binarySerializer == null) {
            this.type = OType.getTypeByClass(key.getClass());
            this.binarySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.type);
        }
    }

    protected void init(byte serializerId) {
        if (this.binarySerializer == null) {
            this.binarySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(serializerId);
        }
    }

    public int getObjectSizeNative(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSizeNative(stream, startPosition + 1);
    }

    public void serializeNative(T key, byte[] stream, int startPosition) {
        this.init(key);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serializeNative(key, stream, ++startPosition);
    }

    public T deserializeNative(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeNative(stream, ++startPosition));
    }

    public void serializeInDirectMemory(T object, ODirectMemory memory, long pointer) {
        this.init(object);
        memory.setByte(pointer++, this.binarySerializer.getId());
        this.binarySerializer.serializeInDirectMemory(object, memory, pointer);
    }

    public T deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        byte typeId = memory.getByte(pointer++);
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserializeFromDirectMemory(memory, pointer));
    }

    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return this.binarySerializer.getObjectSizeInDirectMemory(memory, pointer);
    }

    public boolean isFixedLength() {
        return this.binarySerializer.isFixedLength();
    }

    public int getFixedLength() {
        return this.binarySerializer.getFixedLength() + 1;
    }
}

