/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Date;

public class ORecordSerializerDocument2Binary
implements ORecordSerializer {
    public static final String NAME = "ORecordDocument2binary";

    protected ORecordSchemaAware<?> newObject(ODatabaseRecord iDatabase, String iClassName) throws InstantiationException, IllegalAccessException {
        return new ODocument();
    }

    public ORecordInternal<?> fromStream(ODatabaseRecord iDatabase, byte[] iSource) {
        return this.fromStream(iSource, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> fromStream(byte[] iSource, ORecordInternal<?> iRecord, String[] iFields) {
        ODocument record = (ODocument)iRecord;
        if (iRecord == null) {
            record = new ODocument();
        }
        ByteArrayInputStream stream = null;
        FilterInputStream in = null;
        try {
            stream = new ByteArrayInputStream(iSource);
            in = new DataInputStream(stream);
            for (OProperty p : record.getSchemaClass().properties()) {
                Object value = null;
                switch (p.getType()) {
                    case BINARY: {
                        int length = ((DataInputStream)in).readInt();
                        if (length < 0) break;
                        byte[] buffer = new byte[length];
                        ((DataInputStream)in).readFully(buffer);
                        value = buffer;
                        break;
                    }
                    case BOOLEAN: {
                        value = ((DataInputStream)in).readBoolean();
                        break;
                    }
                    case DATE: 
                    case DATETIME: {
                        long date = ((DataInputStream)in).readLong();
                        if (date <= -1L) break;
                        value = new Date(date);
                        break;
                    }
                    case DOUBLE: {
                        value = ((DataInputStream)in).readDouble();
                        break;
                    }
                    case EMBEDDED: {
                        int length = ((DataInputStream)in).readInt();
                        if (length < 0) break;
                        byte[] buffer = new byte[length];
                        ((DataInputStream)in).readFully(buffer);
                        value = new ODocument(p.getLinkedClass().getName()).fromStream(buffer);
                        break;
                    }
                    case EMBEDDEDLIST: {
                        break;
                    }
                    case EMBEDDEDSET: {
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(((DataInputStream)in).readFloat());
                        break;
                    }
                    case INTEGER: {
                        value = ((DataInputStream)in).readInt();
                        break;
                    }
                    case LINK: {
                        value = new ORecordId(((DataInputStream)in).readInt(), OClusterPositionFactory.INSTANCE.fromStream(in));
                        break;
                    }
                    case LINKLIST: {
                        break;
                    }
                    case LINKSET: {
                        break;
                    }
                    case LONG: {
                        value = ((DataInputStream)in).readLong();
                        break;
                    }
                    case SHORT: {
                        value = ((DataInputStream)in).readShort();
                        break;
                    }
                    case STRING: {
                        value = ((DataInputStream)in).readUTF();
                    }
                }
                record.field(p.getName(), value);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on unmarshalling object in binary format: " + record.getIdentity(), (Throwable)e, new Object[0]);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return iRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toStream(ORecordInternal<?> iRecord, boolean iOnlyDelta) {
        ODocument record = (ODocument)iRecord;
        ByteArrayOutputStream stream = null;
        DataOutputStream out = null;
        try {
            stream = new ByteArrayOutputStream();
            out = new DataOutputStream(stream);
            for (OProperty p : record.getSchemaClass().properties()) {
                Object value = record.field(p.getName());
                switch (p.getType()) {
                    case BINARY: {
                        if (value == null) {
                            out.writeInt(-1);
                            break;
                        }
                        byte[] buffer = (byte[])value;
                        out.writeInt(buffer.length);
                        out.write(buffer);
                        break;
                    }
                    case BOOLEAN: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeBoolean((Boolean)value);
                        break;
                    }
                    case DATE: 
                    case DATETIME: {
                        out.writeLong(value != null ? ((Date)value).getTime() : -1L);
                        break;
                    }
                    case DOUBLE: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeDouble((Double)value);
                        break;
                    }
                    case EMBEDDED: {
                        if (value == null) {
                            out.writeInt(-1);
                            break;
                        }
                        byte[] buffer = ((ORecordInternal)value).toStream();
                        out.writeInt(buffer.length);
                        out.write(buffer);
                        break;
                    }
                    case EMBEDDEDLIST: {
                        break;
                    }
                    case EMBEDDEDSET: {
                        break;
                    }
                    case FLOAT: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeFloat(((Float)value).floatValue());
                        break;
                    }
                    case INTEGER: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeInt((Integer)value);
                        break;
                    }
                    case LINK: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        if (!(value instanceof ORecord)) {
                            throw new ODatabaseException("Invalid property value in '" + p.getName() + "': found " + value.getClass() + " while it was expected a ORecord");
                        }
                        ORID rid = ((ORecord)value).getIdentity();
                        out.writeInt(rid.getClusterId());
                        out.write(rid.getClusterPosition().toStream());
                        break;
                    }
                    case LINKLIST: {
                        break;
                    }
                    case LINKSET: {
                        break;
                    }
                    case LONG: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeLong((Long)value);
                        break;
                    }
                    case SHORT: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeShort(((Short)value).shortValue());
                        break;
                    }
                    case STRING: {
                        out.writeBoolean(value != null);
                        if (value == null) break;
                        out.writeUTF((String)value);
                    }
                }
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on marshalling object in binary format: " + iRecord.getIdentity(), (Throwable)e, new Object[0]);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
        return null;
    }

    public String toString() {
        return NAME;
    }
}

