/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class OStreamSerializerAnyStatic
implements OStreamSerializer {
    public static final String NAME = "as";
    private Constructor<?> constructor;

    public OStreamSerializerAnyStatic(Class<?> iClazz) throws SecurityException, NoSuchMethodException {
        this.constructor = iClazz.getConstructor(String.class);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        try {
            return this.constructor.newInstance(new Object[]{iStream});
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on unmarshalling content of class: " + this.constructor.getDeclaringClass(), (Throwable)e, OSerializationException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        return OBinaryProtocol.string2bytes(iObject.toString());
    }
}

