/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;

public class OStreamSerializerRID
implements OStreamSerializer,
OBinarySerializer<OIdentifiable> {
    public static final String NAME = "p";
    public static final OStreamSerializerRID INSTANCE = new OStreamSerializerRID();
    public static final byte ID = 16;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null) {
            return null;
        }
        return new ORecordId().fromStream(iStream);
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        return ((OIdentifiable)iObject).getIdentity().toStream();
    }

    public int getObjectSize(OIdentifiable object) {
        return OLinkSerializer.INSTANCE.getObjectSize(object.getIdentity());
    }

    public void serialize(OIdentifiable object, byte[] stream, int startPosition) {
        OLinkSerializer.INSTANCE.serialize(object.getIdentity(), stream, startPosition);
    }

    public ORID deserialize(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.deserialize(stream, startPosition);
    }

    public int getObjectSize(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.getObjectSize(stream, startPosition);
    }

    public byte getId() {
        return 16;
    }

    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.getObjectSizeNative(stream, startPosition);
    }

    public void serializeNative(OIdentifiable object, byte[] stream, int startPosition) {
        OLinkSerializer.INSTANCE.serializeNative(object.getIdentity(), stream, startPosition);
    }

    public OIdentifiable deserializeNative(byte[] stream, int startPosition) {
        return OLinkSerializer.INSTANCE.deserializeNative(stream, startPosition);
    }

    public void serializeInDirectMemory(OIdentifiable object, ODirectMemory memory, long pointer) {
        OLinkSerializer.INSTANCE.serializeInDirectMemory(object, memory, pointer);
    }

    public OIdentifiable deserializeFromDirectMemory(ODirectMemory memory, long pointer) {
        return OLinkSerializer.INSTANCE.deserializeFromDirectMemory(memory, pointer);
    }

    public int getObjectSizeInDirectMemory(ODirectMemory memory, long pointer) {
        return OLinkSerializer.INSTANCE.getObjectSizeInDirectMemory(memory, pointer);
    }

    public boolean isFixedLength() {
        return true;
    }

    public int getFixedLength() {
        return OLinkSerializer.RID_SIZE;
    }
}

