/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLCreateFunction
extends OCommandExecutorSQLAbstract {
    public static final String NAME = "CREATE FUNCTION";
    private String name;
    private String code;
    private String language;
    private boolean idempotent = false;
    private List<String> parameters = null;

    public OCommandExecutorSQLCreateFunction parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLCreateFunction.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        this.parserRequiredKeyword(new String[]{"CREATE"});
        this.parserRequiredKeyword(new String[]{"FUNCTION"});
        this.parserNextWord(false);
        this.name = this.parserGetLastWord();
        this.parserNextWord(false);
        this.code = OStringSerializerHelper.getStringContent(this.parserGetLastWord());
        String temp = this.parseOptionalWord(true, new String[0]);
        while (temp != null) {
            if (temp.equals("IDEMPOTENT")) {
                this.parserNextWord(false);
                this.idempotent = Boolean.parseBoolean(this.parserGetLastWord());
            } else if (temp.equals("LANGUAGE")) {
                this.parserNextWord(false);
                this.language = this.parserGetLastWord();
            } else if (temp.equals("PARAMETERS")) {
                this.parserNextWord(false);
                this.parameters = new ArrayList<String>();
                OStringSerializerHelper.getCollection(this.parserGetLastWord(), 0, this.parameters);
                if (this.parameters.size() == 0) {
                    throw new OCommandExecutionException("Syntax Error. Missing function parameter(s): " + this.getSyntax());
                }
            }
            temp = this.parserOptionalWord(true);
            if (!this.parserIsEnded()) continue;
            break;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.name.isEmpty()) {
            throw new OCommandExecutionException("Syntax Error. You must specify a function name: " + this.getSyntax());
        }
        if (this.code == null || this.code.isEmpty()) {
            throw new OCommandExecutionException("Syntax Error. You must specify the function code: " + this.getSyntax());
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateFunction.getDatabase();
        OFunction f = database.getMetadata().getFunctionLibrary().createFunction(this.name);
        f.setCode(this.code);
        f.setIdempotent(this.idempotent);
        if (this.parameters != null) {
            f.setParameters(this.parameters);
        }
        if (this.language != null) {
            f.setLanguage(this.language);
        }
        return f.getId();
    }

    public String getSyntax() {
        return "CREATE FUNCTION <name> <code> [PARAMETERS [<comma-separated list of parameters' name>]] [IDEMPOTENT true|false] [LANGUAGE <language>]";
    }
}

