/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class OCommandExecutorSQLCreateIndex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_INDEX = "INDEX";
    public static final String KEYWORD_ON = "ON";
    private String indexName;
    private OClass oClass;
    private String[] fields;
    private OClass.INDEX_TYPE indexType;
    private OType[] keyTypes;
    private byte serializerKeyId;

    public OCommandExecutorSQLCreateIndex parse(OCommandRequest iRequest) {
        int n;
        int n2;
        String[] stringArray;
        OCommandExecutorSQLCreateIndex.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        this.indexName = word.toString();
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1) {
            throw new OCommandSQLParsingException("Index type requested. Use " + this.getSyntax(), this.parserText, oldPos + 1);
        }
        if (word.toString().equals(KEYWORD_ON)) {
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) == -1) {
                throw new OCommandSQLParsingException("Expected class name. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            this.oClass = this.findClass(word.toString());
            if (this.oClass == null) {
                throw new OCommandExecutionException("Class " + word + " not found");
            }
            pos = this.parserTextUpperCase.indexOf(")");
            if (pos == -1) {
                throw new OCommandSQLParsingException("No right bracket found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            String props = this.parserText.substring(oldPos, pos).trim().substring(1);
            ArrayList<String> propList = new ArrayList<String>();
            stringArray = props.trim().split("\\s*,\\s*");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String propToIndex = stringArray[n];
                this.checkMapIndexSpecifier(propToIndex, this.parserText, oldPos);
                propList.add(propToIndex);
                ++n;
            }
            this.fields = new String[propList.size()];
            propList.toArray(this.fields);
            oldPos = pos + 1;
            pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
            if (pos == -1) {
                throw new OCommandSQLParsingException("Index type requested. Use " + this.getSyntax(), this.parserText, oldPos + 1);
            }
        } else if (this.indexName.indexOf(46) > 0) {
            String[] parts = this.indexName.split("\\.");
            this.oClass = this.findClass(parts[0]);
            if (this.oClass == null) {
                throw new OCommandExecutionException("Class " + parts[0] + " not found");
            }
            this.fields = new String[]{parts[1]};
        }
        this.indexType = OClass.INDEX_TYPE.valueOf(word.toString());
        if (this.indexType == null) {
            throw new OCommandSQLParsingException("Index type is null", this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true)) != -1 && !word.toString().equalsIgnoreCase("NULL")) {
            String typesString = this.parserTextUpperCase.substring(oldPos).trim();
            if (word.toString().equalsIgnoreCase("RUNTIME")) {
                oldPos = pos;
                pos = OCommandExecutorSQLCreateIndex.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
                this.serializerKeyId = Byte.parseByte(word.toString());
            } else {
                ArrayList<OType> keyTypeList = new ArrayList<OType>();
                stringArray = typesString.split("\\s*,\\s*");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String typeName = stringArray[n];
                    keyTypeList.add(OType.valueOf(typeName));
                    ++n;
                }
                this.keyTypes = new OType[keyTypeList.size()];
                keyTypeList.toArray(this.keyTypes);
                if (this.fields != null && this.fields.length != 0 && this.fields.length != this.keyTypes.length) {
                    throw new OCommandSQLParsingException("Count of fields doesn't match with count of property types. Fields: " + Arrays.toString(this.fields) + "; Types: " + Arrays.toString((Object[])this.keyTypes), this.parserText, oldPos);
                }
            }
        }
        return this;
    }

    private OClass findClass(String part) {
        return OCommandExecutorSQLCreateIndex.getDatabase().getMetadata().getSchema().getClass(part);
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        OIndex<?> idx;
        if (this.indexName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateIndex.getDatabase();
        if (this.fields == null || this.fields.length == 0) {
            idx = this.keyTypes != null ? database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), new OSimpleKeyIndexDefinition(this.keyTypes), null, null) : (this.serializerKeyId != 0 ? database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), new ORuntimeKeyIndexDefinition(this.serializerKeyId), null, null) : database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), null, null, null));
        } else if (this.keyTypes == null || this.keyTypes.length == 0) {
            idx = this.oClass.createIndex(this.indexName, this.indexType, this.fields);
        } else {
            OIndexDefinition idxDef = OIndexDefinitionFactory.createIndexDefinition(this.oClass, Arrays.asList(this.fields), Arrays.asList(this.keyTypes));
            idx = database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.name(), idxDef, this.oClass.getPolymorphicClusterIds(), null);
        }
        if (idx != null) {
            return idx.getSize();
        }
        return null;
    }

    private void checkMapIndexSpecifier(String fieldName, String text, int pos) {
        String[] fieldNameParts = fieldName.split("\\s+");
        if (fieldNameParts.length == 1) {
            return;
        }
        if (fieldNameParts.length == 3) {
            if ("by".equals(fieldNameParts[1].toLowerCase())) {
                try {
                    OPropertyMapIndexDefinition.INDEX_BY.valueOf(fieldNameParts[2].toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
                }
                return;
            }
            throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
        }
        throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
    }

    public String getSyntax() {
        return "CREATE INDEX <name> [ON <class-name> (prop-names)] <type> [<key-type>]";
    }
}

