/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLDropCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String clusterName;

    public OCommandExecutorSQLDropCluster parse(OCommandRequest iRequest) {
        OCommandExecutorSQLDropCluster.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLDropCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
            throw new OCommandSQLParsingException("Keyword CLUSTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropCluster.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)false)) == -1) {
            throw new OCommandSQLParsingException("Expected <cluster>. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.clusterName = word.toString();
        if (this.clusterName == null) {
            throw new OCommandSQLParsingException("Cluster is null. Use " + this.getSyntax(), this.parserText, pos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLDropCluster.getDatabase();
        int clusterId = database.getStorage().getClusterIdByName(this.clusterName);
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                return false;
            }
        }
        database.dropCluster(clusterId, true);
        return true;
    }

    protected boolean isClusterDeletable(int clusterId) {
        ODatabaseRecord database = OCommandExecutorSQLDropCluster.getDatabase();
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                return false;
            }
        }
        return true;
    }

    public String getSyntax() {
        return "DROP CLUSTER <cluster>";
    }
}

