/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLGrant
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_GRANT = "GRANT";
    private static final String KEYWORD_TO = "TO";

    public OCommandExecutorSQLGrant parse(OCommandRequest iRequest) {
        OCommandExecutorSQLGrant.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        this.privilege = 0;
        this.resource = null;
        this.role = null;
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLGrant.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)oldPos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals(KEYWORD_GRANT)) {
            throw new OCommandSQLParsingException("Keyword GRANT not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLGrant.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1) {
            throw new OCommandSQLParsingException("Invalid privilege", this.parserText, oldPos);
        }
        this.parsePrivilege(word, oldPos);
        pos = OCommandExecutorSQLGrant.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true);
        if (pos == -1 || !word.toString().equals("ON")) {
            throw new OCommandSQLParsingException("Keyword ON not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLGrant.nextWord((String)this.parserText, (String)this.parserText, (int)pos, (StringBuilder)word, (boolean)true)) == -1) {
            throw new OCommandSQLParsingException("Invalid resource", this.parserText, oldPos);
        }
        this.resource = word.toString();
        if ((pos = OCommandExecutorSQLGrant.nextWord((String)this.parserText, (String)this.parserTextUpperCase, (int)pos, (StringBuilder)word, (boolean)true)) == -1 || !word.toString().equals(KEYWORD_TO)) {
            throw new OCommandSQLParsingException("Keyword TO not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLGrant.nextWord((String)this.parserText, (String)this.parserText, (int)pos, (StringBuilder)word, (boolean)true)) == -1) {
            throw new OCommandSQLParsingException("Invalid role", this.parserText, oldPos);
        }
        String roleName = word.toString();
        this.role = OCommandExecutorSQLGrant.getDatabase().getMetadata().getSecurity().getRole(roleName);
        if (this.role == null) {
            throw new OCommandSQLParsingException("Invalid role: " + roleName);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.role == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.role.grant(this.resource, this.privilege);
        this.role.save();
        return this.role;
    }

    public String getSyntax() {
        return "GRANT <permission> ON <resource> TO <role>";
    }
}

