/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLTarget;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OCommandExecutorSQLResultsetAbstract
extends OCommandExecutorSQLAbstract
implements Iterator<OIdentifiable>,
Iterable<OIdentifiable> {
    protected static final String KEYWORD_FROM_2FIND = " FROM ";
    protected static final String KEYWORD_LET_2FIND = " LET ";
    protected OSQLAsynchQuery<ORecordSchemaAware<?>> request;
    protected OSQLTarget parsedTarget;
    protected OSQLFilter compiledFilter;
    protected Map<String, Object> let = null;
    protected Iterator<? extends OIdentifiable> target;
    protected Iterable<OIdentifiable> tempResult;
    protected int resultCount;
    protected int skip = 0;

    public OCommandExecutorSQLResultsetAbstract parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        this.init(textRequest);
        if (iRequest instanceof OSQLSynchQuery) {
            this.request = (OSQLSynchQuery)iRequest;
        } else if (iRequest instanceof OSQLAsynchQuery) {
            this.request = (OSQLAsynchQuery)iRequest;
        } else {
            this.request = new OSQLSynchQuery(textRequest.getText());
            if (textRequest.getResultListener() != null) {
                this.request.setResultListener(textRequest.getResultListener());
            }
        }
        return this;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    protected boolean assignTarget(Map<Object, Object> iArgs) {
        this.parameters = iArgs;
        if (this.parsedTarget == null) {
            return true;
        }
        if (iArgs != null && iArgs.size() > 0 && this.compiledFilter != null) {
            this.compiledFilter.bindParameters(iArgs);
        }
        if (this.target == null) {
            if (this.parsedTarget.getTargetClasses() != null) {
                this.searchInClasses();
            } else if (this.parsedTarget.getTargetClusters() != null) {
                this.searchInClusters();
            } else if (this.parsedTarget.getTargetRecords() != null) {
                this.target = this.parsedTarget.getTargetRecords().iterator();
            } else if (this.parsedTarget.getTargetVariable() != null) {
                Object var = this.getContext().getVariable(this.parsedTarget.getTargetVariable());
                if (var == null) {
                    this.target = Collections.EMPTY_LIST.iterator();
                    return true;
                }
                if (var instanceof OIdentifiable) {
                    ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                    list.add((OIdentifiable)var);
                    this.target = list.iterator();
                } else if (var instanceof Iterable) {
                    this.target = ((Iterable)var).iterator();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected Object getResult() {
        if (this.tempResult != null) {
            for (OIdentifiable d : this.tempResult) {
                if (d == null) continue;
                if (!(d instanceof OIdentifiable)) {
                    d = new ODocument().field("value", d);
                }
                this.request.getResultListener().result(d);
            }
        }
        if (this.request instanceof OSQLSynchQuery) {
            return ((OSQLSynchQuery)this.request).getResult();
        }
        return null;
    }

    protected boolean handleResult(OIdentifiable iRecord, boolean iCloneIt) {
        if (iRecord != null) {
            Object recordCopy;
            ++this.resultCount;
            Object object = recordCopy = iRecord instanceof ORecord ? ((ORecord)iRecord).copy() : iRecord.getIdentity().copy();
            if (recordCopy != null && this.request.getResultListener() != null) {
                this.request.getResultListener().result(recordCopy);
            }
            if (this.limit > -1 && this.resultCount >= this.limit) {
                return false;
            }
        }
        return true;
    }

    protected void parseLet() {
        this.let = new LinkedHashMap<String, Object>();
        boolean stop = false;
        while (!stop) {
            this.parserNextWord(false);
            String letName = this.parserGetLastWord();
            this.parserOptionalKeyword(new String[]{"="});
            this.parserNextWord(false, " =><,\r\n");
            String letValueAsString = this.parserGetLastWord();
            OSQLFunctionRuntime func = OSQLHelper.getFunction(this.parsedTarget, letValueAsString);
            Object letValue = func != null ? func : (letValueAsString.startsWith("(") ? new OSQLSynchQuery(letValueAsString.substring(1, letValueAsString.length() - 1)) : letValueAsString);
            this.let.put(letName, letValue);
            boolean bl = stop = this.parserGetLastSeparator() == ' ';
        }
    }

    protected int parseLimit(String w) throws OCommandSQLParsingException {
        if (!w.equals("LIMIT")) {
            return -1;
        }
        this.parserNextWord(true);
        String word = this.parserGetLastWord();
        try {
            this.limit = Integer.parseInt(word);
        }
        catch (Exception e) {
            this.throwParsingException("Invalid LIMIT value setted to '" + word + "' but it should be a valid integer. Example: LIMIT 10");
        }
        if (this.limit == 0) {
            this.throwParsingException("Invalid LIMIT value setted to ZERO. Use -1 to ignore the limit or use a positive number. Example: LIMIT 10");
        }
        return this.limit;
    }

    protected int parseSkip(String w) throws OCommandSQLParsingException {
        if (!w.equals("SKIP")) {
            return -1;
        }
        this.parserNextWord(true);
        String word = this.parserGetLastWord();
        try {
            this.skip = Integer.parseInt(word);
        }
        catch (Exception e) {
            this.throwParsingException("Invalid SKIP value setted to '" + word + "' but it should be a valid positive integer. Example: SKIP 10");
        }
        if (this.skip < 0) {
            this.throwParsingException("Invalid SKIP value setted to the negative number '" + word + "'. Only positive numbers are valid. Example: SKIP 10");
        }
        return this.skip;
    }

    protected boolean filter(ORecordInternal<?> iRecord) {
        this.context.setVariable("current", iRecord);
        if (iRecord instanceof ORecordSchemaAware) {
            ORecordSchemaAware recordSchemaAware = (ORecordSchemaAware)iRecord;
            Map<OClass, String> targetClasses = this.parsedTarget.getTargetClasses();
            if (targetClasses != null && !targetClasses.isEmpty()) {
                for (OClass targetClass : targetClasses.keySet()) {
                    if (targetClass.isSuperClassOf(recordSchemaAware.getSchemaClass())) continue;
                    return false;
                }
                this.context.updateMetric("documentAnalyzedCompatibleClass", 1L);
            }
        }
        return this.evaluateRecord(iRecord);
    }

    protected boolean evaluateRecord(ORecord<?> iRecord) {
        this.assignLetClauses(iRecord);
        if (this.compiledFilter == null) {
            return true;
        }
        return (Boolean)this.compiledFilter.evaluate(iRecord, null, this.context);
    }

    protected void assignLetClauses(ORecord<?> iRecord) {
        if (this.let != null && !this.let.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.let.entrySet()) {
                Object varValue;
                Object letValue;
                String varName = entry.getKey();
                if (varName.startsWith("$")) {
                    varName = varName.substring(1);
                }
                if ((letValue = entry.getValue()) instanceof OSQLSynchQuery) {
                    OSQLSynchQuery subQuery = (OSQLSynchQuery)letValue;
                    subQuery.reset();
                    subQuery.resetPagination();
                    subQuery.setContext(this.context);
                    subQuery.getContext().setVariable("current", iRecord);
                    varValue = ODatabaseRecordThreadLocal.INSTANCE.get().query(subQuery, new Object[0]);
                } else if (letValue instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)letValue;
                    if (f.getFunction().aggregateResults()) {
                        f.execute(iRecord, null, this.context);
                        varValue = f.getFunction().getResult();
                    } else {
                        varValue = f.execute(iRecord, null, this.context);
                    }
                } else {
                    varValue = ODocumentHelper.getFieldValue(iRecord, ((String)letValue).trim(), this.context);
                }
                this.context.setVariable(varName, varValue);
            }
        }
    }

    protected void searchInClasses() {
        OClass cls = this.parsedTarget.getTargetClasses().keySet().iterator().next();
        ODatabaseRecord database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        database.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)cls.getName().toLowerCase());
        ORID[] range = this.getRange();
        this.target = new ORecordIteratorClass(database, (ODatabaseRecordAbstract)database, cls.getName(), true, this.request.isUseCache(), false).setRange(range[0], range[1]);
    }

    protected void searchInClusters() {
        ODatabaseRecord database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        HashSet<Integer> clusterIds = new HashSet<Integer>();
        for (String clusterName : this.parsedTarget.getTargetClusters().keySet()) {
            int clusterId;
            if (clusterName == null || clusterName.length() == 0) {
                throw new OCommandExecutionException("No cluster or schema class selected in query");
            }
            database.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)clusterName.toLowerCase());
            if (Character.isDigit(clusterName.charAt(0))) {
                int[] nArray = OStringSerializerHelper.splitIntArray(clusterName);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    clusterId = nArray[n2];
                    if (clusterId == -1) {
                        throw new OCommandExecutionException("Cluster '" + clusterName + "' not found");
                    }
                    clusterIds.add(clusterId);
                    ++n2;
                }
                continue;
            }
            clusterId = database.getClusterIdByName(clusterName.toLowerCase());
            if (clusterId == -1) {
                throw new OCommandExecutionException("Cluster '" + clusterName + "' not found");
            }
            clusterIds.add(clusterId);
        }
        int[] clIds = new int[clusterIds.size()];
        int i = 0;
        Iterator iterator = clusterIds.iterator();
        while (iterator.hasNext()) {
            int c = (Integer)iterator.next();
            clIds[i++] = c;
        }
        ORID[] range = this.getRange();
        this.target = new ORecordIteratorClusters(database, database, clIds, this.request.isUseCache(), false).setRange(range[0], range[1]);
    }

    protected void applyLimitAndSkip() {
        if (this.tempResult != null && (this.limit > 0 || this.skip > 0)) {
            ArrayList<OIdentifiable> newList = new ArrayList<OIdentifiable>();
            if (this.tempResult instanceof List) {
                List t = (List)this.tempResult;
                int start = Math.min(this.skip, t.size());
                int tot = Math.min(this.limit + start, t.size());
                int i = start;
                while (i < tot) {
                    newList.add((OIdentifiable)t.get(i));
                    ++i;
                }
                t.clear();
                this.tempResult = newList;
            }
        }
    }

    protected void optimize() {
        if (this.compiledFilter != null) {
            this.optimizeBranch(null, this.compiledFilter.getRootCondition());
        }
    }

    protected Object optimizeFunction(OSQLFunctionRuntime function) {
        return function;
    }

    protected void optimizeBranch(OSQLFilterCondition iParentCondition, OSQLFilterCondition iCondition) {
        if (iCondition == null) {
            return;
        }
        Object left = iCondition.getLeft();
        if (left instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)left);
        } else if (left instanceof OSQLFunctionRuntime) {
            left = this.optimizeFunction((OSQLFunctionRuntime)left);
            iCondition.setLeft(left);
        }
        Object right = iCondition.getRight();
        if (right instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)right);
        } else if (right instanceof OSQLFunctionRuntime) {
            right = this.optimizeFunction((OSQLFunctionRuntime)right);
            iCondition.setRight(right);
        }
        OQueryOperator oper = iCondition.getOperator();
        Boolean result = null;
        if (left instanceof OSQLFilterItemField && right instanceof OSQLFilterItemField && ((OSQLFilterItemField)left).getRoot().equals(((OSQLFilterItemField)right).getRoot())) {
            if (oper instanceof OQueryOperatorEquals) {
                result = Boolean.TRUE;
            } else if (oper instanceof OQueryOperatorNotEquals) {
                result = Boolean.FALSE;
            }
        }
        if (result != null) {
            if (iParentCondition != null) {
                if (iCondition == iParentCondition.getLeft()) {
                    iCondition.setLeft(result);
                } else {
                    iCondition.setRight(result);
                }
            } else if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                this.compiledFilter.setRootCondition(null);
            }
        }
    }

    protected ORID[] getRange() {
        ORID endRange;
        ORID beginRange;
        OSQLFilterCondition rootCondition;
        OSQLFilterCondition oSQLFilterCondition = rootCondition = this.compiledFilter == null ? null : this.compiledFilter.getRootCondition();
        if (this.compiledFilter == null || rootCondition == null) {
            beginRange = this.request instanceof OSQLSynchQuery ? ((OSQLSynchQuery)this.request).getNextPageRID() : null;
            endRange = null;
        } else {
            ORID conditionBeginRange = rootCondition.getBeginRidRange();
            ORID conditionEndRange = rootCondition.getEndRidRange();
            ORID nextPageRid = this.request instanceof OSQLSynchQuery ? ((OSQLSynchQuery)this.request).getNextPageRID() : null;
            beginRange = conditionBeginRange != null && nextPageRid != null ? (conditionBeginRange.compareTo(nextPageRid) > 0 ? conditionBeginRange : nextPageRid) : (conditionBeginRange != null ? conditionBeginRange : nextPageRid);
            endRange = conditionEndRange;
        }
        return new ORID[]{beginRange, endRange};
    }
}

