/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLUpdate
extends OCommandExecutorSQLSetAware
implements OCommandResultListener {
    public static final String KEYWORD_UPDATE = "UPDATE";
    private static final String KEYWORD_ADD = "ADD";
    private static final String KEYWORD_PUT = "PUT";
    private static final String KEYWORD_REMOVE = "REMOVE";
    private static final String KEYWORD_INCREMENT = "INCREMENT";
    private static final String KEYWORD_MERGE = "MERGE";
    private Map<String, Object> setEntries = new LinkedHashMap<String, Object>();
    private List<OPair<String, Object>> addEntries = new ArrayList<OPair<String, Object>>();
    private Map<String, OPair<String, Object>> putEntries = new LinkedHashMap<String, OPair<String, Object>>();
    private List<OPair<String, Object>> removeEntries = new ArrayList<OPair<String, Object>>();
    private Map<String, Number> incrementEntries = new LinkedHashMap<String, Number>();
    private ODocument merge = null;
    private OQuery<?> query;
    private OSQLFilter compiledFilter;
    private int recordCount = 0;
    private String subjectName;
    private static final Object EMPTY_VALUE = new Object();
    private OCommandParameters parameters;

    public OCommandExecutorSQLUpdate parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLUpdate.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init((OCommandRequestText)iRequest);
        this.setEntries.clear();
        this.addEntries.clear();
        this.putEntries.clear();
        this.removeEntries.clear();
        this.incrementEntries.clear();
        this.content = null;
        this.merge = null;
        this.query = null;
        this.recordCount = 0;
        this.parserRequiredKeyword(new String[]{KEYWORD_UPDATE});
        this.subjectName = this.parserRequiredWord(false, "Invalid target", " =><,\r\n");
        if (this.subjectName == null) {
            this.throwSyntaxErrorException("Invalid subject name. Expected cluster, class, index or sub-query");
        }
        this.parserNextWord(true);
        String word = this.parserGetLastWord();
        if (!(!this.parserIsEnded() && (word.equals("SET") || word.equals(KEYWORD_ADD) || word.equals(KEYWORD_PUT) || word.equals(KEYWORD_REMOVE) || word.equals(KEYWORD_INCREMENT) || word.equals("CONTENT") || word.equals(KEYWORD_MERGE)))) {
            this.throwSyntaxErrorException("Expected keyword SET,ADD,CONTENT,MERGE,PUT,REMOVE or INCREMENT");
        }
        while (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            word = this.parserGetLastWord();
            if (word.equals("CONTENT")) {
                this.parseContent();
            } else if (word.equals(KEYWORD_MERGE)) {
                this.parseMerge();
            } else if (word.equals("SET")) {
                this.parseSetFields(this.setEntries);
            } else if (word.equals(KEYWORD_ADD)) {
                this.parseAddFields();
            } else if (word.equals(KEYWORD_PUT)) {
                this.parsePutFields();
            } else if (word.equals(KEYWORD_REMOVE)) {
                this.parseRemoveFields();
            } else {
                if (!word.equals(KEYWORD_INCREMENT)) break;
                this.parseIncrementFields();
            }
            this.parserNextWord(true);
        }
        String additionalStatement = this.parserGetLastWord();
        if (this.subjectName.startsWith("(")) {
            this.subjectName = this.subjectName.trim();
            this.query = (OQuery)database.command(new OSQLAsynchQuery(this.subjectName.substring(1, this.subjectName.length() - 1), this).setContext(this.context));
            if (additionalStatement.equals("WHERE") || additionalStatement.equals("LIMIT")) {
                this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition()), this.getContext(), "WHERE");
            }
        } else if (additionalStatement.equals("WHERE") || additionalStatement.equals("LIMIT")) {
            this.query = new OSQLAsynchQuery("select from " + this.subjectName + " " + additionalStatement + " " + this.parserText.substring(this.parserGetCurrentPosition()), this);
        } else if (additionalStatement != null && !additionalStatement.isEmpty()) {
            this.throwSyntaxErrorException("Invalid keyword " + additionalStatement);
        } else {
            this.query = new OSQLAsynchQuery("select from " + this.subjectName, this);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.subjectName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.parameters = new OCommandParameters(iArgs);
        HashMap<Integer, Object> queryArgs = new HashMap<Integer, Object>();
        for (int i = this.parameterCounter; i < this.parameters.size(); ++i) {
            if (this.parameters.getByName(i) == null) continue;
            queryArgs.put(i - this.parameterCounter, this.parameters.getByName(i));
        }
        this.query.setUseCache(false);
        this.query.setContext(this.context);
        OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
        return this.recordCount;
    }

    @Override
    public boolean result(Object iRecord) {
        Map map;
        Object v;
        Object fieldValue;
        Collection<Object> coll;
        Set<ODocument> changedDocuments;
        ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
        if (this.compiledFilter != null && !((Boolean)this.compiledFilter.evaluate(record, null, this.context)).booleanValue()) {
            return false;
        }
        HashSet<ODocument> updatedRecords = new HashSet<ODocument>();
        this.parameters.reset();
        if (this.content != null) {
            record.clear();
            record.merge(this.content, false, false);
            updatedRecords.add(record);
        }
        if (this.merge != null) {
            record.merge(this.merge, true, false);
            updatedRecords.add(record);
        }
        if (!this.setEntries.isEmpty() && (changedDocuments = OSQLHelper.bindParameters(record, this.setEntries, this.parameters, this.context)) != null) {
            updatedRecords.addAll(changedDocuments);
        }
        for (Map.Entry<String, Number> entry : this.incrementEntries.entrySet()) {
            Number prevValue = (Number)record.field(entry.getKey());
            if (prevValue == null) {
                record.field(entry.getKey(), entry.getValue());
            } else {
                record.field(entry.getKey(), OType.increment(prevValue, entry.getValue()));
            }
            updatedRecords.add(record);
        }
        for (OPair<String, Object> entry : this.addEntries) {
            coll = null;
            if (!record.containsField((String)((Object)entry.getKey()))) {
                OProperty prop;
                if (record.getSchemaClass() != null && (prop = record.getSchemaClass().getProperty((String)((Object)entry.getKey()))) != null && prop.getType() == OType.LINKSET) {
                    coll = new HashSet();
                }
                if (coll == null) {
                    coll = new ArrayList();
                }
                record.field((String)((Object)entry.getKey()), coll);
            } else {
                fieldValue = record.field((String)((Object)entry.getKey()));
                if (!(fieldValue instanceof Collection)) continue;
                coll = (Collection)fieldValue;
            }
            v = entry.getValue();
            if (v instanceof OSQLFilterItem) {
                v = ((OSQLFilterItem)v).getValue(record, this.context);
            } else if (v instanceof OSQLFunctionRuntime) {
                v = ((OSQLFunctionRuntime)v).execute(record, null, this.context);
            }
            coll.add(v);
            updatedRecords.add(record);
        }
        for (Map.Entry<String, OPair<String, Object>> entry : this.putEntries.entrySet()) {
            fieldValue = record.field(entry.getKey());
            if (fieldValue == null) {
                OProperty property;
                if (record.getSchemaClass() != null && (property = record.getSchemaClass().getProperty(entry.getKey())) != null && property.getType() != null && !property.getType().equals((Object)OType.EMBEDDEDMAP) && !property.getType().equals((Object)OType.LINKMAP)) {
                    throw new OCommandExecutionException("field " + entry.getKey() + " is not defined as a map");
                }
                fieldValue = new HashMap();
                record.field(entry.getKey(), fieldValue);
            }
            if (!(fieldValue instanceof Map)) continue;
            map = (Map)fieldValue;
            OPair<String, Object> pair = entry.getValue();
            v = pair.getValue();
            if (v instanceof OSQLFilterItem) {
                v = ((OSQLFilterItem)v).getValue(record, this.context);
            } else if (pair.getValue() instanceof OSQLFunctionRuntime) {
                v = ((OSQLFunctionRuntime)v).execute(record, null, this.context);
            }
            map.put(pair.getKey(), v);
            updatedRecords.add(record);
        }
        for (OPair oPair : this.removeEntries) {
            v = oPair.getValue();
            if (v == EMPTY_VALUE) {
                record.removeField((String)((Object)oPair.getKey()));
                updatedRecords.add(record);
                continue;
            }
            fieldValue = record.field((String)((Object)oPair.getKey()));
            if (fieldValue instanceof Collection) {
                coll = (Collection)fieldValue;
                if (!coll.remove(v)) continue;
                updatedRecords.add(record);
                continue;
            }
            if (!(fieldValue instanceof Map) || (map = (Map)fieldValue).remove(v) == null) continue;
            updatedRecords.add(record);
        }
        for (ODocument oDocument : updatedRecords) {
            oDocument.setDirty();
            oDocument.save();
            ++this.recordCount;
        }
        return true;
    }

    protected void parseMerge() {
        if (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            String contentAsString = this.parserRequiredWord(false, "document to merge expected").trim();
            this.merge = (ODocument)new ODocument().fromJSON(contentAsString);
            this.parserSkipWhiteSpaces();
        }
        if (this.merge == null) {
            this.throwSyntaxErrorException("Document to merge not provided. Example: MERGE { \"name\": \"Jay\" }");
        }
    }

    private void parseAddFields() {
        while (!(this.parserIsEnded() || this.addEntries.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword(new String[]{"="});
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            this.addEntries.add((OPair<String, Object>)new OPair((Comparable)((Object)fieldName), this.getFieldValueCountingParameters(fieldValue)));
            this.parserSkipWhiteSpaces();
        }
        if (this.addEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to add <field> = <value> are missed. Example: name = 'Bill', salary = 300.2.");
        }
    }

    private void parsePutFields() {
        while (!(this.parserIsEnded() || this.putEntries.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword(new String[]{"="});
            String fieldKey = this.parserRequiredWord(false, "Key expected");
            String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected", " =><,\r\n"));
            this.putEntries.put(fieldName, (OPair<String, Object>)new OPair((Comparable)((Object)((String)this.getFieldValueCountingParameters(fieldKey))), this.getFieldValueCountingParameters(fieldValue)));
            this.parserSkipWhiteSpaces();
        }
        if (this.putEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to put <field> = <key>, <value> are missed. Example: name = 'Bill', 30");
        }
    }

    private void parseRemoveFields() {
        while (!(this.parserIsEnded() || this.removeEntries.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            Object value;
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            boolean found = this.parserOptionalKeyword(new String[]{"=", "WHERE"});
            if (found) {
                if (this.parserGetLastWord().equals("WHERE")) {
                    this.parserGoBack();
                    value = EMPTY_VALUE;
                } else {
                    String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected"));
                    value = this.getFieldValueCountingParameters(fieldValue);
                }
            } else {
                value = EMPTY_VALUE;
            }
            this.removeEntries.add((OPair<String, Object>)new OPair((Comparable)((Object)fieldName), value));
            this.parserSkipWhiteSpaces();
        }
        if (this.removeEntries.size() == 0) {
            this.throwSyntaxErrorException("Field(s) to remove are missed. Example: name, salary");
        }
    }

    private void parseIncrementFields() {
        while (!(this.parserIsEnded() || this.incrementEntries.size() != 0 && this.parserGetLastSeparator() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword(new String[]{"="});
            String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected"));
            this.incrementEntries.put(fieldName, (Number)this.getFieldValueCountingParameters(fieldValue));
            this.parserSkipWhiteSpaces();
        }
        if (this.incrementEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to increment <field> = <value> are missed. Example: salary = -100");
        }
    }

    public String getSyntax() {
        return "UPDATE <class>|cluster:<cluster>> [SET|ADD|PUT|REMOVE|INCREMENT|CONTENT {<JSON>}|MERGE {<JSON>}] [[,] <field-name> = <expression>|<sub-command>]* [WHERE <conditions>]";
    }

    @Override
    public void end() {
    }

    protected String getBlock(String fieldValue) {
        if (fieldValue.startsWith("{") || fieldValue.startsWith("[") || fieldValue.startsWith("[")) {
            this.parserSkipWhiteSpaces();
            StringBuilder buffer = new StringBuilder();
            this.parserSetCurrentPosition(OStringSerializerHelper.parse(this.parserText, buffer, this.parserGetCurrentPosition(), -1, OStringSerializerHelper.DEFAULT_FIELD_SEPARATOR, true, true, false, OStringSerializerHelper.DEFAULT_IGNORE_CHARS));
            fieldValue = buffer.toString();
        }
        return fieldValue;
    }
}

