/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import java.util.Map;

public class ORuntimeResult {
    private final Map<String, Object> projections;
    private final ODocument value;
    private OCommandContext context;

    public ORuntimeResult(Map<String, Object> iProjections, int iProgressive, OCommandContext iContext) {
        this.projections = iProjections;
        this.context = iContext;
        this.value = ORuntimeResult.createProjectionDocument(iProgressive);
    }

    public void applyRecord(OIdentifiable iRecord) {
        ORuntimeResult.applyRecord(this.value, this.projections, this.context, iRecord);
    }

    public void applyValue(String iName, Object iValue) {
        this.value.field(iName, iValue);
    }

    public ODocument getResult() {
        return ORuntimeResult.getResult(this.value, this.projections);
    }

    public static ODocument createProjectionDocument(int iProgressive) {
        ODocument doc = new ODocument().setOrdered(true);
        ((ORecordId)doc.getIdentity()).clusterId = -2;
        ((ORecordId)doc.getIdentity()).clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(iProgressive);
        return doc;
    }

    public static ODocument applyRecord(ODocument iValue, Map<String, Object> iProjections, OCommandContext iContext, OIdentifiable iRecord) {
        ODocument inputDocument = iRecord != null ? iRecord.getRecord() : null;
        if (iProjections.isEmpty()) {
            inputDocument.copyTo(iValue);
        } else {
            for (Map.Entry<String, Object> projection : iProjections.entrySet()) {
                Object projectionValue;
                Object v = projection.getValue();
                if (v == null) continue;
                if (v.equals("*")) {
                    inputDocument.copyTo(iValue);
                    projectionValue = null;
                } else if (v instanceof OSQLFilterItemVariable) {
                    projectionValue = ((OSQLFilterItemVariable)v).getValue(inputDocument, iContext);
                } else if (v instanceof OSQLFilterItemField) {
                    projectionValue = ((OSQLFilterItemField)v).getValue(inputDocument, iContext);
                } else if (v instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)v;
                    projectionValue = f.execute(inputDocument, iValue, iContext);
                } else {
                    projectionValue = v;
                }
                if (projectionValue == null) continue;
                iValue.field(projection.getKey(), projectionValue);
            }
        }
        return iValue;
    }

    public static ODocument getResult(ODocument iValue, Map<String, Object> iProjections) {
        if (iValue != null) {
            boolean canExcludeResult = false;
            for (Map.Entry<String, Object> projection : iProjections.entrySet()) {
                Object v;
                if (iValue.containsField(projection.getKey()) || !((v = projection.getValue()) instanceof OSQLFunctionRuntime)) continue;
                OSQLFunctionRuntime f = (OSQLFunctionRuntime)v;
                canExcludeResult = f.filterResult();
                Object fieldValue = f.getResult();
                if (fieldValue == null) continue;
                iValue.field(projection.getKey(), fieldValue);
            }
            if (canExcludeResult && iValue.isEmpty()) {
                return null;
            }
            iValue.unsetDirty();
        }
        return iValue;
    }

    public static ODocument getProjectionResult(int iId, Map<String, Object> iProjections, OCommandContext iContext, OIdentifiable iRecord) {
        return ORuntimeResult.getResult(ORuntimeResult.applyRecord(ORuntimeResult.createProjectionDocument(iId), iProjections, iContext, iRecord), iProjections);
    }
}

