/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;

public class OSQLFilterCondition {
    private static final String NULL_VALUE = "null";
    protected Object left;
    protected OQueryOperator operator;
    protected Object right;

    public OSQLFilterCondition(Object iLeft, OQueryOperator iOperator) {
        this.left = iLeft;
        this.operator = iOperator;
    }

    public OSQLFilterCondition(Object iLeft, OQueryOperator iOperator, Object iRight) {
        this.left = iLeft;
        this.operator = iOperator;
        this.right = iRight;
    }

    public Object evaluate(OIdentifiable iCurrentRecord, ODocument iCurrentResult, OCommandContext iContext) {
        Object result;
        Object r;
        Object l;
        Object[] convertedValues;
        if (this.left instanceof OSQLQuery) {
            this.left = ((OSQLQuery)this.left).setContext(iContext).execute(new Object[0]);
        }
        if (this.right instanceof OSQLQuery) {
            this.right = ((OSQLQuery)this.right).setContext(iContext).execute(new Object[0]);
        }
        if ((convertedValues = this.checkForConversion(iCurrentRecord, l = this.evaluate(iCurrentRecord, iCurrentResult, this.left, iContext), r = this.evaluate(iCurrentRecord, iCurrentResult, this.right, iContext))) != null) {
            l = convertedValues[0];
            r = convertedValues[1];
        }
        if (this.operator == null) {
            if (l == null) {
                return Boolean.FALSE;
            }
            return l;
        }
        try {
            result = this.operator.evaluateRecord(iCurrentRecord, iCurrentResult, this, l, r, iContext);
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }

    public ORID getBeginRidRange() {
        if (this.operator == null) {
            if (this.left instanceof OSQLFilterCondition) {
                return ((OSQLFilterCondition)this.left).getBeginRidRange();
            }
            return null;
        }
        return this.operator.getBeginRidRange(this.left, this.right);
    }

    public ORID getEndRidRange() {
        if (this.operator == null) {
            if (this.left instanceof OSQLFilterCondition) {
                return ((OSQLFilterCondition)this.left).getEndRidRange();
            }
            return null;
        }
        return this.operator.getEndRidRange(this.left, this.right);
    }

    private Object[] checkForConversion(OIdentifiable o, Object l, Object r) {
        Object[] result = null;
        if (r instanceof String && r.equals("_DEFINED_") || l instanceof String && l.equals("_DEFINED_")) {
            result = new Object[]{((OSQLFilterItemAbstract)this.left).getRoot(), r};
        } else if (r instanceof String && r.equals("_NOT_NULL_") || l instanceof String && l.equals("_NOT_NULL_")) {
            result = null;
        } else if (l != null && r != null && !l.getClass().isAssignableFrom(r.getClass()) && !r.getClass().isAssignableFrom(l.getClass())) {
            if (r instanceof Integer && !(l instanceof Number) && !(l instanceof Collection)) {
                if (l instanceof String && ((String)l).indexOf(46) > -1) {
                    result = new Object[]{new Float((String)l).intValue(), r};
                } else if (l instanceof Date) {
                    result = new Object[]{((Date)l).getTime(), r};
                } else if (!(l instanceof OQueryRuntimeValueMulti || l instanceof Collection || l.getClass().isArray() || l instanceof Map)) {
                    result = new Object[]{this.getInteger(l), r};
                }
            } else if (l instanceof Integer && !(r instanceof Number) && !(r instanceof Collection)) {
                if (r instanceof String && ((String)r).indexOf(46) > -1) {
                    result = new Object[]{l, new Float((String)r).intValue()};
                } else if (r instanceof Date) {
                    result = new Object[]{l, ((Date)r).getTime()};
                } else if (!(r instanceof OQueryRuntimeValueMulti || r instanceof Collection || r.getClass().isArray() || r instanceof Map)) {
                    result = new Object[]{l, this.getInteger(r)};
                }
            } else if (r instanceof Date && !(l instanceof Collection) && !(l instanceof Date)) {
                result = new Object[]{this.getDate(l), r};
            } else if (l instanceof Date && !(r instanceof Collection) && !(r instanceof Date)) {
                result = new Object[]{l, this.getDate(r)};
            } else if (r instanceof Float && !(l instanceof Float) && !(l instanceof Collection)) {
                result = new Object[]{this.getFloat(l), r};
            } else if (l instanceof Float && !(r instanceof Float) && !(r instanceof Collection)) {
                result = new Object[]{l, this.getFloat(r)};
            } else if (r instanceof ORID && l instanceof String && !l.equals("_NOT_NULL_")) {
                result = new Object[]{new ORecordId((String)l), r};
            } else if (l instanceof ORID && r instanceof String && !r.equals("_NOT_NULL_")) {
                result = new Object[]{l, new ORecordId((String)r)};
            }
        }
        return result;
    }

    protected Integer getInteger(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        if ("_DEFINED_".equals(stringValue)) {
            return null;
        }
        if (OStringSerializerHelper.contains(stringValue, '.') || OStringSerializerHelper.contains(stringValue, ',')) {
            return (int)Float.parseFloat(stringValue);
        }
        return stringValue.length() > 0 ? new Integer(stringValue) : new Integer(0);
    }

    protected Float getFloat(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        return stringValue.length() > 0 ? new Float(stringValue) : new Float(0.0f);
    }

    protected Date getDate(Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof Long) {
            return new Date((Long)iValue);
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        if (stringValue.length() <= 0) {
            return null;
        }
        if (Pattern.matches("^\\d+$", stringValue)) {
            return new Date(Long.valueOf(stringValue));
        }
        OStorageConfiguration config = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration();
        SimpleDateFormat formatter = config.getDateFormatInstance();
        if (stringValue.length() > config.dateFormat.length()) {
            formatter = config.getDateTimeFormatInstance();
        }
        try {
            return formatter.parse(stringValue);
        }
        catch (ParseException pe) {
            try {
                return new Date(new Double(stringValue).longValue());
            }
            catch (Exception pe2) {
                throw new OQueryParsingException("Error on conversion of date '" + stringValue + "' using the format: " + formatter.toPattern());
            }
        }
    }

    protected Object evaluate(OIdentifiable iCurrentRecord, ODocument iCurrentResult, Object iValue, OCommandContext iContext) {
        if (iCurrentRecord != null && iCurrentRecord.getRecord().getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                iCurrentRecord = iCurrentRecord.getRecord().load();
            }
            catch (ORecordNotFoundException e) {
                return null;
            }
        }
        if (iValue instanceof OSQLFilterItem) {
            Object v;
            if (iCurrentResult != null && (v = ((OSQLFilterItem)iValue).getValue(iCurrentResult, iContext)) != null) {
                return v;
            }
            return ((OSQLFilterItem)iValue).getValue(iCurrentRecord, iContext);
        }
        if (iValue instanceof OSQLFilterCondition) {
            return ((OSQLFilterCondition)iValue).evaluate(iCurrentRecord, iCurrentResult, iContext);
        }
        if (iValue instanceof OSQLFunctionRuntime) {
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)iValue;
            return f.execute(iCurrentRecord, iCurrentResult, iContext);
        }
        Iterable multiValue = OMultiValue.getMultiValueIterable((Object)iValue);
        if (multiValue != null) {
            ArrayList<Object> result = new ArrayList<Object>(OMultiValue.getSize((Object)iValue));
            for (Object value : multiValue) {
                if (value instanceof OSQLFilterItem) {
                    result.add(((OSQLFilterItem)value).getValue(iCurrentRecord, iContext));
                    continue;
                }
                result.add(value);
            }
            return result;
        }
        return iValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.left);
        if (this.operator != null) {
            buffer.append(' ');
            buffer.append(this.operator);
            buffer.append(' ');
            if (this.right instanceof String) {
                buffer.append('\'');
            }
            buffer.append(this.right);
            if (this.right instanceof String) {
                buffer.append('\'');
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    public Object getLeft() {
        return this.left;
    }

    public Object getRight() {
        return this.right;
    }

    public OQueryOperator getOperator() {
        return this.operator;
    }

    public void setLeft(Object iValue) {
        this.left = iValue;
    }

    public void setRight(Object iValue) {
        this.right = iValue;
    }
}

