/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDifference;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDistinct;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionFirst;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionIntersect;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionLast;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionList;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMap;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionSet;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionUnion;
import com.orientechnologies.orient.core.sql.functions.geo.OSQLFunctionDistance;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionAverage;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionEval;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMax;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMin;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionSum;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCoalesce;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionDate;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionDecode;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionEncode;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionFormat;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionIf;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionIfNull;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionSysdate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class ODefaultSQLFunctionFactory
implements OSQLFunctionFactory {
    private static final Map<String, Object> FUNCTIONS = new HashMap<String, Object>();

    static {
        FUNCTIONS.put("coalesce".toUpperCase(Locale.ENGLISH), new OSQLFunctionCoalesce());
        FUNCTIONS.put("if".toUpperCase(Locale.ENGLISH), new OSQLFunctionIf());
        FUNCTIONS.put("ifnull".toUpperCase(Locale.ENGLISH), new OSQLFunctionIfNull());
        FUNCTIONS.put("format".toUpperCase(Locale.ENGLISH), new OSQLFunctionFormat());
        FUNCTIONS.put("date".toUpperCase(Locale.ENGLISH), OSQLFunctionDate.class);
        FUNCTIONS.put("sysdate".toUpperCase(Locale.ENGLISH), OSQLFunctionSysdate.class);
        FUNCTIONS.put("count".toUpperCase(Locale.ENGLISH), OSQLFunctionCount.class);
        FUNCTIONS.put("distinct".toUpperCase(Locale.ENGLISH), OSQLFunctionDistinct.class);
        FUNCTIONS.put("union".toUpperCase(Locale.ENGLISH), OSQLFunctionUnion.class);
        FUNCTIONS.put("intersect".toUpperCase(Locale.ENGLISH), OSQLFunctionIntersect.class);
        FUNCTIONS.put("difference".toUpperCase(Locale.ENGLISH), OSQLFunctionDifference.class);
        FUNCTIONS.put("first".toUpperCase(Locale.ENGLISH), OSQLFunctionFirst.class);
        FUNCTIONS.put("last".toUpperCase(Locale.ENGLISH), OSQLFunctionLast.class);
        FUNCTIONS.put("list".toUpperCase(Locale.ENGLISH), OSQLFunctionList.class);
        FUNCTIONS.put("set".toUpperCase(Locale.ENGLISH), OSQLFunctionSet.class);
        FUNCTIONS.put("map".toUpperCase(Locale.ENGLISH), OSQLFunctionMap.class);
        FUNCTIONS.put("encode".toUpperCase(Locale.ENGLISH), new OSQLFunctionEncode());
        FUNCTIONS.put("decode".toUpperCase(Locale.ENGLISH), new OSQLFunctionDecode());
        FUNCTIONS.put("min".toUpperCase(Locale.ENGLISH), OSQLFunctionMin.class);
        FUNCTIONS.put("max".toUpperCase(Locale.ENGLISH), OSQLFunctionMax.class);
        FUNCTIONS.put("sum".toUpperCase(Locale.ENGLISH), OSQLFunctionSum.class);
        FUNCTIONS.put("avg".toUpperCase(Locale.ENGLISH), OSQLFunctionAverage.class);
        FUNCTIONS.put("eval".toUpperCase(Locale.ENGLISH), OSQLFunctionEval.class);
        FUNCTIONS.put("distance".toUpperCase(Locale.ENGLISH), new OSQLFunctionDistance());
    }

    @Override
    public Set<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    @Override
    public boolean hasFunction(String name) {
        return FUNCTIONS.containsKey(name);
    }

    @Override
    public OSQLFunction createFunction(String name) {
        Object obj = FUNCTIONS.get(name);
        if (obj == null) {
            throw new OCommandExecutionException("Unknowned function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors", e);
        }
    }
}

