/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import java.util.List;

public class OSQLFunctionRuntime
extends OSQLFilterItemAbstract {
    public OSQLFunction function;
    public Object[] configuredParameters;
    public Object[] runtimeParameters;

    public OSQLFunctionRuntime(OBaseParser iQueryToParse, String iText) {
        super(iQueryToParse, iText);
    }

    public boolean aggregateResults() {
        return this.function.aggregateResults();
    }

    public boolean filterResult() {
        return this.function.filterResult();
    }

    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, OCommandContext iContext) {
        int i = 0;
        while (i < this.configuredParameters.length) {
            if (this.configuredParameters[i] instanceof OSQLFilterItemField) {
                this.runtimeParameters[i] = ((OSQLFilterItemField)this.configuredParameters[i]).getValue(iCurrentRecord, iContext);
            } else if (this.configuredParameters[i] instanceof OSQLFunctionRuntime) {
                this.runtimeParameters[i] = ((OSQLFunctionRuntime)this.configuredParameters[i]).execute(iCurrentRecord, iCurrentResult, iContext);
            } else if (this.configuredParameters[i] instanceof OSQLFilterItemVariable) {
                this.runtimeParameters[i] = ((OSQLFilterItemVariable)this.configuredParameters[i]).getValue(iCurrentRecord, iContext);
            } else if (this.configuredParameters[i] instanceof OCommandSQL) {
                try {
                    this.runtimeParameters[i] = ((OCommandSQL)this.configuredParameters[i]).setContext(iContext).execute(new Object[0]);
                }
                catch (OCommandExecutorNotFoundException e) {
                    String text = ((OCommandSQL)this.configuredParameters[i]).getText();
                    OSQLPredicate pred = new OSQLPredicate(text);
                    this.runtimeParameters[i] = pred.evaluate(iCurrentRecord instanceof ORecord ? (ORecord)iCurrentRecord : null, (ODocument)iCurrentResult, iContext);
                    this.configuredParameters[i] = pred;
                }
            } else {
                this.runtimeParameters[i] = this.configuredParameters[i] instanceof OSQLPredicate ? ((OSQLPredicate)this.configuredParameters[i]).evaluate((ORecord<?>)iCurrentRecord.getRecord(), iCurrentRecord instanceof ODocument ? (ODocument)iCurrentResult : null, iContext) : this.configuredParameters[i];
            }
            ++i;
        }
        Object functionResult = this.function.execute(iCurrentRecord, iCurrentResult, this.runtimeParameters, iContext);
        return this.transformValue(iCurrentRecord, iContext, functionResult);
    }

    public Object getResult() {
        return this.transformValue(null, null, this.function.getResult());
    }

    public void setResult(Object iValue) {
        this.function.setResult(iValue);
    }

    @Override
    public Object getValue(OIdentifiable iRecord, OCommandContext iContext) {
        return this.execute(iRecord != null ? (ORecordSchemaAware)iRecord.getRecord() : null, null, iContext);
    }

    @Override
    public String getRoot() {
        return this.function.getName();
    }

    @Override
    protected void setRoot(OBaseParser iQueryToParse, String iText) {
        int beginParenthesis = iText.indexOf(40);
        String funcName = iText.substring(0, beginParenthesis);
        List<String> funcParamsText = OStringSerializerHelper.getParameters(iText);
        this.function = OSQLEngine.getInstance().getFunction(funcName);
        if (this.function == null) {
            throw new OCommandSQLParsingException("Unknow function " + funcName + "()");
        }
        this.configuredParameters = new Object[funcParamsText.size()];
        int i = 0;
        while (i < funcParamsText.size()) {
            this.configuredParameters[i] = OSQLHelper.parseValue(null, iQueryToParse, funcParamsText.get(i), null);
            ++i;
        }
        this.function.config(this.configuredParameters);
        this.runtimeParameters = new Object[this.configuredParameters.length];
        i = 0;
        while (i < this.configuredParameters.length) {
            if (!(this.configuredParameters[i] instanceof OSQLFilterItemField) && !(this.configuredParameters[i] instanceof OSQLFunctionRuntime)) {
                this.runtimeParameters[i] = this.configuredParameters[i];
            }
            ++i;
        }
    }

    public OSQLFunction getFunction() {
        return this.function;
    }

    public Object[] getConfiguredParameters() {
        return this.configuredParameters;
    }

    public Object[] getRuntimeParameters() {
        return this.runtimeParameters;
    }
}

