/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSQLFunctionDifference
extends OSQLFunctionMultiValueAbstract<Set<Object>> {
    public static final String NAME = "difference";
    private Set<Object> rejected;

    public OSQLFunctionDifference() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters[0] == null) {
            return null;
        }
        Object value = iParameters[0];
        if (iParameters.length == 1) {
            if (this.context == null) {
                this.context = new HashSet();
                this.rejected = new HashSet<Object>();
            }
            if (value instanceof Collection) {
                OSQLFunctionDifference.addItemsToResult((Collection)value, (Set)this.context, this.rejected);
            } else {
                OSQLFunctionDifference.addItemToResult(value, (Set)this.context, this.rejected);
            }
            return null;
        }
        HashSet<Object> result = new HashSet<Object>((Collection)value);
        HashSet<Object> rejected = new HashSet<Object>();
        for (Object iParameter : iParameters) {
            if (iParameter instanceof Collection) {
                OSQLFunctionDifference.addItemsToResult((Collection)value, result, rejected);
                continue;
            }
            OSQLFunctionDifference.addItemToResult(value, result, rejected);
        }
        return result;
    }

    @Override
    public Set<Object> getResult() {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("result", this.context);
            doc.put("rejected", this.rejected);
            return Collections.singleton(doc);
        }
        return (Set)super.getResult();
    }

    private static void addItemToResult(Object o, Set<Object> accepted, Set<Object> rejected) {
        if (!accepted.contains(o) && !rejected.contains(o)) {
            accepted.add(o);
        } else {
            accepted.remove(o);
            rejected.add(o);
        }
    }

    private static void addItemsToResult(Collection<Object> co, Set<Object> accepted, Set<Object> rejected) {
        for (Object o : co) {
            OSQLFunctionDifference.addItemToResult(o, accepted, rejected);
        }
    }

    @Override
    public String getSyntax() {
        return "Syntax error: difference(<field>*)";
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        HashSet<Object> result = new HashSet<Object>();
        HashSet<Object> rejected = new HashSet<Object>();
        for (Object item : resultsToMerge) {
            rejected.addAll(this.unwrap(item, "rejected"));
        }
        for (Object item : resultsToMerge) {
            OSQLFunctionDifference.addItemsToResult(this.unwrap(item, "result"), result, rejected);
        }
        return result;
    }

    private Set<Object> unwrap(Object obj, String field) {
        Set objAsSet = (Set)obj;
        Map objAsMap = (Map)objAsSet.iterator().next();
        Set objAsField = (Set)objAsMap.get(field);
        return objAsField;
    }
}

