/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionList
extends OSQLFunctionMultiValueAbstract<List<Object>> {
    public static final String NAME = "list";

    public OSQLFunctionList() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters.length > 1) {
            this.context = new ArrayList();
        }
        for (Object value : iParameters) {
            if (value == null) continue;
            if (iParameters.length == 1 && this.context == null) {
                this.context = new ArrayList();
            }
            OMultiValue.add((Object)this.context, (Object)value);
        }
        return this.prepareResult((List)this.context);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: list(<value>*)";
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public List<Object> getResult() {
        List res = (List)this.context;
        this.context = null;
        return this.prepareResult(res);
    }

    protected List<Object> prepareResult(List<Object> res) {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("node", this.getDistributedStorageId());
            doc.put("context", res);
            return Collections.singletonList(doc);
        }
        return res;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        HashMap<Long, Collection> chunks = new HashMap<Long, Collection>();
        for (Object iParameter : resultsToMerge) {
            Map container = (Map)((Collection)iParameter).iterator().next();
            chunks.put((Long)container.get("node"), (Collection)container.get("context"));
        }
        ArrayList result = new ArrayList();
        for (Collection chunk : chunks.values()) {
            result.addAll(chunk);
        }
        return result;
    }
}

