/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import java.util.List;

public class OSQLFunctionCount
extends OSQLFunctionMathAbstract {
    public static final String NAME = "count";
    private long total = 0L;

    public OSQLFunctionCount() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters[0] != null) {
            ++this.total;
        }
        return this.total;
    }

    @Override
    public boolean aggregateResults() {
        return true;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: count(<field>|*)";
    }

    @Override
    public Object getResult() {
        return this.total;
    }

    @Override
    public void setResult(Object iResult) {
        this.total = ((Number)iResult).longValue();
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        long total = 0L;
        for (Object iParameter : resultsToMerge) {
            long value = (Long)iParameter;
            total += value;
        }
        return total;
    }
}

