/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class OSQLFunctionDate
extends OSQLFunctionAbstract {
    public static final String NAME = "date";
    private Date date = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionDate() {
        super(NAME, 0, 3);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParameters, OCommandContext iContext) {
        if (iParameters.length == 0) {
            return this.date;
        }
        if (iParameters[0] instanceof Number) {
            return new Date(((Number)iParameters[0]).longValue());
        }
        if (this.format == null) {
            if (iParameters.length > 1) {
                this.format = new SimpleDateFormat((String)iParameters[1]);
                this.format.setTimeZone(ODateHelper.getDatabaseTimeZone());
            } else {
                this.format = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateTimeFormatInstance();
            }
            if (iParameters.length == 3) {
                this.format.setTimeZone(TimeZone.getTimeZone(iParameters[2].toString()));
            }
        }
        try {
            return this.format.parse((String)iParameters[0]);
        }
        catch (ParseException e) {
            throw new OQueryParsingException("Error on formatting date '" + iParameters[0] + "' using the format: " + this.format, e);
        }
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: date([<date-as-string>] [,<format>] [,<timezone>])";
    }

    @Override
    public Object getResult() {
        this.format = null;
        return null;
    }
}

