/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;

public class OSQLFunctionIf
extends OSQLFunctionAbstract {
    public static final String NAME = "if";

    public OSQLFunctionIf() {
        super(NAME, 2, 3);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iFuncParams, OCommandContext iContext) {
        try {
            boolean result;
            Object condition = iFuncParams[0];
            if (condition instanceof Boolean) {
                result = (Boolean)condition;
            } else if (condition instanceof String) {
                result = Boolean.parseBoolean(condition.toString());
            } else if (condition instanceof Number) {
                result = ((Number)condition).intValue() > 0;
            } else {
                return null;
            }
            return result ? iFuncParams[1] : iFuncParams[2];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getSyntax() {
        return "Syntax error: if(<field|value|expression>, <return_value_if_true> [,<return_value_if_false>])";
    }
}

