/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.text.ParseException;
import java.util.Date;

public class OSQLMethodAsDate
extends OAbstractSQLMethod {
    public static final String NAME = "asdate";

    public OSQLMethodAsDate() {
        super(NAME);
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iMethodParams) throws ParseException {
        if (ioResult != null) {
            if (ioResult instanceof Number) {
                ioResult = new Date(((Number)ioResult).longValue());
            } else if (!(ioResult instanceof Date)) {
                ioResult = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateFormatInstance().parse(ioResult.toString());
            }
        }
        return ioResult;
    }
}

