/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class OSQLMethodFormat
extends OAbstractSQLMethod {
    public static final String NAME = "format";

    public OSQLMethodFormat() {
        super(NAME, 1, 2);
    }

    @Override
    public Object execute(OIdentifiable iRecord, OCommandContext iContext, Object ioResult, Object[] iMethodParams) {
        Object v = this.getParameterValue(iRecord, iMethodParams[0].toString());
        if (v != null) {
            if (ioResult instanceof Date) {
                SimpleDateFormat format = new SimpleDateFormat(v.toString());
                if (iMethodParams.length > 1) {
                    format.setTimeZone(TimeZone.getTimeZone(iMethodParams[1].toString()));
                } else {
                    format.setTimeZone(ODateHelper.getDatabaseTimeZone());
                }
                ioResult = format.format(ioResult);
            } else {
                ioResult = ioResult != null ? String.format(v.toString(), ioResult) : null;
            }
        }
        return ioResult;
    }
}

