/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OQueryOperatorContains
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContains() {
        super("CONTAINS", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        block13: {
            OSQLFilterCondition condition;
            block12: {
                condition = iCondition.getLeft() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getLeft() : (iCondition.getRight() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getRight() : null);
                if (!(iLeft instanceof Iterable)) break block12;
                Iterable iterable = (Iterable)iLeft;
                if (condition != null) {
                    for (Object o : iterable) {
                        Iterator<Object> iter;
                        OIdentifiable id;
                        if (o instanceof OIdentifiable) {
                            id = (OIdentifiable)o;
                        } else if (o instanceof Map) {
                            iter = ((Map)o).values().iterator();
                            id = iter.hasNext() ? (OIdentifiable)iter.next() : null;
                        } else {
                            if (!(o instanceof Iterable)) continue;
                            iter = ((Iterable)o).iterator();
                            OIdentifiable oIdentifiable = id = iter.hasNext() ? (OIdentifiable)iter.next() : null;
                        }
                        if ((Boolean)condition.evaluate(id, null, iContext) != Boolean.TRUE) continue;
                        return true;
                    }
                } else {
                    for (Object o : iterable) {
                        if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                        return true;
                    }
                }
                break block13;
            }
            if (!(iRight instanceof Iterable)) break block13;
            Iterable iterable = (Iterable)iRight;
            if (condition != null) {
                for (OIdentifiable o : iterable) {
                    if ((Boolean)condition.evaluate(o, null, iContext) != Boolean.TRUE) continue;
                    return true;
                }
            } else {
                for (Object o : iterable) {
                    if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (!(iLeft instanceof OSQLFilterCondition) && !(iRight instanceof OSQLFilterCondition)) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public Object executeIndexQuery(OCommandContext iContext, OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        Collection<OIdentifiable> result;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            if (iOperationType != OQueryOperator.INDEX_OPERATION_TYPE.GET) {
                if (internalIndex.hasRangeQuerySupport()) {
                    return index.count(key);
                }
                return null;
            }
            Object indexResult = index.get(key);
            result = this.convertIndexResult(indexResult);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
            if (internalIndex.hasRangeQuerySupport()) {
                result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
            } else {
                int indexParamCount = indexDefinition.getParamCount();
                if (indexParamCount == keyParams.size()) {
                    if (iOperationType != OQueryOperator.INDEX_OPERATION_TYPE.GET) {
                        if (internalIndex.hasRangeQuerySupport()) {
                            return index.count(keyOne);
                        }
                        return null;
                    }
                    Object indexResult = index.get(keyOne);
                    result = this.convertIndexResult(indexResult);
                } else {
                    return null;
                }
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return result;
    }

    private Object convertIndexResult(Object indexResult) {
        List<Object> result = indexResult instanceof Collection ? (List)indexResult : (indexResult == null ? Collections.emptyList() : Collections.singletonList((OIdentifiable)indexResult));
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

