/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OQueryOperatorEquals
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorEquals() {
        super("=", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        return OQueryOperatorEquals.equals(iLeft, iRight);
    }

    public static boolean equals(Object iLeft, Object iRight) {
        if (iLeft == null || iRight == null) {
            return false;
        }
        if (iLeft instanceof ORecord) {
            return OQueryOperatorEquals.comparesValues(iRight, (ORecord)iLeft, true);
        }
        if (iRight instanceof ORecord) {
            return OQueryOperatorEquals.comparesValues(iLeft, (ORecord)iRight, true);
        }
        Object right = OType.convert(iRight, iLeft.getClass());
        if (right == null) {
            return false;
        }
        return iLeft.equals(right);
    }

    protected static boolean comparesValues(Object iValue, ORecord<?> iRecord, boolean iConsiderIn) {
        ORID other = iRecord.getIdentity();
        if (!other.isPersistent() && iRecord instanceof ODocument) {
            Object fieldValue;
            String[] firstFieldName = ((ODocument)iRecord).fieldNames();
            if (firstFieldName.length > 0 && (fieldValue = ((ODocument)iRecord).field(firstFieldName[0])) != null) {
                if (iConsiderIn && OMultiValue.isMultiValue(fieldValue)) {
                    for (Object o : OMultiValue.getMultiValueIterable(fieldValue)) {
                        if (o == null || !o.equals(iValue)) continue;
                        return true;
                    }
                }
                return fieldValue.equals(iValue);
            }
            return false;
        }
        return other.equals(iValue);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft instanceof OIdentifiable && iRight instanceof OIdentifiable) {
            return OIndexReuseType.NO_INDEX;
        }
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Object executeIndexQuery(OCommandContext iContext, OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        Object result;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            Object indexResult = iOperationType == OQueryOperator.INDEX_OPERATION_TYPE.GET ? index.get(key) : Long.valueOf(index.count(key));
            result = this.convertIndexResult(indexResult);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
            if (internalIndex.hasRangeQuerySupport()) {
                result = OQueryOperator.INDEX_OPERATION_TYPE.COUNT.equals((Object)iOperationType) ? Long.valueOf(index.count(keyOne, true, keyTwo, true, fetchLimit)) : (fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true));
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                Object indexResult = iOperationType == OQueryOperator.INDEX_OPERATION_TYPE.GET ? index.get(keyOne) : Long.valueOf(index.count(keyOne));
                result = this.convertIndexResult(indexResult);
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return result;
    }

    private Object convertIndexResult(Object indexResult) {
        Object result = indexResult instanceof Collection ? (List)indexResult : (indexResult == null ? Collections.emptyList() : (indexResult instanceof OIdentifiable ? Collections.singletonList((OIdentifiable)indexResult) : indexResult));
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof ORID) {
                return (ORID)iRight;
            }
            if (iRight instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iRight).getValue(null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iRight).getValue(null, null);
            }
        }
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof ORID) {
                return (ORID)iLeft;
            }
            if (iLeft instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iLeft).getValue(null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iLeft).getValue(null, null);
            }
        }
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return this.getBeginRidRange(iLeft, iRight);
    }
}

