/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;

public interface OCluster {
    public void configure(OStorage var1, int var2, String var3, String var4, int var5, Object ... var6) throws IOException;

    public void configure(OStorage var1, OStorageClusterConfiguration var2) throws IOException;

    public void create(int var1) throws IOException;

    public void open() throws IOException;

    public void close() throws IOException;

    public void delete() throws IOException;

    public void set(ATTRIBUTES var1, Object var2) throws IOException;

    public void convertToTombstone(OClusterPosition var1) throws IOException;

    public long getTombstonesCount();

    public boolean hasTombstonesSupport();

    public void truncate() throws IOException;

    public String getType();

    public int getDataSegmentId();

    public boolean addPhysicalPosition(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition var1) throws IOException;

    public void updateDataSegmentPosition(OClusterPosition var1, int var2, long var3) throws IOException;

    public void removePhysicalPosition(OClusterPosition var1) throws IOException;

    public void updateRecordType(OClusterPosition var1, byte var2) throws IOException;

    public void updateVersion(OClusterPosition var1, ORecordVersion var2) throws IOException;

    public long getEntries();

    public OClusterPosition getFirstPosition() throws IOException;

    public OClusterPosition getLastPosition() throws IOException;

    public void lock();

    public void unlock();

    public int getId();

    public void synch() throws IOException;

    public void setSoftlyClosed(boolean var1) throws IOException;

    public boolean wasSoftlyClosed() throws IOException;

    public String getName();

    public long getRecordsSize() throws IOException;

    public boolean useWal();

    public float recordGrowFactor();

    public float recordOverflowGrowFactor();

    public String compression();

    public boolean isHashBased();

    public OClusterEntryIterator absoluteIterator();

    public OPhysicalPosition[] higherPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] lowerPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] floorPositions(OPhysicalPosition var1) throws IOException;

    public static enum ATTRIBUTES {
        NAME,
        DATASEGMENT,
        USE_WAL,
        RECORD_GROW_FACTOR,
        RECORD_OVERFLOW_GROW_FACTOR,
        COMPRESSION;

    }
}

