/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageEHClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryLinearHashingClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfigurationLocal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterLocalEH;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemoryArrayList;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemoryHashing;
import java.util.Arrays;

public class ODefaultClusterFactory
implements OClusterFactory {
    protected static final String[] TYPES = new String[]{"PHYSICAL", "MEMORY"};

    @Override
    public OCluster createCluster(String iType, boolean forceListBasedCluster) {
        if (iType.equalsIgnoreCase("PHYSICAL")) {
            return (OCluster)(OGlobalConfiguration.USE_LHPEPS_CLUSTER.getValueAsBoolean() && !forceListBasedCluster ? new OClusterLocalEH() : new OClusterLocal());
        }
        if (iType.equalsIgnoreCase("MEMORY")) {
            return OGlobalConfiguration.USE_LHPEPS_MEMORY_CLUSTER.getValueAsBoolean() && !forceListBasedCluster ? new OClusterMemoryHashing() : new OClusterMemoryArrayList();
        }
        OLogManager.instance().exception("Cluster type '" + iType + "' is not supported. Supported types are: " + Arrays.toString(TYPES), null, OStorageException.class, new Object[0]);
        return null;
    }

    @Override
    public OCluster createCluster(OStorageClusterConfiguration iConfig) {
        if (iConfig instanceof OStoragePhysicalClusterConfigurationLocal) {
            return new OClusterLocal();
        }
        if (iConfig instanceof OStorageEHClusterConfiguration) {
            return new OClusterLocalEH();
        }
        if (iConfig instanceof OStorageMemoryClusterConfiguration) {
            return new OClusterMemoryArrayList();
        }
        if (iConfig instanceof OStorageMemoryLinearHashingClusterConfiguration) {
            return new OClusterMemoryHashing();
        }
        OLogManager.instance().exception("Cluster type '" + iConfig + "' is not supported. Supported types are: " + Arrays.toString(TYPES), null, OStorageException.class, new Object[0]);
        return null;
    }

    @Override
    public String[] getSupported() {
        return TYPES;
    }

    @Override
    public boolean isSupported(String iClusterType) {
        for (String type : TYPES) {
            if (!type.equalsIgnoreCase(iClusterType)) continue;
            return true;
        }
        return false;
    }
}

