/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCacheLevelTwoLocator;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OStorageAbstract
extends OSharedContainerImpl
implements OStorage {
    protected final String url;
    protected final String mode;
    protected OStorageConfiguration configuration;
    protected String name;
    protected AtomicLong version = new AtomicLong();
    protected OLevel2RecordCache level2Cache;
    protected volatile OStorage.STATUS status = OStorage.STATUS.CLOSED;
    protected final OSharedResourceAdaptiveExternal lock;

    public OStorageAbstract(String name, String URL2, String mode, int timeout, OCacheLevelTwoLocator cacheLocator) {
        this.name = OStringSerializerHelper.contains(name, '/') ? name.substring(name.lastIndexOf("/") + 1) : name;
        if (OStringSerializerHelper.contains(name, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.level2Cache = new OLevel2RecordCache(this, cacheLocator);
        this.level2Cache.startup();
        this.url = URL2;
        this.mode = mode;
        this.lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), timeout, true);
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isClosed() {
        return this.status == OStorage.STATUS.CLOSED;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ppos.recordVersion.isTombstone() && ppos.dataSegmentId > -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OLevel2RecordCache getLevel2Cache() {
        return this.level2Cache;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean iForce) {
        if (!this.checkForClose(iForce)) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            for (Object resource : this.sharedResources.values()) {
                if (resource instanceof OSharedResource) {
                    ((OSharedResource)resource).releaseExclusiveLock();
                }
                if (!(resource instanceof OCloseable)) continue;
                ((OCloseable)resource).close();
            }
            this.sharedResources.clear();
            Orient.instance().unregisterStorage(this);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.dropCluster(this.getClusterIdByName(iClusterName), iTruncate);
    }

    protected boolean checkForClose(boolean iForce) {
        this.lock.acquireSharedLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return false;
            }
            int remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
            boolean bl = iForce || !OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean() && remainingUsers == 0;
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getUsers() {
        return this.lock.getUsers();
    }

    @Override
    public int addUser() {
        return this.lock.addUser();
    }

    @Override
    public int removeUser() {
        return this.lock.removeUser();
    }

    @Override
    public OSharedResourceAdaptiveExternal getLock() {
        return this.lock;
    }

    @Override
    public long countRecords() {
        long tot = 0L;
        for (OCluster c : this.getClusterInstances()) {
            if (c == null) continue;
            tot += c.getEntries() - c.getTombstonesCount();
        }
        return tot;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.lock.acquireExclusiveLock();
        } else {
            this.lock.acquireSharedLock();
        }
        try {
            V v = iCallable.call();
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OException("Error on nested call in lock", (Throwable)e);
        }
        finally {
            if (iExclusiveLock) {
                this.lock.releaseExclusiveLock();
            } else {
                this.lock.releaseSharedLock();
            }
        }
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    @Override
    public OStorage.STATUS getStatus() {
        return this.status;
    }

    @Override
    public void checkForClusterPermissions(String iClusterName) {
        OMetadata metaData = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata();
        if (metaData != null) {
            Set<OClass> classes = metaData.getSchema().getClassesRelyOnCluster(iClusterName);
            for (OClass c : classes) {
                if (!c.isSubClassOf("ORestricted")) continue;
                throw new OSecurityException("Class " + c.getName() + " cannot be truncated because has record level security enabled (extends " + "ORestricted" + ")");
            }
        }
    }
}

