/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCacheLevelTwoLocatorLocal;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordLockManager;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import java.io.IOException;

public abstract class OStorageEmbedded
extends OStorageAbstract {
    protected final ORecordLockManager lockManager = new ORecordLockManager(OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger());
    protected final String PROFILER_CREATE_RECORD = "db." + this.name + ".createRecord";
    protected final String PROFILER_READ_RECORD = "db." + this.name + ".readRecord";
    protected final String PROFILER_UPDATE_RECORD = "db." + this.name + ".updateRecord";
    protected final String PROFILER_DELETE_RECORD = "db." + this.name + ".deleteRecord";

    public OStorageEmbedded(String iName, String iFilePath, String iMode) {
        super(iName, iFilePath, iMode, OGlobalConfiguration.STORAGE_LOCK_TIMEOUT.getValueAsInteger(), new OCacheLevelTwoLocatorLocal());
    }

    public abstract OCluster getClusterByName(String var1);

    protected abstract ORawBuffer readRecord(OCluster var1, ORecordId var2, boolean var3, boolean var4);

    @Override
    public void close(boolean iForce) {
        if (this.checkForClose(iForce)) {
            this.lockManager.clear();
        }
        super.close(iForce);
    }

    @Override
    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.setContext(iCommand.getContext());
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse(iCommand);
        return this.executeCommand(iCommand, executor);
    }

    public Object executeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
        if (iCommand.isIdempotent() && !executor.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute non idempotent command");
        }
        long beginTime = Orient.instance().getProfiler().startChrono();
        try {
            Object result;
            Object object = result = executor.execute(iCommand.getParameters());
            return object;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error on execution of command: " + iCommand, e);
        }
        finally {
            if (Orient.instance().getProfiler().isRecording()) {
                Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.INSTANCE.get().getName() + ".command." + iCommand.toString(), "Command executed against the database", beginTime, "db.*.command.*");
            }
        }
    }

    @Override
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        if (currentClusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(currentClusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.higherPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        if (clusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(clusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.ceilingPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        if (currentClusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(currentClusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.lowerPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        if (clusterId == -1) {
            return null;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.getClusterById(clusterId);
            OPhysicalPosition[] oPhysicalPositionArray = cluster.floorPositions(physicalPosition);
            return oPhysicalPositionArray;
        }
        catch (IOException ioe) {
            throw new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\'', ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void acquireWriteLock(ORID iRid) {
        this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
    }

    public void releaseWriteLock(ORID iRid) {
        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
    }

    public void acquireReadLock(ORID iRid) {
        this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ORID iRid) {
        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        block12: {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and can not be stored.");
            }
            this.checkOpeness();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            this.lock.acquireSharedLock();
            try {
                OPhysicalPosition ppos;
                block11: {
                    this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                        if (ppos != null && ppos.dataSegmentId >= 0) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            OLogManager.instance().error((Object)this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
                            break block12;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                    return null;
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                return oRecordMetadata;
            }
            finally {
                this.lock.releaseSharedLock();
            }
        }
        return null;
    }

    protected void checkOpeness() {
        if (this.status != OStorage.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }
}

