/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterLocalEH;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class OTxSegment
extends OSingleFileSegment {
    public static final byte STATUS_FREE = 0;
    public static final byte STATUS_COMMITTING = 1;
    public static final byte OPERATION_CREATE = 0;
    public static final byte OPERATION_DELETE = 1;
    public static final byte OPERATION_UPDATE = 2;
    private static final int DEF_START_SIZE = 262144;
    private static final int OFFSET_TX_ID = 2;
    private static final int CLUSTER_OFFSET_SIZE = OClusterPositionFactory.INSTANCE.getSerializedSize();
    private static final int OFFSET_RECORD_SIZE = 13 + CLUSTER_OFFSET_SIZE + OVersionFactory.instance().getVersionSize();
    private static final int OFFSET_RECORD_CONTENT = 17 + CLUSTER_OFFSET_SIZE + OVersionFactory.instance().getVersionSize();
    private final boolean synchEnabled;
    private OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);

    public OTxSegment(OStorageLocal iStorage, OStorageTxConfiguration iConfig) throws IOException {
        super(iStorage, iConfig, OGlobalConfiguration.TX_LOG_TYPE.getValueAsString());
        this.synchEnabled = OGlobalConfiguration.TX_LOG_SYNCH.getValueAsBoolean();
    }

    @Override
    public boolean open() throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            super.open();
            this.recoverTransactions();
            return true;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void create(int iStartSize) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            super.create(iStartSize > -1 ? iStartSize : 262144);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void addLog(byte iOperation, int iTxId, int iClusterId, OClusterPosition iClusterOffset, byte iRecordType, ORecordVersion iRecordVersion, byte[] iRecordContent, int dataSegmentId) throws IOException {
        int contentSize = iRecordContent != null ? iRecordContent.length : 0;
        int size = OFFSET_RECORD_CONTENT + contentSize;
        this.lock.acquireExclusiveLock();
        try {
            long offset = this.file.allocateSpace(size);
            this.file.writeByte(offset, (byte)1);
            this.file.writeByte(++offset, iOperation);
            this.file.writeInt(++offset, iTxId);
            this.file.writeShort(offset += 4L, (short)iClusterId);
            byte[] clusterContent = iClusterOffset.toStream();
            this.file.write(offset += 2L, clusterContent);
            this.file.writeByte(offset += (long)CLUSTER_OFFSET_SIZE, iRecordType);
            ++offset;
            offset += (long)iRecordVersion.getSerializer().writeTo(this.file, offset, iRecordVersion);
            this.file.writeInt(offset, dataSegmentId);
            this.file.writeInt(offset += 4L, contentSize);
            this.file.write(offset += 4L, iRecordContent);
            offset += (long)contentSize;
            if (this.synchEnabled) {
                this.file.synch();
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void clearLogEntries(int iTxId) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            this.truncate();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void rollback(OTransaction iTx) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            this.recoverTransaction(iTx.getId());
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    private void recoverTransactions() throws IOException {
        if (this.file.getFilledUpTo() == 0L) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Started the recovering of pending transactions after a hard shutdown. Scanning...", new Object[0]);
        int recoveredTxs = 0;
        int recoveredRecords = 0;
        Set<Integer> txToRecover = this.scanForTransactionsToRecover();
        for (Integer txId : txToRecover) {
            int recs = this.recoverTransaction(txId);
            if (recs <= 0) continue;
            ++recoveredTxs;
            recoveredRecords += recs;
        }
        this.file.shrink(0L);
        if (recoveredRecords > 0) {
            OLogManager.instance().warn((Object)this, "Recovering successfully completed:", new Object[0]);
            OLogManager.instance().warn((Object)this, "- Recovered Tx.....: " + recoveredTxs, new Object[0]);
            OLogManager.instance().warn((Object)this, "- Recovered Records: " + recoveredRecords, new Object[0]);
        } else {
            OLogManager.instance().debug((Object)this, "Recovering successfully completed: no pending tx records found.", new Object[0]);
        }
    }

    private Set<Integer> scanForTransactionsToRecover() throws IOException {
        HashSet<Integer> txToRecover = new HashSet<Integer>();
        HashSet<Integer> txToNotRecover = new HashSet<Integer>();
        long offset = 0L;
        while (this.eof(offset)) {
            byte status = this.file.readByte(offset);
            int txId = this.file.readInt(offset + 2L);
            switch (status) {
                case 0: {
                    txToNotRecover.add(txId);
                    break;
                }
                case 1: {
                    txToRecover.add(txId);
                }
            }
            offset = this.nextEntry(offset);
        }
        if (txToNotRecover.size() > 0) {
            txToRecover.removeAll(txToNotRecover);
        }
        return txToRecover;
    }

    private int recoverTransaction(int iTxId) throws IOException {
        int recordsRecovered = 0;
        ORecordId rid = new ORecordId();
        ArrayList<Long> txRecordPositions = new ArrayList<Long>();
        long beginEntry = 0L;
        while (this.eof(beginEntry)) {
            int txId;
            long offset = beginEntry;
            byte status = this.file.readByte(offset);
            ++offset;
            if (status != 0 && (txId = this.file.readInt(++offset)) == iTxId) {
                txRecordPositions.add(beginEntry);
            }
            beginEntry = this.nextEntry(beginEntry);
        }
        int i = txRecordPositions.size() - 1;
        while (i >= 0) {
            byte[] buffer;
            long beginEntry2;
            long offset = beginEntry2 = ((Long)txRecordPositions.get(i)).longValue();
            byte status = this.file.readByte(offset);
            byte operation = this.file.readByte(++offset);
            int txId = this.file.readInt(++offset);
            rid.clusterId = this.file.readShort(offset += 4L);
            byte[] content = new byte[OClusterPositionFactory.INSTANCE.getSerializedSize()];
            this.file.read(offset += 2L, content, content.length);
            rid.clusterPosition = OClusterPositionFactory.INSTANCE.fromStream(content);
            byte recordType = this.file.readByte(offset += (long)CLUSTER_OFFSET_SIZE);
            ++offset;
            ORecordVersion recordVersion = OVersionFactory.instance().createVersion();
            offset += recordVersion.getSerializer().readFrom(this.file, offset, recordVersion);
            int dataSegmentId = this.file.readInt(offset);
            int recordSize = this.file.readInt(offset += 4L);
            offset += 4L;
            if (recordSize > 0) {
                buffer = new byte[recordSize];
                this.file.read(offset, buffer, recordSize);
                offset += (long)recordSize;
            } else {
                buffer = null;
            }
            this.recoverTransactionEntry(status, operation, txId, rid, recordType, recordVersion, buffer, dataSegmentId);
            ++recordsRecovered;
            this.file.writeByte(beginEntry2, (byte)0);
            --i;
        }
        return recordsRecovered;
    }

    private void recoverTransactionEntry(byte iStatus, byte iOperation, int iTxId, ORecordId iRid, byte iRecordType, ORecordVersion iRecordVersion, byte[] iRecordContent, int dataSegmentId) throws IOException {
        OCluster cluster = this.storage.getClusterById(iRid.clusterId);
        if (!(cluster instanceof OClusterLocal) && !(cluster instanceof OClusterLocalEH)) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Recovering tx <%d>. Operation <%d> was in status <%d> on record %s size=%d...", new Object[]{iTxId, iOperation, iStatus, iRid, iRecordContent != null ? iRecordContent.length : 0});
        switch (iOperation) {
            case 0: {
                this.storage.deleteRecord(iRid, OVersionFactory.instance().createUntrackedVersion(), 0, null);
                break;
            }
            case 2: {
                iRecordVersion.setRollbackMode();
                this.storage.updateRecord(cluster, iRid, iRecordContent, iRecordVersion, iRecordType);
                break;
            }
            case 1: {
                ODataLocal dataSegment = (ODataLocal)this.storage.getDataSegmentById(dataSegmentId);
                this.storage.createRecord(dataSegment, cluster, iRecordContent, iRecordType, iRid, iRecordVersion);
            }
        }
    }

    private boolean eof(long iOffset) {
        return iOffset + (long)OFFSET_RECORD_CONTENT < this.file.getFilledUpTo();
    }

    private long nextEntry(long iOffset) throws IOException {
        int recordSize = this.file.readInt(iOffset + (long)OFFSET_RECORD_SIZE);
        return iOffset + (long)OFFSET_RECORD_CONTENT + (long)recordSize;
    }
}

