/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.eh;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageEHClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OLocalHashTable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.eh.OClusterPositionSerializer;
import com.orientechnologies.orient.core.storage.impl.local.eh.OPhysicalPositionSerializer;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;

public class OClusterLocalEH
extends OSharedResourceAdaptive
implements OCluster {
    public static final String TYPE = "PHYSICAL";
    public static final String METADATA_CONFIGURATION_FILE_EXTENSION = ".oem";
    public static final String TREE_STATE_FILE_EXTENSION = ".oet";
    public static final String BUCKET_FILE_EXTENSION = ".oef";
    public static final String CLUSTER_STATE_FILE_EXTENSION = ".ocs";
    private long tombstonesCount;
    private OStorageLocal storage;
    private int id;
    private String name;
    private OStorageEHClusterConfiguration config;
    private OSingleFileSegment clusterStateHolder;
    private final OLocalHashTable<OClusterPosition, OPhysicalPosition> localHashTable = new OLocalHashTable(".oem", ".oet", ".oef", new OHashFunction<OClusterPosition>(){

        @Override
        public long hashCode(OClusterPosition value) {
            return value.longValueHigh();
        }
    });

    public OClusterLocalEH() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    @Override
    public void configure(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.config = new OStorageEHClusterConfiguration(iStorage.getConfiguration(), iId, iClusterName, iLocation, iDataSegmentId);
            this.init(iStorage, iId, iClusterName, iLocation, iDataSegmentId, new Object[0]);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.config = (OStorageEHClusterConfiguration)iConfig;
            this.init(iStorage, this.config.getId(), this.config.getName(), this.config.getLocation(), this.config.getDataSegmentId(), new Object[0]);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(int iStartSize) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.localHashTable.create(this.name, OClusterPositionSerializer.INSTANCE, OPhysicalPositionSerializer.INSTANCE, this.storage);
            this.clusterStateHolder.create(-1);
            if (this.config.root.clusters.size() <= this.config.id) {
                this.config.root.clusters.add(this.config);
            } else {
                this.config.root.clusters.set(this.config.id, this.config);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.localHashTable.load(this.name, this.storage);
            this.clusterStateHolder.open();
            this.tombstonesCount = this.clusterStateHolder.getFile().readLong(0L);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected void init(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) throws IOException {
        OFileUtils.checkValidName((String)iClusterName);
        OStorageFileConfiguration clusterStateConfiguration = new OStorageFileConfiguration(null, "${STORAGE_PATH}/" + this.config.name + CLUSTER_STATE_FILE_EXTENSION, "classic", "1024", "50%");
        this.config.dataSegmentId = iDataSegmentId;
        this.storage = (OStorageLocal)iStorage;
        this.name = iClusterName;
        this.id = iId;
        this.clusterStateHolder = new OSingleFileSegment(this.storage, clusterStateConfiguration);
    }

    @Override
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.saveState();
            this.clusterStateHolder.synch();
            this.localHashTable.close();
            this.clusterStateHolder.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.localHashTable.delete();
            this.clusterStateHolder.delete();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        this.acquireExclusiveLock();
        try {
            switch (iAttribute) {
                case NAME: {
                    this.setNameInternal(stringValue);
                    break;
                }
                case DATASEGMENT: {
                    this.setDataSegmentInternal(stringValue);
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void setNameInternal(String iNewName) {
        if (this.storage.getClusterIdByName(iNewName) > -1) {
            throw new IllegalArgumentException("Cluster with name '" + iNewName + "' already exists");
        }
        this.localHashTable.rename(iNewName);
        this.config.name = iNewName;
        this.storage.renameCluster(this.name, iNewName);
        this.name = iNewName;
        this.storage.getConfiguration().update();
    }

    private void setDataSegmentInternal(String iName) {
        this.config.dataSegmentId = this.storage.getDataSegmentIdByName(iName);
        this.storage.getConfiguration().update();
    }

    @Override
    public void convertToTombstone(OClusterPosition iPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition physicalPosition = this.localHashTable.get(iPosition);
            if (physicalPosition == null) {
                return;
            }
            ORecordVersion version = physicalPosition.recordVersion;
            version.convertToTombstone();
            ++this.tombstonesCount;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public long getTombstonesCount() {
        this.acquireSharedLock();
        try {
            long l = this.tombstonesCount;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean hasTombstonesSupport() {
        return true;
    }

    @Override
    public void truncate() throws IOException {
        this.storage.checkForClusterPermissions(this.getName());
        this.acquireExclusiveLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition> entry = this.localHashTable.firstEntry();
            while (entry != null) {
                OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entries;
                if (this.storage.checkForRecordValidity((OPhysicalPosition)entry.value)) {
                    this.storage.getDataSegmentById(((OPhysicalPosition)entry.value).dataSegmentId).deleteRecord(((OPhysicalPosition)entry.value).dataSegmentPos);
                }
                entry = (entries = this.localHashTable.higherEntries((OClusterPosition)entry.key, 1)).length > 0 ? entries[0] : null;
            }
            this.localHashTable.clear();
            this.tombstonesCount = 0L;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean useWal() {
        return false;
    }

    @Override
    public float recordGrowFactor() {
        return 1.0f;
    }

    @Override
    public float recordOverflowGrowFactor() {
        return 1.0f;
    }

    @Override
    public String compression() {
        return "nothing";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getDataSegmentId() {
        this.acquireSharedLock();
        try {
            int n = this.config.dataSegmentId;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean addPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (this.localHashTable.get(iPPosition.clusterPosition) != null) {
                return false;
            }
            this.localHashTable.put(iPPosition.clusterPosition, iPPosition);
            return true;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        this.acquireSharedLock();
        try {
            OPhysicalPosition oPhysicalPosition = this.localHashTable.get(iPPosition.clusterPosition);
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void updateDataSegmentPosition(OClusterPosition iPosition, int iDataSegmentId, long iDataPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition position = this.localHashTable.get(iPosition);
            position.dataSegmentId = iDataSegmentId;
            position.dataSegmentPos = iDataPosition;
            this.localHashTable.put(iPosition, position);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void removePhysicalPosition(OClusterPosition iPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition physicalPosition = this.localHashTable.remove(iPosition);
            if (physicalPosition != null && physicalPosition.recordVersion.isTombstone()) {
                --this.tombstonesCount;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void updateRecordType(OClusterPosition iPosition, byte iRecordType) throws IOException {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition position = this.localHashTable.get(iPosition);
            position.recordType = iRecordType;
            this.localHashTable.put(iPosition, position);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void updateVersion(OClusterPosition iPosition, ORecordVersion iVersion) throws IOException {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition position = this.localHashTable.get(iPosition);
            position.recordVersion = iVersion;
            this.localHashTable.put(iPosition, position);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.localHashTable.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getFirstPosition() throws IOException {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition> entry = this.localHashTable.firstEntry();
            if (entry == null) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition oClusterPosition = (OClusterPosition)entry.key;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getLastPosition() throws IOException {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition> entry = this.localHashTable.lastEntry();
            if (entry == null) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition oClusterPosition = (OClusterPosition)entry.key;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public String toString() {
        return String.valueOf(this.name) + " (id=" + this.id + ")";
    }

    @Override
    public void lock() {
        this.acquireSharedLock();
    }

    @Override
    public void unlock() {
        this.releaseSharedLock();
    }

    @Override
    public int getId() {
        this.acquireSharedLock();
        try {
            int n = this.id;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void synch() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.saveState();
            this.localHashTable.flush();
            this.clusterStateHolder.synch();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.localHashTable.setSoftlyClosed(softlyClosed);
            this.clusterStateHolder.setSoftlyClosed(softlyClosed);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed() throws IOException {
        this.acquireSharedLock();
        try {
            boolean wasSoftlyClosed = this.localHashTable.wasSoftlyClosed();
            boolean bl = wasSoftlyClosed = wasSoftlyClosed && this.clusterStateHolder.wasSoftlyClosedAtPreviousTime();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getRecordsSize() throws IOException {
        this.acquireSharedLock();
        try {
            long size = 0L;
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entries = this.localHashTable.ceilingEntries(OClusterPositionFactory.INSTANCE.valueOf(0L));
            while (entries.length > 0) {
                OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition> entry = entryArray[n2];
                    if (((OPhysicalPosition)entry.value).dataSegmentPos > -1L && !((OPhysicalPosition)entry.value).recordVersion.isTombstone()) {
                        size += (long)this.storage.getDataSegmentById(((OPhysicalPosition)entry.value).dataSegmentId).getRecordSize(((OPhysicalPosition)entry.value).dataSegmentPos);
                    }
                    ++n2;
                }
                entries = this.localHashTable.higherEntries((OClusterPosition)entries[entries.length - 1].key);
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isHashBased() {
        return true;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        this.acquireSharedLock();
        try {
            OClusterEntryIterator oClusterEntryIterator = new OClusterEntryIterator(this);
            return oClusterEntryIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entries = this.localHashTable.higherEntries(position.clusterPosition);
            OPhysicalPosition[] positions = new OPhysicalPosition[entries.length];
            int i = 0;
            while (i < entries.length) {
                positions[i] = (OPhysicalPosition)entries[i].value;
                ++i;
            }
            OPhysicalPosition[] oPhysicalPositionArray = positions;
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entries = this.localHashTable.ceilingEntries(position.clusterPosition);
            OPhysicalPosition[] positions = new OPhysicalPosition[entries.length];
            int i = 0;
            while (i < entries.length) {
                positions[i] = (OPhysicalPosition)entries[i].value;
                ++i;
            }
            OPhysicalPosition[] oPhysicalPositionArray = positions;
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entries = this.localHashTable.lowerEntries(position.clusterPosition);
            OPhysicalPosition[] positions = new OPhysicalPosition[entries.length];
            int i = 0;
            while (i < entries.length) {
                positions[i] = (OPhysicalPosition)entries[i].value;
                ++i;
            }
            OPhysicalPosition[] oPhysicalPositionArray = positions;
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OHashIndexBucket.Entry<OClusterPosition, OPhysicalPosition>[] entries = this.localHashTable.floorEntries(position.clusterPosition);
            OPhysicalPosition[] positions = new OPhysicalPosition[entries.length];
            int i = 0;
            while (i < entries.length) {
                positions[i] = (OPhysicalPosition)entries[i].value;
                ++i;
            }
            OPhysicalPosition[] oPhysicalPositionArray = positions;
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private void saveState() throws IOException {
        this.clusterStateHolder.getFile().writeLong(0L, this.tombstonesCount);
    }
}

