/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OBinaryFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OBinaryPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OIntFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OIntPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OLongFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OLongPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OPageDiff;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class OLocalPage {
    private static final int VERSION_SIZE = OVersionFactory.instance().getVersionSize();
    private static final int MAGIC_NUMBER_OFFSET = 0;
    private static final int CRC32_OFFSET = 8;
    private static final int WAL_SEGMENT_OFFSET = 12;
    private static final int WAL_POSITION_OFFSET = 16;
    private static final int NEXT_PAGE_OFFSET = 24;
    private static final int PREV_PAGE_OFFSET = 32;
    private static final int FREELIST_HEADER_OFFSET = 40;
    private static final int FREE_POSITION_OFFSET = 44;
    private static final int FREE_SPACE_COUNTER_OFFSET = 48;
    private static final int ENTRIES_COUNT_OFFSET = 52;
    private static final int PAGE_INDEXES_LENGTH_OFFSET = 56;
    private static final int PAGE_INDEXES_OFFSET = 60;
    private static final int INDEX_ITEM_SIZE = 4 + VERSION_SIZE;
    private static final int MARKED_AS_DELETED_FLAG = 65536;
    private static final int POSITION_MASK = 65535;
    public static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    public static final int MAX_ENTRY_SIZE = PAGE_SIZE - 60 - INDEX_ITEM_SIZE;
    public static final int MAX_RECORD_SIZE = MAX_ENTRY_SIZE - 12;
    private final long pagePointer;
    private final ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
    private List<OPageDiff<?>> pageChanges = new ArrayList();
    private final TrackMode trackMode;

    public OLocalPage(long pagePointer, boolean newPage, TrackMode trackMode) throws IOException {
        this.pagePointer = pagePointer;
        this.trackMode = trackMode;
        if (newPage) {
            this.setLongValue(24, -1L);
            this.setLongValue(32, -1L);
            this.setIntValue(44, PAGE_SIZE);
            this.setIntValue(48, PAGE_SIZE - 60);
        }
    }

    public OLogSequenceNumber getLsn() {
        int segment = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + 12L);
        long position = OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + 16L);
        return new OLogSequenceNumber(segment, position);
    }

    public void setLsn(OLogSequenceNumber lsn) {
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(lsn.getSegment()), this.directMemory, this.pagePointer + 12L);
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(lsn.getPosition()), this.directMemory, this.pagePointer + 16L);
    }

    public int appendRecord(ORecordVersion recordVersion, byte[] record, boolean keepTombstoneVersion) throws IOException {
        int entryIndex;
        int freePosition = this.getIntValue(44);
        int indexesLength = this.getIntValue(56);
        int lastEntryIndexPosition = 60 + indexesLength * INDEX_ITEM_SIZE;
        int entrySize = record.length + 12;
        int freeListHeader = this.getIntValue(40);
        if (!this.checkSpace(entrySize, freeListHeader)) {
            return -1;
        }
        if (freeListHeader > 0) {
            if (freePosition - entrySize < lastEntryIndexPosition) {
                this.doDefragmentation();
            }
        } else if (freePosition - entrySize < lastEntryIndexPosition + INDEX_ITEM_SIZE) {
            this.doDefragmentation();
        }
        freePosition = this.getIntValue(44);
        freePosition -= entrySize;
        if (freeListHeader > 0) {
            entryIndex = freeListHeader - 1;
            int tombstonePointer = this.getIntValue(60 + INDEX_ITEM_SIZE * entryIndex);
            int nextEntryPosition = tombstonePointer & 0xFFFF;
            if (nextEntryPosition > 0) {
                this.setIntValue(40, nextEntryPosition);
            } else {
                this.setIntValue(40, 0);
            }
            this.setIntValue(48, this.getFreeSpace() - entrySize);
            int entryIndexPosition = 60 + entryIndex * INDEX_ITEM_SIZE;
            this.setIntValue(entryIndexPosition, freePosition);
            byte[] serializedVersion = this.getBinaryValue(entryIndexPosition + 4, OVersionFactory.instance().getVersionSize());
            ORecordVersion existingRecordVersion = OVersionFactory.instance().createVersion();
            existingRecordVersion.getSerializer().fastReadFrom(serializedVersion, 0, existingRecordVersion);
            if (existingRecordVersion.compareTo(recordVersion) < 0) {
                recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, recordVersion);
                this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
            } else if (!keepTombstoneVersion) {
                existingRecordVersion.increment();
                existingRecordVersion.getSerializer().fastWriteTo(serializedVersion, 0, existingRecordVersion);
                this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
            }
        } else {
            entryIndex = indexesLength;
            this.setIntValue(56, indexesLength + 1);
            this.setIntValue(48, this.getFreeSpace() - entrySize - INDEX_ITEM_SIZE);
            int entryIndexPosition = 60 + entryIndex * INDEX_ITEM_SIZE;
            this.setIntValue(entryIndexPosition, freePosition);
            byte[] serializedVersion = new byte[OVersionFactory.instance().getVersionSize()];
            recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, recordVersion);
            this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
        }
        int entryPosition = freePosition;
        this.setIntValue(entryPosition, entrySize);
        this.setIntValue(entryPosition += 4, entryIndex);
        this.setIntValue(entryPosition += 4, record.length);
        this.setBinaryValue(entryPosition += 4, record);
        this.setIntValue(44, freePosition);
        this.incrementEntriesCount();
        return entryIndex;
    }

    public int replaceRecord(int entryIndex, byte[] record, ORecordVersion recordVersion) throws IOException {
        int writtenBytes;
        int entryPointer;
        int entryPosition;
        int recordSize;
        int entryIndexPosition = 60 + entryIndex * INDEX_ITEM_SIZE;
        if (recordVersion != null) {
            byte[] serializedVersion = this.getBinaryValue(entryIndexPosition + 4, OVersionFactory.instance().getVersionSize());
            ORecordVersion storedRecordVersion = OVersionFactory.instance().createVersion();
            storedRecordVersion.getSerializer().fastReadFrom(serializedVersion, 0, storedRecordVersion);
            if (recordVersion.compareTo(storedRecordVersion) > 0) {
                recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, recordVersion);
                this.setBinaryValue(entryIndexPosition + 4, serializedVersion);
            }
        }
        if (record.length <= (recordSize = this.getIntValue(entryPosition = (entryPointer = this.getIntValue(entryIndexPosition)) & 0xFFFF) - 12)) {
            this.setIntValue(entryPointer + 8, record.length);
            this.setBinaryValue(entryPointer + 12, record);
            writtenBytes = record.length;
        } else {
            byte[] newRecord = new byte[recordSize];
            System.arraycopy(record, 0, newRecord, 0, newRecord.length);
            this.setBinaryValue(entryPointer + 12, newRecord);
            writtenBytes = newRecord.length;
        }
        return writtenBytes;
    }

    public ORecordVersion getRecordVersion(int position) {
        int indexesLength = this.getIntValue(56);
        if (position >= indexesLength) {
            return null;
        }
        int entryIndexPosition = 60 + position * INDEX_ITEM_SIZE;
        byte[] serializedVersion = this.getBinaryValue(entryIndexPosition + 4, OVersionFactory.instance().getVersionSize());
        ORecordVersion recordVersion = OVersionFactory.instance().createVersion();
        recordVersion.getSerializer().fastReadFrom(serializedVersion, 0, recordVersion);
        return recordVersion;
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == PAGE_SIZE - 60;
    }

    private boolean checkSpace(int entrySize, int freeListHeader) {
        return !(freeListHeader > 0 ? this.getFreeSpace() - entrySize < 0 : this.getFreeSpace() - entrySize - INDEX_ITEM_SIZE < 0);
    }

    public boolean deleteRecord(int position) throws IOException {
        int indexesLength = this.getIntValue(56);
        if (position >= indexesLength) {
            return false;
        }
        int entryIndexPosition = 60 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) > 0) {
            return false;
        }
        int entryPosition = entryPointer & 0xFFFF;
        int freeListHeader = this.getIntValue(40);
        if (freeListHeader <= 0) {
            this.setIntValue(entryIndexPosition, 65536);
        } else {
            this.setIntValue(entryIndexPosition, freeListHeader | 0x10000);
        }
        this.setIntValue(40, position + 1);
        int entrySize = this.getIntValue(entryPosition);
        assert (entrySize > 0);
        this.setIntValue(entryPosition, -entrySize);
        this.setIntValue(48, this.getFreeSpace() + entrySize);
        this.decrementEntriesCount();
        return true;
    }

    public boolean isDeleted(int position) {
        int indexesLength = this.getIntValue(56);
        if (position >= indexesLength) {
            return true;
        }
        int entryIndexPosition = 60 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        return (entryPointer & 0x10000) > 0;
    }

    public int getRecordPageOffset(int position) {
        int indexesLength = this.getIntValue(56);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 60 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) > 0) {
            return -1;
        }
        int entryPosition = entryPointer & 0xFFFF;
        return entryPosition + 12;
    }

    public int getRecordSize(int position) {
        int indexesLength = this.getIntValue(56);
        if (position >= indexesLength) {
            return -1;
        }
        int entryIndexPosition = 60 + INDEX_ITEM_SIZE * position;
        int entryPointer = this.getIntValue(entryIndexPosition);
        if ((entryPointer & 0x10000) > 0) {
            return -1;
        }
        int entryPosition = entryPointer & 0xFFFF;
        return this.getIntValue(entryPosition + 8);
    }

    public int findFirstDeletedRecord(int position) {
        int indexesLength = this.getIntValue(56);
        int i = position;
        while (i < indexesLength) {
            int entryIndexPosition = 60 + INDEX_ITEM_SIZE * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) > 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findFirstRecord(int position) {
        int indexesLength = this.getIntValue(56);
        int i = position;
        while (i < indexesLength) {
            int entryIndexPosition = 60 + INDEX_ITEM_SIZE * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findLastRecord(int position) {
        int endIndex;
        int indexesLength = this.getIntValue(56);
        int i = endIndex = Math.min(indexesLength - 1, position);
        while (i >= 0) {
            int entryIndexPosition = 60 + INDEX_ITEM_SIZE * i;
            int entryPointer = this.getIntValue(entryIndexPosition);
            if ((entryPointer & 0x10000) == 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int getFreeSpace() {
        return this.getIntValue(48);
    }

    public int getMaxRecordSize() {
        int freeListHeader = this.getIntValue(40);
        int maxEntrySize = freeListHeader > 0 ? this.getFreeSpace() : this.getFreeSpace() - INDEX_ITEM_SIZE;
        int result = maxEntrySize - 12;
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getRecordsCount() {
        return this.getIntValue(52);
    }

    public long getNextPage() {
        return this.getLongValue(24);
    }

    public void setNextPage(long nextPage) throws IOException {
        this.setLongValue(24, nextPage);
    }

    public long getPrevPage() {
        return this.getLongValue(32);
    }

    public void setPrevPage(long prevPage) throws IOException {
        this.setLongValue(32, prevPage);
    }

    public List<OPageDiff<?>> getPageChanges() {
        return this.pageChanges;
    }

    public void restoreChanges(List<OPageDiff<?>> changes) {
        for (OPageDiff<?> diff : changes) {
            diff.restorePageData(this.pagePointer);
        }
    }

    public void revertChanges(List<OFullPageDiff<?>> changes) {
        ListIterator<OFullPageDiff<?>> listIterator = changes.listIterator(changes.size());
        while (listIterator.hasPrevious()) {
            OFullPageDiff<?> diff = listIterator.previous();
            diff.revertPageData(this.pagePointer);
        }
    }

    private void incrementEntriesCount() throws IOException {
        this.setIntValue(52, this.getRecordsCount() + 1);
    }

    private void decrementEntriesCount() throws IOException {
        this.setIntValue(52, this.getRecordsCount() - 1);
    }

    private void doDefragmentation() throws IOException {
        int freePosition;
        int currentPosition = freePosition = this.getIntValue(44);
        ArrayList<Integer> processedPositions = new ArrayList<Integer>();
        while (currentPosition < PAGE_SIZE) {
            int entrySize = this.getIntValue(currentPosition);
            if (entrySize > 0) {
                int positionIndex = this.getIntValue(currentPosition + 4);
                processedPositions.add(positionIndex);
                currentPosition += entrySize;
                continue;
            }
            entrySize = -entrySize;
            this.copyData(freePosition, freePosition + entrySize, currentPosition - freePosition);
            currentPosition += entrySize;
            freePosition += entrySize;
            this.shiftPositions(processedPositions, entrySize);
        }
        this.setIntValue(44, freePosition);
    }

    private void shiftPositions(List<Integer> processedPositions, int entrySize) throws IOException {
        for (int positionIndex : processedPositions) {
            int entryIndexPosition = 60 + INDEX_ITEM_SIZE * positionIndex;
            int entryPosition = this.getIntValue(entryIndexPosition);
            this.setIntValue(entryIndexPosition, entryPosition + entrySize);
        }
    }

    public int getIntValue(int pageOffset) {
        return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + (long)pageOffset);
    }

    public long getLongValue(int pageOffset) {
        return OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + (long)pageOffset);
    }

    public byte[] getBinaryValue(int pageOffset, int valLen) {
        return this.directMemory.get(this.pagePointer + (long)pageOffset, valLen);
    }

    public byte getByteValue(int pageOffset) {
        return this.directMemory.getByte(this.pagePointer + (long)pageOffset);
    }

    public void setIntValue(int pageOffset, int value) throws IOException {
        if (this.trackMode.equals((Object)TrackMode.FORWARD)) {
            this.pageChanges.add(new OIntPageDiff(value, pageOffset));
        } else if (this.trackMode.equals((Object)TrackMode.BOTH)) {
            int oldValue = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + (long)pageOffset);
            this.pageChanges.add(new OIntFullPageDiff(value, pageOffset, oldValue));
        }
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(Integer.valueOf(value), this.directMemory, this.pagePointer + (long)pageOffset);
    }

    public void setLongValue(int pageOffset, long value) throws IOException {
        if (this.trackMode.equals((Object)TrackMode.FORWARD)) {
            this.pageChanges.add(new OLongPageDiff(value, pageOffset));
        } else if (this.trackMode.equals((Object)TrackMode.BOTH)) {
            long oldValue = OLongSerializer.INSTANCE.deserializeFromDirectMemory(this.directMemory, this.pagePointer + (long)pageOffset);
            this.pageChanges.add(new OLongFullPageDiff(value, pageOffset, oldValue));
        }
        OLongSerializer.INSTANCE.serializeInDirectMemory(Long.valueOf(value), this.directMemory, this.pagePointer + (long)pageOffset);
    }

    public void setBinaryValue(int pageOffset, byte[] value) throws IOException {
        if (value.length == 0) {
            return;
        }
        if (this.trackMode.equals((Object)TrackMode.FORWARD)) {
            this.pageChanges.add(new OBinaryPageDiff(value, pageOffset));
        } else if (this.trackMode.equals((Object)TrackMode.BOTH)) {
            byte[] oldValue = this.directMemory.get(this.pagePointer + (long)pageOffset, value.length);
            this.pageChanges.add(new OBinaryFullPageDiff(value, pageOffset, oldValue));
            this.directMemory.set(this.pagePointer + (long)pageOffset, value, 0, value.length);
        }
        this.directMemory.set(this.pagePointer + (long)pageOffset, value, 0, value.length);
    }

    public void copyData(int from, int to, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.trackMode.equals((Object)TrackMode.FORWARD)) {
            byte[] content = this.directMemory.get(this.pagePointer + (long)from, len);
            this.pageChanges.add(new OBinaryPageDiff(content, to));
        } else if (this.trackMode.equals((Object)TrackMode.BOTH)) {
            byte[] content = this.directMemory.get(this.pagePointer + (long)from, len);
            byte[] oldContent = this.directMemory.get(this.pagePointer + (long)to, len);
            this.pageChanges.add(new OBinaryFullPageDiff(content, to, oldContent));
        }
        this.directMemory.copyData(this.pagePointer + (long)from, this.pagePointer + (long)to, (long)len);
    }

    public static enum TrackMode {
        NONE,
        FORWARD,
        BOTH;

    }
}

