/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.serialization.compression.OCompression;
import com.orientechnologies.orient.core.serialization.compression.OCompressionFactory;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractPageWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAddNewPageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OClusterStateRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFreePageChangeRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OFullPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OPageDiff;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OUpdatePageRecord;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class OLocalPaginatedCluster
extends OSharedResourceAdaptive
implements OCluster {
    public static final String DEF_EXTENSION = ".pcl";
    private static final String CLUSTER_STATE_FILE_EXTENSION = ".pls";
    private static final int FREE_LIST_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() - OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
    private static final int STATE_SIZE = 20 + FREE_LIST_SIZE * 8 + 12 + 8;
    private OCompression compression;
    public static final String TYPE = "PHYSICAL";
    private static final int PAGE_INDEX_OFFSET = 16;
    private static final int RECORD_POSITION_MASK = 65535;
    private static final int ONE_KB = 1024;
    private ODiskCache diskCache;
    private String name;
    private OLocalPaginatedStorage storageLocal;
    private volatile int id;
    private long fileId;
    private long size;
    private long recordsSize;
    private OStoragePaginatedClusterConfiguration config;
    private OSingleFileSegment clusterStateHolder;
    private long[] freePageLists = new long[FREE_LIST_SIZE];
    private final OModificationLock externalModificationLock = new OModificationLock();
    private OWriteAheadLog writeAheadLog;
    private ThreadLocal<OOperationUnitId> currentUnitId = new ThreadLocal();
    private ThreadLocal<OLogSequenceNumber> startLSN = new ThreadLocal();
    private boolean useFirstStateHolder = true;

    public OLocalPaginatedCluster() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
        int i = 0;
        while (i < this.freePageLists.length) {
            this.freePageLists[i] = -1L;
            ++i;
        }
    }

    @Override
    public void configure(OStorage storage, int id, String clusterName, String location, int dataSegmentId, Object ... parameters) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.config = new OStoragePaginatedClusterConfiguration(storage.getConfiguration(), id, clusterName, null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getValueAsString());
                this.config.name = clusterName;
                this.init((OLocalPaginatedStorage)storage, this.config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void configure(OStorage storage, OStorageClusterConfiguration config) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.init((OLocalPaginatedStorage)storage, config);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private void init(OLocalPaginatedStorage storage, OStorageClusterConfiguration config) throws IOException {
        OFileUtils.checkValidName((String)config.getName());
        this.config = (OStoragePaginatedClusterConfiguration)config;
        this.compression = OCompressionFactory.INSTANCE.getCompression(this.config.compression);
        this.storageLocal = storage;
        this.writeAheadLog = storage.getWALInstance();
        this.diskCache = this.storageLocal.getDiskCache();
        this.name = config.getName();
        this.id = config.getId();
        OStorageFileConfiguration clusterStateConfiguration = new OStorageFileConfiguration(null, "${STORAGE_PATH}/" + config.getName() + CLUSTER_STATE_FILE_EXTENSION, "classic", "1024", "50%");
        this.clusterStateHolder = new OSingleFileSegment(storage, clusterStateConfiguration);
    }

    public boolean exists() {
        return this.clusterStateHolder.exists();
    }

    @Override
    public void create(int startSize) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.fileId = this.diskCache.openFile(String.valueOf(this.name) + DEF_EXTENSION);
                int statesSize = 2 * STATE_SIZE;
                this.clusterStateHolder.create(statesSize);
                OFile file = this.clusterStateHolder.getFile();
                file.allocateSpace(statesSize);
                file.write(0L, new byte[statesSize]);
                if (this.config.root.clusters.size() <= this.config.id) {
                    this.config.root.clusters.add(this.config);
                } else {
                    this.config.root.clusters.set(this.config.id, this.config);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void open() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.fileId = this.diskCache.openFile(String.valueOf(this.name) + DEF_EXTENSION);
                this.clusterStateHolder.open();
                this.loadClusterState();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean flush) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                if (flush) {
                    this.synch();
                }
                this.diskCache.closeFile(this.fileId, flush);
                this.clusterStateHolder.close();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void delete() throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                this.diskCache.deleteFile(this.fileId);
                this.clusterStateHolder.delete();
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    @Override
    public void set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = value != null ? value.toString() : null;
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                switch (attribute) {
                    case NAME: {
                        this.setNameInternal(stringValue);
                        break;
                    }
                    case USE_WAL: {
                        this.setUseWalInternal(stringValue);
                        break;
                    }
                    case RECORD_GROW_FACTOR: {
                        this.setRecordGrowFactorInternal(stringValue);
                        break;
                    }
                    case RECORD_OVERFLOW_GROW_FACTOR: {
                        this.setRecordOverflowGrowFactorInternal(stringValue);
                        break;
                    }
                    case COMPRESSION: {
                        this.setCompressionInternal(stringValue);
                    }
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private void setCompressionInternal(String stringValue) {
        try {
            this.compression = OCompressionFactory.INSTANCE.getCompression(stringValue);
            this.config.compression = stringValue;
            this.storageLocal.getConfiguration().update();
        }
        catch (IllegalArgumentException e) {
            throw new OStorageException("Invalid value for " + (Object)((Object)OCluster.ATTRIBUTES.COMPRESSION) + " attribute. ", e);
        }
    }

    private void setRecordOverflowGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " can not be less than 1");
            }
            this.config.recordOverflowGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_OVERFLOW_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setRecordGrowFactorInternal(String stringValue) {
        try {
            float growFactor = Float.parseFloat(stringValue);
            if (growFactor < 1.0f) {
                throw new OStorageException((Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " can not be less than 1");
            }
            this.config.recordGrowFactor = growFactor;
            this.storageLocal.getConfiguration().update();
        }
        catch (NumberFormatException nfe) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.RECORD_GROW_FACTOR) + " was passed [" + stringValue + "].", nfe);
        }
    }

    private void setUseWalInternal(String stringValue) {
        if (!stringValue.equals("true") && !stringValue.equals("false")) {
            throw new OStorageException("Invalid value for cluster attribute " + (Object)((Object)OCluster.ATTRIBUTES.USE_WAL) + " was passed [" + stringValue + "].");
        }
        this.config.useWal = Boolean.valueOf(stringValue);
        this.storageLocal.getConfiguration().update();
    }

    private void setNameInternal(String newName) throws IOException {
        this.diskCache.renameFile(this.fileId, this.name, newName);
        this.clusterStateHolder.rename(this.name, newName);
        this.config.name = newName;
        this.storageLocal.renameCluster(this.name, newName);
        this.name = newName;
        this.storageLocal.getConfiguration().update();
    }

    @Override
    public boolean useWal() {
        this.acquireSharedLock();
        try {
            boolean bl = this.config.useWal;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public float recordOverflowGrowFactor() {
        this.acquireSharedLock();
        try {
            float f = this.config.recordOverflowGrowFactor;
            return f;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String compression() {
        this.acquireSharedLock();
        try {
            String string = this.config.compression;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void convertToTombstone(OClusterPosition iPosition) throws IOException {
        throw new UnsupportedOperationException("convertToTombstone");
    }

    public OPhysicalPosition createRecord(byte[] content, ORecordVersion recordVersion, byte recordType, OStorageTransaction transaction) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            OPhysicalPosition oPhysicalPosition;
            int grownContentSize;
            long prevRecordsSize;
            long prevSize;
            block14: {
                this.acquireExclusiveLock();
                prevSize = this.size;
                prevRecordsSize = this.recordsSize;
                content = this.compression.compress(content);
                grownContentSize = (int)(this.config.recordGrowFactor * (float)content.length);
                int entryContentLength = grownContentSize + 2 + 4 + 8;
                if (entryContentLength >= OLocalPage.MAX_RECORD_SIZE) break block14;
                this.startRecordOperation(transaction, false);
                byte[] entryContent = new byte[entryContentLength];
                int entryPosition = 0;
                entryContent[entryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(content.length), entryContent, ++entryPosition);
                System.arraycopy(content, 0, entryContent, entryPosition += 4, content.length);
                entryContent[entryPosition += grownContentSize] = 1;
                OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), entryContent, ++entryPosition);
                OLocalPage.TrackMode trackMode = !this.config.useWal || this.writeAheadLog == null ? OLocalPage.TrackMode.NONE : (transaction != null ? OLocalPage.TrackMode.BOTH : OLocalPage.TrackMode.FORWARD);
                AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, trackMode);
                ++this.size;
                this.recordsSize += (long)addEntryResult.recordsSizeDiff;
                this.logClusterState(prevSize, prevRecordsSize);
                this.endRecordOperation(transaction);
                OPhysicalPosition oPhysicalPosition2 = this.createPhysicalPosition(recordType, addEntryResult.pagePointer, addEntryResult.recordVersion);
                this.releaseExclusiveLock();
                return oPhysicalPosition2;
            }
            try {
                this.startRecordOperation(transaction, true);
                OLocalPage.TrackMode trackMode = !this.config.useWal || this.writeAheadLog == null ? OLocalPage.TrackMode.NONE : OLocalPage.TrackMode.BOTH;
                int entrySize = grownContentSize + 4 + 1;
                int fullEntryPosition = 0;
                byte[] fullEntry = new byte[entrySize];
                fullEntry[fullEntryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(content.length), fullEntry, ++fullEntryPosition);
                System.arraycopy(content, 0, fullEntry, fullEntryPosition += 4, content.length);
                long prevPageRecordPointer = -1L;
                long firstPagePointer = -1L;
                ORecordVersion version = null;
                int from = 0;
                int to = from + (OLocalPage.MAX_RECORD_SIZE - 1 - 8);
                int recordsSizeDiff = 0;
                do {
                    byte[] entryContent = new byte[to - from + 1 + 8];
                    System.arraycopy(fullEntry, from, entryContent, 0, to - from);
                    entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                    OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), entryContent, entryContent.length - 8);
                    AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, trackMode);
                    recordsSizeDiff += addEntryResult.recordsSizeDiff;
                    if (firstPagePointer == -1L) {
                        firstPagePointer = addEntryResult.pagePointer;
                        version = addEntryResult.recordVersion;
                    }
                    long addedPagePointer = addEntryResult.pagePointer;
                    if (prevPageRecordPointer >= 0L) {
                        long prevPageIndex = prevPageRecordPointer >>> 16;
                        int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                        long prevPageMemoryPointer = this.diskCache.load(this.fileId, prevPageIndex);
                        try {
                            OLocalPage prevPage = new OLocalPage(prevPageMemoryPointer, false, OLocalPage.TrackMode.BOTH);
                            int prevRecordPageOffset = prevPage.getRecordPageOffset(prevPageRecordPosition);
                            int prevPageRecordSize = prevPage.getRecordSize(prevPageRecordPosition);
                            prevPage.setLongValue(prevRecordPageOffset + prevPageRecordSize - 8, addedPagePointer);
                            this.logPageChanges(prevPage, prevPageIndex, false);
                            this.diskCache.markDirty(this.fileId, prevPageIndex);
                        }
                        finally {
                            this.diskCache.release(this.fileId, prevPageIndex);
                        }
                    }
                    prevPageRecordPointer = addedPagePointer;
                    from = to;
                    if ((to += OLocalPage.MAX_RECORD_SIZE - 8 - 1) <= fullEntry.length) continue;
                    to = fullEntry.length;
                } while (from < to);
                ++this.size;
                this.recordsSize += (long)recordsSizeDiff;
                this.logClusterState(prevSize, prevRecordsSize);
                this.endRecordOperation(transaction);
                oPhysicalPosition = this.createPhysicalPosition(recordType, firstPagePointer, version);
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oPhysicalPosition;
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private void endRecordOperation(OStorageTransaction transaction) throws IOException {
        if (transaction == null && this.config.useWal && this.writeAheadLog != null) {
            this.writeAheadLog.log(new OAtomicUnitEndRecord(this.currentUnitId.get(), false));
        }
        this.currentUnitId.set(null);
        this.startLSN.set(null);
    }

    private void startRecordOperation(OStorageTransaction transaction, boolean rollbackMode) throws IOException {
        if (transaction == null) {
            if (this.config.useWal && this.writeAheadLog != null) {
                OOperationUnitId unitId = OOperationUnitId.generateId();
                OLogSequenceNumber lsn = this.writeAheadLog.log(new OAtomicUnitStartRecord(rollbackMode, unitId));
                this.startLSN.set(lsn);
                this.currentUnitId.set(unitId);
            }
        } else {
            this.startLSN.set(transaction.getStartLSN());
            this.currentUnitId.set(transaction.getOperationUnitId());
        }
    }

    private OPhysicalPosition createPhysicalPosition(byte recordType, long firstPagePointer, ORecordVersion version) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        physicalPosition.recordType = recordType;
        physicalPosition.recordSize = -1;
        physicalPosition.dataSegmentId = -1;
        physicalPosition.dataSegmentPos = -1L;
        physicalPosition.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(firstPagePointer);
        physicalPosition.recordVersion = version;
        return physicalPosition;
    }

    public ORawBuffer readRecord(OClusterPosition clusterPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long pagePointer = clusterPosition.longValue();
            int recordPosition = (int)(pagePointer & 0xFFFFL);
            long pageIndex = pagePointer >>> 16;
            if (this.diskCache.getFilledUpTo(this.fileId) <= pageIndex) {
                return null;
            }
            ORecordVersion recordVersion = null;
            long pointer = this.diskCache.load(this.fileId, pageIndex);
            try {
                OLocalPage localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                int recordPageOffset = localPage.getRecordPageOffset(recordPosition);
                if (recordPageOffset < 0) {
                    return null;
                }
                recordVersion = localPage.getRecordVersion(recordPosition);
            }
            finally {
                this.diskCache.release(this.fileId, pageIndex);
            }
            byte[] fullContent = this.readFullEntry(clusterPosition);
            if (fullContent == null) {
                return null;
            }
            int fullContentPosition = 0;
            byte recordType = fullContent[fullContentPosition];
            int readContentSize = OIntegerSerializer.INSTANCE.deserializeNative(fullContent, ++fullContentPosition);
            byte[] recordContent = new byte[readContentSize];
            System.arraycopy(fullContent, fullContentPosition += 4, recordContent, 0, recordContent.length);
            recordContent = this.compression.uncompress(recordContent);
            ORawBuffer oRawBuffer = new ORawBuffer(recordContent, recordVersion, recordType);
            return oRawBuffer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private byte[] readFullEntry(OClusterPosition clusterPosition) throws IOException {
        byte[] fullContent;
        long pagePointer = clusterPosition.longValue();
        int recordPosition = (int)(pagePointer & 0xFFFFL);
        long pageIndex = pagePointer >>> 16;
        if (this.diskCache.getFilledUpTo(this.fileId) <= pageIndex) {
            return null;
        }
        ArrayList<byte[]> recordChunks = new ArrayList<byte[]>();
        int contentSize = 0;
        long nextPagePointer = -1L;
        boolean firstEntry = true;
        do {
            long pointer = this.diskCache.load(this.fileId, pageIndex);
            try {
                OLocalPage localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                int recordPageOffset = localPage.getRecordPageOffset(recordPosition);
                if (recordPageOffset < 0) {
                    if (recordChunks.isEmpty()) {
                        return null;
                    }
                    throw new OStorageException("Content of record " + new ORecordId(this.id, clusterPosition) + " was broken.");
                }
                byte[] content = localPage.getBinaryValue(recordPageOffset, localPage.getRecordSize(recordPosition));
                if (firstEntry && content[content.length - 8 - 1] == 0) {
                    return null;
                }
                recordChunks.add(content);
                nextPagePointer = OLongSerializer.INSTANCE.deserializeNative(content, content.length - 8);
                contentSize += content.length - 8 - 1;
                firstEntry = false;
            }
            finally {
                this.diskCache.release(this.fileId, pageIndex);
            }
            pageIndex = nextPagePointer >>> 16;
            recordPosition = (int)(nextPagePointer & 0xFFFFL);
        } while (nextPagePointer >= 0L);
        if (recordChunks.size() == 1) {
            fullContent = (byte[])recordChunks.get(0);
        } else {
            fullContent = new byte[contentSize + 8 + 1];
            int fullContentPosition = 0;
            for (byte[] recordChuck : recordChunks) {
                System.arraycopy(recordChuck, 0, fullContent, fullContentPosition, recordChuck.length - 8 - 1);
                fullContentPosition += recordChuck.length - 8 - 1;
            }
        }
        return fullContent;
    }

    /*
     * Exception decompiling
     */
    public boolean deleteRecord(OClusterPosition clusterPosition, OStorageTransaction transaction) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateRecord(OClusterPosition clusterPosition, byte[] content, ORecordVersion recordVersion, byte recordType, OStorageTransaction transaction) throws IOException {
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                byte[] recordEntry;
                long prevSize = this.size;
                long prevRecordsSize = this.recordsSize;
                byte[] fullEntryContent = this.readFullEntry(clusterPosition);
                if (fullEntryContent == null) {
                    return;
                }
                content = this.compression.compress(content);
                int updatedContentLength = content.length + 2 + 4 + 8;
                long pagePointer = clusterPosition.longValue();
                int recordPosition = (int)(pagePointer & 0xFFFFL);
                long pageIndex = pagePointer >>> 16;
                boolean isRecordSpreadAcrossSeveralPages = this.isRecordSpreadAcrossSeveralPages(pageIndex, recordPosition);
                if (updatedContentLength <= fullEntryContent.length) {
                    recordEntry = new byte[fullEntryContent.length - 8 - 1];
                } else {
                    int grownContent = (int)((float)content.length * this.config.recordOverflowGrowFactor);
                    recordEntry = new byte[grownContent + 1 + 4];
                    isRecordSpreadAcrossSeveralPages = true;
                }
                OLocalPage.TrackMode trackMode = !this.config.useWal || this.writeAheadLog == null ? OLocalPage.TrackMode.NONE : (transaction != null || isRecordSpreadAcrossSeveralPages ? OLocalPage.TrackMode.BOTH : OLocalPage.TrackMode.FORWARD);
                this.startRecordOperation(transaction, isRecordSpreadAcrossSeveralPages);
                int entryPosition = 0;
                recordEntry[entryPosition] = recordType;
                OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(content.length), recordEntry, ++entryPosition);
                System.arraycopy(content, 0, recordEntry, entryPosition += 4, content.length);
                int recordsSizeDiff = 0;
                long prevPageRecordPointer = -1L;
                int currentPos = 0;
                while (pagePointer >= 0L && currentPos < recordEntry.length) {
                    int freePageIndex;
                    recordPosition = (int)(pagePointer & 0xFFFFL);
                    pageIndex = pagePointer >>> 16;
                    long dataPointer = this.diskCache.load(this.fileId, pageIndex);
                    try {
                        OLocalPage localPage = new OLocalPage(dataPointer, false, trackMode);
                        int freeSpace = localPage.getFreeSpace();
                        freePageIndex = this.calculateFreePageIndex(localPage);
                        int recordPageOffset = localPage.getRecordPageOffset(recordPosition);
                        int chunkSize = localPage.getRecordSize(recordPosition);
                        long nextPagePointer = localPage.getLongValue(recordPageOffset + chunkSize - 8);
                        int newChunkLen = Math.min(recordEntry.length - currentPos + 8 + 1, chunkSize);
                        int dataLen = newChunkLen - 8 - 1;
                        byte[] newRecordChunk = new byte[newChunkLen];
                        System.arraycopy(recordEntry, currentPos, newRecordChunk, 0, dataLen);
                        newRecordChunk[newRecordChunk.length - 8 - 1] = currentPos > 0 ? (byte)0 : 1;
                        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), newRecordChunk, newRecordChunk.length - 8);
                        if (prevPageRecordPointer >= 0L) {
                            long prevPageIndex = prevPageRecordPointer >>> 16;
                            int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                            long prevPageMemoryPointer = this.diskCache.load(this.fileId, prevPageIndex);
                            try {
                                OLocalPage prevPage = new OLocalPage(prevPageMemoryPointer, false, trackMode);
                                int prevRecordPageOffset = prevPage.getRecordPageOffset(prevPageRecordPosition);
                                int prevPageRecordSize = prevPage.getRecordSize(prevPageRecordPosition);
                                prevPage.setLongValue(prevRecordPageOffset + prevPageRecordSize - 8, pagePointer);
                                this.logPageChanges(prevPage, prevPageIndex, false);
                                this.diskCache.markDirty(this.fileId, prevPageIndex);
                            }
                            finally {
                                this.diskCache.release(this.fileId, prevPageIndex);
                            }
                        }
                        localPage.replaceRecord(recordPosition, newRecordChunk, recordVersion.getCounter() != -2 ? recordVersion : null);
                        currentPos += dataLen;
                        recordsSizeDiff += freeSpace - localPage.getFreeSpace();
                        prevPageRecordPointer = pagePointer;
                        pagePointer = nextPagePointer;
                        this.logPageChanges(localPage, pageIndex, false);
                        this.diskCache.markDirty(this.fileId, pageIndex);
                    }
                    finally {
                        this.diskCache.release(this.fileId, pageIndex);
                    }
                    this.updateFreePagesIndex(freePageIndex, pageIndex, trackMode);
                }
                int from = currentPos;
                int to = from + (OLocalPage.MAX_RECORD_SIZE - 1 - 8);
                if (to > recordEntry.length) {
                    to = recordEntry.length;
                }
                while (from < to) {
                    byte[] entryContent = new byte[to - from + 1 + 8];
                    System.arraycopy(recordEntry, from, entryContent, 0, to - from);
                    entryContent[entryContent.length - 8 - 1] = from > 0 ? (byte)0 : 1;
                    OLongSerializer.INSTANCE.serializeNative(Long.valueOf(-1L), entryContent, entryContent.length - 8);
                    AddEntryResult addEntryResult = this.addEntry(recordVersion, entryContent, trackMode);
                    recordsSizeDiff += addEntryResult.recordsSizeDiff;
                    long addedPagePointer = addEntryResult.pagePointer;
                    if (prevPageRecordPointer >= 0L) {
                        long prevPageIndex = prevPageRecordPointer >>> 16;
                        int prevPageRecordPosition = (int)(prevPageRecordPointer & 0xFFFFL);
                        long prevPageMemoryPointer = this.diskCache.load(this.fileId, prevPageIndex);
                        try {
                            OLocalPage prevPage = new OLocalPage(prevPageMemoryPointer, false, trackMode);
                            int recordPageOffset = prevPage.getRecordPageOffset(prevPageRecordPosition);
                            int prevPageRecordSize = prevPage.getRecordSize(prevPageRecordPosition);
                            prevPage.setLongValue(recordPageOffset + prevPageRecordSize - 8, addedPagePointer);
                            this.logPageChanges(prevPage, prevPageIndex, false);
                            this.diskCache.markDirty(this.fileId, prevPageIndex);
                        }
                        finally {
                            this.diskCache.release(this.fileId, prevPageIndex);
                        }
                    }
                    prevPageRecordPointer = addedPagePointer;
                    from = to;
                    if ((to += OLocalPage.MAX_RECORD_SIZE - 8 - 1) <= recordEntry.length) continue;
                    to = recordEntry.length;
                }
                this.recordsSize += (long)recordsSizeDiff;
                this.logClusterState(prevSize, prevRecordsSize);
                this.endRecordOperation(transaction);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
    }

    private boolean isRecordSpreadAcrossSeveralPages(long pageIndex, int recordPosition) throws IOException {
        long pagePointer = this.diskCache.load(this.fileId, pageIndex);
        try {
            OLocalPage localPage = new OLocalPage(pagePointer, false, OLocalPage.TrackMode.NONE);
            int recordPageOffset = localPage.getRecordPageOffset(recordPosition);
            if (recordPageOffset < 0) {
                return false;
            }
            int recordSize = localPage.getRecordSize(recordPosition);
            long nextPagePointer = localPage.getLongValue(recordPageOffset + recordSize - 8);
            boolean bl = nextPagePointer >= 0L;
            return bl;
        }
        finally {
            this.diskCache.release(this.fileId, pageIndex);
        }
    }

    private void restorePage(OAbstractPageWALRecord walRecord) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (walRecord instanceof OAddNewPageRecord) {
                return;
            }
            if (!(walRecord instanceof OUpdatePageRecord)) {
                assert (false);
                OLogManager.instance().error((Object)this, "Unknown WAL record type -  %s", new Object[]{walRecord.getClass().getName()});
            }
            this.restorePageData((OUpdatePageRecord)walRecord);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void revertPage(OAbstractPageWALRecord walRecord) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (walRecord instanceof OAddNewPageRecord) {
                return;
            }
            if (!(walRecord instanceof OUpdatePageRecord)) {
                assert (false);
                OLogManager.instance().error((Object)this, "Unknown WAL record type -  %s", new Object[]{walRecord.getClass().getName()});
            }
            this.revertPageData((OUpdatePageRecord)walRecord);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void revertPageData(OUpdatePageRecord updatePageRecord) throws IOException {
        OLogSequenceNumber prevLSN = updatePageRecord.getPrevLsn();
        if (prevLSN == null) {
            OLogManager.instance().error((Object)this, "Current record %s does not have previous LSN reference, rollback is impossible", new Object[]{updatePageRecord});
            assert (false);
        }
        long pageIndex = updatePageRecord.getPageIndex();
        long pagePointer = this.diskCache.load(this.fileId, pageIndex);
        try {
            OLocalPage page = new OLocalPage(pagePointer, false, OLocalPage.TrackMode.NONE);
            List<OPageDiff<?>> pageDiffs = updatePageRecord.getChanges();
            ArrayList fullPageDiffs = new ArrayList(pageDiffs.size());
            for (OPageDiff<?> pageDiff : pageDiffs) {
                if (pageDiff instanceof OFullPageDiff) {
                    fullPageDiffs.add((OFullPageDiff)pageDiff);
                    continue;
                }
                assert (false);
                OLogManager.instance().error((Object)this, "Record operation %s can not be reverted, rollback will be aborted.", new Object[]{updatePageRecord});
                return;
            }
            page.revertChanges(fullPageDiffs);
            page.setLsn(prevLSN);
            this.diskCache.markDirty(this.fileId, pageIndex);
        }
        finally {
            this.diskCache.release(this.fileId, pageIndex);
        }
    }

    private void restorePageData(OUpdatePageRecord updatePageRecord) throws IOException {
        long pageIndex = updatePageRecord.getPageIndex();
        long pagePointer = this.diskCache.load(this.fileId, pageIndex);
        try {
            OLocalPage page = new OLocalPage(pagePointer, false, OLocalPage.TrackMode.NONE);
            page.restoreChanges(updatePageRecord.getChanges());
            page.setLsn(updatePageRecord.getLsn());
            this.diskCache.markDirty(this.fileId, pageIndex);
        }
        finally {
            this.diskCache.release(this.fileId, pageIndex);
        }
    }

    private AddEntryResult addEntry(ORecordVersion recordVersion, byte[] entryContent, OLocalPage.TrackMode trackMode) throws IOException {
        int recordSizesDiff;
        ORecordVersion finalVersion;
        int position;
        FindFreePageResult findFreePageResult = this.findFreePage(entryContent.length, trackMode);
        int freePageIndex = findFreePageResult.freePageIndex;
        long pageIndex = findFreePageResult.pageIndex;
        boolean newRecord = freePageIndex >= this.freePageLists.length;
        long pagePointer = this.diskCache.load(this.fileId, pageIndex);
        try {
            OLocalPage localPage = new OLocalPage(pagePointer, newRecord, trackMode);
            assert (newRecord || freePageIndex == this.calculateFreePageIndex(localPage));
            int initialFreeSpace = localPage.getFreeSpace();
            position = localPage.appendRecord(recordVersion, entryContent, false);
            assert (position >= 0);
            finalVersion = localPage.getRecordVersion(position);
            int freeSpace = localPage.getFreeSpace();
            recordSizesDiff = initialFreeSpace - freeSpace;
            this.logPageChanges(localPage, pageIndex, newRecord);
            this.diskCache.markDirty(this.fileId, pageIndex);
        }
        finally {
            this.diskCache.release(this.fileId, pageIndex);
        }
        this.updateFreePagesIndex(freePageIndex, pageIndex, trackMode);
        return new AddEntryResult(pageIndex << 16 | (long)position, finalVersion, recordSizesDiff);
    }

    private FindFreePageResult findFreePage(int contentSize, OLocalPage.TrackMode trackMode) throws IOException {
        long pageIndex;
        int freePageIndex;
        while (true) {
            int realFreePageIndex;
            freePageIndex = contentSize / 1024;
            if ((freePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger()) < 0) {
                freePageIndex = 0;
            }
            while ((pageIndex = this.freePageLists[freePageIndex]) < 0L && ++freePageIndex < this.freePageLists.length) {
            }
            if (pageIndex < 0L) {
                pageIndex = this.diskCache.getFilledUpTo(this.fileId);
            } else {
                --freePageIndex;
            }
            if (freePageIndex >= this.freePageLists.length) break;
            long pointer = this.diskCache.load(this.fileId, pageIndex);
            try {
                OLocalPage localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                realFreePageIndex = this.calculateFreePageIndex(localPage);
            }
            finally {
                this.diskCache.release(this.fileId, pageIndex);
            }
            if (realFreePageIndex == freePageIndex) break;
            OLogManager.instance().warn((Object)this, "Page in file %s with index %d was placed in wrong free list, this error will be fixed automatically.", new Object[]{String.valueOf(this.name) + DEF_EXTENSION, pageIndex});
            this.updateFreePagesIndex(freePageIndex, pageIndex, trackMode);
        }
        return new FindFreePageResult(pageIndex, freePageIndex);
    }

    private void updateFreePagesIndex(int prevFreePageIndex, long pageIndex, OLocalPage.TrackMode trackMode) throws IOException {
        long pointer = this.diskCache.load(this.fileId, pageIndex);
        try {
            OLocalPage localPage = new OLocalPage(pointer, false, trackMode);
            int newFreePageIndex = this.calculateFreePageIndex(localPage);
            if (prevFreePageIndex == newFreePageIndex) {
                return;
            }
            long nextPageIndex = localPage.getNextPage();
            long prevPageIndex = localPage.getPrevPage();
            if (prevPageIndex >= 0L) {
                long prevPagePointer = this.diskCache.load(this.fileId, prevPageIndex);
                try {
                    OLocalPage prevPage = new OLocalPage(prevPagePointer, false, trackMode);
                    assert (this.calculateFreePageIndex(prevPage) == prevFreePageIndex);
                    prevPage.setNextPage(nextPageIndex);
                    this.logPageChanges(prevPage, prevPageIndex, false);
                    this.diskCache.markDirty(this.fileId, prevPageIndex);
                }
                finally {
                    this.diskCache.release(this.fileId, prevPageIndex);
                }
            }
            if (nextPageIndex >= 0L) {
                long nextPagePointer = this.diskCache.load(this.fileId, nextPageIndex);
                try {
                    OLocalPage nextPage = new OLocalPage(nextPagePointer, false, trackMode);
                    if (this.calculateFreePageIndex(nextPage) != prevFreePageIndex) {
                        this.calculateFreePageIndex(nextPage);
                    }
                    assert (this.calculateFreePageIndex(nextPage) == prevFreePageIndex);
                    nextPage.setPrevPage(prevPageIndex);
                    this.logPageChanges(nextPage, nextPageIndex, false);
                    this.diskCache.markDirty(this.fileId, nextPageIndex);
                }
                finally {
                    this.diskCache.release(this.fileId, nextPageIndex);
                }
            }
            localPage.setNextPage(-1L);
            localPage.setPrevPage(-1L);
            if (prevFreePageIndex < 0 && newFreePageIndex < 0) {
                return;
            }
            if (prevFreePageIndex >= 0 && prevFreePageIndex < this.freePageLists.length && prevPageIndex < 0L) {
                this.updateFreePagesList(prevFreePageIndex, nextPageIndex);
            }
            if (newFreePageIndex >= 0) {
                long oldFreePage = this.freePageLists[newFreePageIndex];
                if (oldFreePage >= 0L) {
                    long oldFreePagePointer = this.diskCache.load(this.fileId, oldFreePage);
                    try {
                        OLocalPage oldFreeLocalPage = new OLocalPage(oldFreePagePointer, false, trackMode);
                        assert (this.calculateFreePageIndex(oldFreeLocalPage) == newFreePageIndex);
                        oldFreeLocalPage.setPrevPage(pageIndex);
                        this.logPageChanges(oldFreeLocalPage, oldFreePage, false);
                        this.diskCache.markDirty(this.fileId, oldFreePage);
                    }
                    finally {
                        this.diskCache.release(this.fileId, oldFreePage);
                    }
                    localPage.setNextPage(oldFreePage);
                    localPage.setPrevPage(-1L);
                }
                this.updateFreePagesList(newFreePageIndex, pageIndex);
            }
            this.logPageChanges(localPage, pageIndex, false);
            this.diskCache.markDirty(this.fileId, pageIndex);
        }
        finally {
            this.diskCache.release(this.fileId, pageIndex);
        }
    }

    private void updateFreePagesList(int freePageIndex, long pageIndex) throws IOException {
        if (!this.config.useWal || this.writeAheadLog == null) {
            this.freePageLists[freePageIndex] = pageIndex;
        } else {
            long prevPageIndex = this.freePageLists[freePageIndex];
            this.freePageLists[freePageIndex] = pageIndex;
            this.writeAheadLog.log(new OFreePageChangeRecord(this.currentUnitId.get(), this.id, freePageIndex, prevPageIndex, pageIndex));
        }
    }

    private void logPageChanges(OLocalPage localPage, long pageIndex, boolean isNewPage) throws IOException {
        if (this.config.useWal && this.writeAheadLog != null) {
            List<OPageDiff<?>> pageChanges = localPage.getPageChanges();
            if (pageChanges.isEmpty()) {
                return;
            }
            OOperationUnitId unitId = this.currentUnitId.get();
            assert (unitId != null);
            OLogSequenceNumber prevLsn = isNewPage ? this.startLSN.get() : localPage.getLsn();
            OLogSequenceNumber lsn = this.writeAheadLog.log(new OUpdatePageRecord(pageIndex, this.id, unitId, pageChanges, prevLsn));
            localPage.setLsn(lsn);
        }
    }

    private int calculateFreePageIndex(OLocalPage localPage) {
        int newFreePageIndex;
        if (localPage.isEmpty()) {
            newFreePageIndex = this.freePageLists.length - 1;
        } else {
            newFreePageIndex = (localPage.getMaxRecordSize() - 1023) / 1024;
            newFreePageIndex -= OGlobalConfiguration.PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY.getValueAsInteger();
        }
        return newFreePageIndex;
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public boolean hasTombstonesSupport() {
        return false;
    }

    @Override
    public void truncate() throws IOException {
        this.storageLocal.checkForClusterPermissions(this.getName());
        this.externalModificationLock.requestModificationLock();
        try {
            this.acquireExclusiveLock();
            try {
                long prevSize = this.size;
                long prevRecordsSize = this.recordsSize;
                if (this.config.useWal && this.writeAheadLog != null) {
                    OOperationUnitId operationUnitId = OOperationUnitId.generateId();
                    OLogSequenceNumber lsn = this.writeAheadLog.log(new OAtomicUnitStartRecord(false, operationUnitId));
                    this.currentUnitId.set(operationUnitId);
                    this.startLSN.set(lsn);
                }
                this.diskCache.truncateFile(this.fileId);
                this.clusterStateHolder.truncate();
                this.size = 0L;
                this.recordsSize = 0L;
                this.logClusterState(prevSize, prevRecordsSize);
                if (this.config.useWal && this.writeAheadLog != null) {
                    this.writeAheadLog.log(new OAtomicUnitEndRecord(this.currentUnitId.get(), false));
                    this.currentUnitId.set(null);
                    this.startLSN.set(null);
                }
                int i = 0;
                while (i < this.freePageLists.length) {
                    this.freePageLists[i] = -1L;
                    ++i;
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.externalModificationLock.releaseModificationLock();
        }
        this.storageLocal.scheduleFullCheckpoint();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getDataSegmentId() {
        return -1;
    }

    @Override
    public boolean addPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        throw new UnsupportedOperationException("addPhysicalPosition");
    }

    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            int recordPageOffset;
            OLocalPage localPage;
            int recordPosition;
            long pageIndex;
            block13: {
                block12: {
                    OClusterPosition clusterPosition = position.clusterPosition;
                    long pagePointer = clusterPosition.longValue();
                    pageIndex = pagePointer >>> 16;
                    recordPosition = (int)(pagePointer & 0xFFFFL);
                    long pagesCount = this.diskCache.getFilledUpTo(this.fileId);
                    if (pageIndex >= pagesCount) {
                        return null;
                    }
                    long pointer = this.diskCache.load(this.fileId, pageIndex);
                    try {
                        localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                        recordPageOffset = localPage.getRecordPageOffset(recordPosition);
                        if (recordPageOffset >= 0) break block12;
                        this.diskCache.release(this.fileId, pageIndex);
                        return null;
                    }
                    catch (Throwable throwable) {
                        this.diskCache.release(this.fileId, pageIndex);
                        throw throwable;
                    }
                }
                int recordSize = localPage.getRecordSize(recordPosition);
                if (localPage.getByteValue(recordPageOffset + recordSize - 8 - 1) != 0) break block13;
                this.diskCache.release(this.fileId, pageIndex);
                return null;
            }
            OPhysicalPosition physicalPosition = new OPhysicalPosition();
            physicalPosition.dataSegmentId = -1;
            physicalPosition.dataSegmentPos = -1L;
            physicalPosition.recordSize = -1;
            physicalPosition.recordType = localPage.getByteValue(recordPageOffset);
            physicalPosition.recordVersion = localPage.getRecordVersion(recordPosition);
            physicalPosition.clusterPosition = position.clusterPosition;
            OPhysicalPosition oPhysicalPosition = physicalPosition;
            this.diskCache.release(this.fileId, pageIndex);
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void updateDataSegmentPosition(OClusterPosition iPosition, int iDataSegmentId, long iDataPosition) throws IOException {
        throw new UnsupportedOperationException("updateDataSegmentPosition");
    }

    @Override
    public void removePhysicalPosition(OClusterPosition iPosition) throws IOException {
        throw new UnsupportedOperationException("updateDataSegmentPosition");
    }

    @Override
    public void updateRecordType(OClusterPosition iPosition, byte iRecordType) throws IOException {
        throw new UnsupportedOperationException("updateRecordType");
    }

    @Override
    public void updateVersion(OClusterPosition iPosition, ORecordVersion iVersion) throws IOException {
        throw new UnsupportedOperationException("updateVersion");
    }

    @Override
    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.size;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getFirstPosition() throws IOException {
        this.acquireSharedLock();
        try {
            OPhysicalPosition[] physicalPositions = this.findFirstPhysicalPosition(0L, 0);
            if (physicalPositions.length == 0) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition oClusterPosition = physicalPositions[0].clusterPosition;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition getLastPosition() throws IOException {
        this.acquireSharedLock();
        try {
            long pagesCount = this.diskCache.getFilledUpTo(this.fileId);
            long i = pagesCount - 1L;
            while (i >= 0L) {
                long pagePointer = this.diskCache.load(this.fileId, i);
                try {
                    OLocalPage localPage = new OLocalPage(pagePointer, false, OLocalPage.TrackMode.NONE);
                    int recordsCount = localPage.getRecordsCount();
                    if (recordsCount > 0) {
                        int recordPosition = Integer.MAX_VALUE;
                        int n = 0;
                        while (n < recordsCount) {
                            int recordSize;
                            int recordPageOffset = localPage.getRecordPageOffset(recordPosition = localPage.findLastRecord(recordPosition));
                            if (localPage.getByteValue(recordPageOffset + (recordSize = localPage.getRecordSize(recordPosition)) - 1 - 8) == 1) {
                                OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(i << 16 | (long)recordPosition);
                                return oClusterPosition;
                            }
                            --recordPosition;
                            ++n;
                        }
                    }
                }
                finally {
                    this.diskCache.release(this.fileId, i);
                }
                --i;
            }
            OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void lock() {
        throw new UnsupportedOperationException("lock");
    }

    @Override
    public void unlock() {
        throw new UnsupportedOperationException("unlock");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void synch() throws IOException {
        this.acquireSharedLock();
        try {
            this.diskCache.flushFile(this.fileId);
            this.flushClusterState();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.setSoftlyClosed(this.fileId, softlyClosed);
            this.clusterStateHolder.setSoftlyClosed(softlyClosed);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed() throws IOException {
        this.acquireSharedLock();
        try {
            boolean wasSoftlyClosed = this.diskCache.wasSoftlyClosed(this.fileId);
            boolean bl = wasSoftlyClosed = wasSoftlyClosed && this.clusterStateHolder.wasSoftlyClosedAtPreviousTime();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getRecordsSize() throws IOException {
        this.acquireSharedLock();
        try {
            long l = this.recordsSize;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        this.acquireSharedLock();
        try {
            OClusterEntryIterator oClusterEntryIterator = new OClusterEntryIterator(this);
            return oClusterEntryIterator;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            int recordPosition;
            long pageIndex;
            OClusterPosition clusterPosition = position.clusterPosition;
            long pagePointer = clusterPosition.longValue();
            if (pagePointer >= 0L) {
                pageIndex = pagePointer >>> 16;
                recordPosition = (int)(pagePointer & 0xFFFFL) + 1;
            } else {
                pageIndex = 0L;
                recordPosition = 0;
            }
            OPhysicalPosition[] oPhysicalPositionArray = this.findFirstPhysicalPosition(pageIndex, recordPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition clusterPosition = position.clusterPosition;
            long pagePointer = clusterPosition.longValue();
            long pageIndex = pagePointer >>> 16;
            int recordPosition = (int)(pagePointer & 0xFFFFL);
            OPhysicalPosition[] oPhysicalPositionArray = this.findFirstPhysicalPosition(pageIndex, recordPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition clusterPosition = position.clusterPosition;
            long pagePointer = clusterPosition.longValue();
            long pageIndex = pagePointer >>> 16;
            int recordPosition = (int)(pagePointer & 0xFFFFL) - 1;
            OPhysicalPosition[] oPhysicalPositionArray = this.findLastPhysicalPosition(pageIndex, recordPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            OClusterPosition clusterPosition = position.clusterPosition;
            long pagePointer = clusterPosition.longValue();
            long pageIndex = pagePointer >>> 16;
            int recordPosition = (int)(pagePointer & 0xFFFFL);
            OPhysicalPosition[] oPhysicalPositionArray = this.findLastPhysicalPosition(pageIndex, recordPosition);
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OModificationLock getExternalModificationLock() {
        return this.externalModificationLock;
    }

    private OPhysicalPosition[] findFirstPhysicalPosition(long pageIndex, int recordPosition) throws IOException {
        long pagesCount = this.diskCache.getFilledUpTo(this.fileId);
        long i = pageIndex;
        while (i < pagesCount) {
            block9: {
                long pointer = this.diskCache.load(this.fileId, i);
                try {
                    OLocalPage localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                    int recordsCount = localPage.getRecordsCount();
                    if (recordsCount <= 0) break block9;
                    while (true) {
                        int recordSize;
                        if ((recordPosition = localPage.findFirstRecord(recordPosition)) < 0) {
                            recordPosition = 0;
                            break;
                        }
                        int recordPageOffset = localPage.getRecordPageOffset(recordPosition);
                        if (localPage.getByteValue(recordPageOffset + (recordSize = localPage.getRecordSize(recordPosition)) - 8 - 1) == 1) {
                            OPhysicalPosition physicalPosition = new OPhysicalPosition();
                            physicalPosition.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(i << 16 | (long)recordPosition);
                            physicalPosition.recordVersion = localPage.getRecordVersion(recordPosition);
                            physicalPosition.recordType = localPage.getByteValue(recordPageOffset);
                            physicalPosition.recordSize = -1;
                            physicalPosition.dataSegmentId = -1;
                            physicalPosition.dataSegmentPos = -1L;
                            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{physicalPosition};
                            return oPhysicalPositionArray;
                        }
                        ++recordPosition;
                    }
                }
                finally {
                    this.diskCache.release(this.fileId, i);
                }
            }
            ++i;
        }
        return new OPhysicalPosition[0];
    }

    private OPhysicalPosition[] findLastPhysicalPosition(long pageIndex, int recordPosition) throws IOException {
        long endPageIndex;
        long pagesCount = this.diskCache.getFilledUpTo(this.fileId);
        if (pagesCount <= pageIndex) {
            recordPosition = Integer.MAX_VALUE;
            endPageIndex = pagesCount - 1L;
        } else {
            endPageIndex = pageIndex;
        }
        long i = endPageIndex;
        while (i >= 0L) {
            block11: {
                long pointer = this.diskCache.load(this.fileId, i);
                try {
                    OLocalPage localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                    int recordsCount = localPage.getRecordsCount();
                    if (recordsCount <= 0) break block11;
                    while (true) {
                        int recordSize;
                        if ((recordPosition = localPage.findLastRecord(recordPosition)) < 0) {
                            recordPosition = Integer.MAX_VALUE;
                            break;
                        }
                        int recordPageOffset = localPage.getRecordPageOffset(recordPosition);
                        if (localPage.getByteValue(recordPageOffset + (recordSize = localPage.getRecordSize(recordPosition)) - 8 - 1) == 1) {
                            OPhysicalPosition physicalPosition = new OPhysicalPosition();
                            physicalPosition.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(i << 16 | (long)recordPosition);
                            physicalPosition.recordVersion = localPage.getRecordVersion(recordPosition);
                            physicalPosition.recordType = localPage.getByteValue(recordPageOffset);
                            physicalPosition.recordSize = -1;
                            physicalPosition.dataSegmentId = -1;
                            physicalPosition.dataSegmentPos = -1L;
                            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{physicalPosition};
                            return oPhysicalPositionArray;
                        }
                        --recordPosition;
                    }
                }
                finally {
                    this.diskCache.release(this.fileId, i);
                }
            }
            --i;
        }
        return new OPhysicalPosition[0];
    }

    public void flushClusterState() throws IOException {
        OFile file = this.clusterStateHolder.getFile();
        CRC32 crc32 = new CRC32();
        byte[] clusterState = new byte[STATE_SIZE];
        int offset = 4;
        if (this.config.useWal && this.writeAheadLog != null) {
            OLogSequenceNumber end = this.writeAheadLog.end();
            OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(end.getSegment()), clusterState, offset += 4);
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(end.getPosition()), clusterState, offset += 4);
            offset += 8;
        } else {
            OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(1), clusterState, offset);
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(System.currentTimeMillis()), clusterState, offset += 4);
            offset += 12;
        }
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.size), clusterState, offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.recordsSize), clusterState, offset += 8);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.freePageLists.length), clusterState, offset += 8);
        offset += 4;
        long[] lArray = this.freePageLists;
        int n = this.freePageLists.length;
        int n2 = 0;
        while (n2 < n) {
            long freePageIndex = lArray[n2];
            OLongSerializer.INSTANCE.serializeNative(Long.valueOf(freePageIndex), clusterState, offset);
            offset += 8;
            ++n2;
        }
        crc32.update(clusterState, 4, STATE_SIZE - 4);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf((int)crc32.getValue()), clusterState, 0);
        long fileOffset = this.useFirstStateHolder ? 0L : (long)STATE_SIZE;
        this.useFirstStateHolder = !this.useFirstStateHolder;
        file.write(fileOffset, clusterState);
        this.clusterStateHolder.synch();
    }

    private void loadClusterState() throws IOException {
        byte[] clusterState;
        Comparable<Long> tsTwo;
        Comparable<Long> tsOne;
        OFile file = this.clusterStateHolder.getFile();
        byte[] clusterStateOne = new byte[STATE_SIZE];
        byte[] clusterStateTwo = new byte[STATE_SIZE];
        file.read(0L, clusterStateOne, STATE_SIZE);
        file.read(STATE_SIZE, clusterStateTwo, STATE_SIZE);
        CRC32 crc32 = new CRC32();
        crc32.update(clusterStateOne, 4, STATE_SIZE - 4);
        int crcOne = OIntegerSerializer.INSTANCE.deserializeNative(clusterStateOne, 0);
        if (crcOne != (int)crc32.getValue()) {
            tsOne = null;
        } else {
            int type = OIntegerSerializer.INSTANCE.deserializeNative(clusterStateOne, 4);
            if (type == 1) {
                tsOne = OLongSerializer.INSTANCE.deserializeNative(clusterStateOne, 8);
            } else if (type == 0) {
                int segment = OIntegerSerializer.INSTANCE.deserializeNative(clusterStateOne, 8);
                long position = OLongSerializer.INSTANCE.deserializeNative(clusterStateOne, 12);
                tsOne = new OLogSequenceNumber(segment, position);
            } else {
                throw new OStorageException("Invalid type of cluster state timestamp");
            }
        }
        int crcTwo = OIntegerSerializer.INSTANCE.deserializeNative(clusterStateTwo, 0);
        crc32.reset();
        crc32.update(clusterStateTwo, 4, STATE_SIZE - 4);
        if (crcTwo != (int)crc32.getValue()) {
            tsTwo = null;
        } else {
            int type = OIntegerSerializer.INSTANCE.deserializeNative(clusterStateTwo, 4);
            if (type == 1) {
                tsTwo = OLongSerializer.INSTANCE.deserializeNative(clusterStateTwo, 8);
            } else if (type == 0) {
                int segment = OIntegerSerializer.INSTANCE.deserializeNative(clusterStateTwo, 8);
                long position = OLongSerializer.INSTANCE.deserializeNative(clusterStateTwo, 12);
                tsTwo = new OLogSequenceNumber(segment, position);
            } else {
                throw new OStorageException("Invalid type of cluster state timestamp");
            }
        }
        if (tsOne == null && tsTwo == null) {
            OLogManager.instance().error((Object)this, "Cluster state can not be loaded from file.", new Object[0]);
            return;
        }
        if (tsOne == null) {
            clusterState = clusterStateTwo;
            this.useFirstStateHolder = true;
        } else if (tsTwo == null) {
            clusterState = clusterStateOne;
            this.useFirstStateHolder = false;
        } else {
            int cmp = tsOne.compareTo((Long)tsTwo);
            if (cmp >= 0) {
                clusterState = clusterStateOne;
                this.useFirstStateHolder = false;
            } else {
                clusterState = clusterStateTwo;
                this.useFirstStateHolder = true;
            }
        }
        int offset = 20;
        this.size = OLongSerializer.INSTANCE.deserializeNative(clusterState, offset);
        this.recordsSize = OLongSerializer.INSTANCE.deserializeNative(clusterState, offset += 8);
        int freeListSize = OIntegerSerializer.INSTANCE.deserializeNative(clusterState, offset += 8);
        offset += 4;
        this.freePageLists = new long[freeListSize];
        int i = 0;
        while (i < freeListSize) {
            this.freePageLists[i] = OLongSerializer.INSTANCE.deserializeNative(clusterState, offset);
            offset += 8;
            ++i;
        }
    }

    private boolean checkFreePages() throws IOException {
        long filledUpTo = this.diskCache.getFilledUpTo(this.fileId);
        long i = 0L;
        while (i < filledUpTo) {
            block6: {
                int freePageIndex;
                block5: {
                    long pointer = this.diskCache.load(this.fileId, i);
                    try {
                        OLocalPage page = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                        freePageIndex = this.calculateFreePageIndex(page);
                        if (freePageIndex >= 0) break block5;
                        break block6;
                    }
                    finally {
                        this.diskCache.release(this.fileId, i);
                    }
                }
                if (!this.findInFreeList(freePageIndex, i)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean findInFreeList(int freePageIndex, long testPageIndex) throws IOException {
        long pageIndex = this.freePageLists[freePageIndex];
        long prevPageIndex = -1L;
        while (pageIndex != testPageIndex && pageIndex >= 0L) {
            long nextPageIndex;
            long pointer = this.diskCache.load(this.fileId, pageIndex);
            try {
                OLocalPage localPage = new OLocalPage(pointer, false, OLocalPage.TrackMode.NONE);
                assert (prevPageIndex == localPage.getPrevPage());
                prevPageIndex = pageIndex;
                nextPageIndex = localPage.getNextPage();
            }
            finally {
                this.diskCache.release(this.fileId, pageIndex);
            }
            pageIndex = nextPageIndex;
        }
        return pageIndex == testPageIndex;
    }

    private void logClusterState(long prevSize, long prevRecordsSize) throws IOException {
        if (!this.config.useWal || this.writeAheadLog == null) {
            return;
        }
        OOperationUnitId operationUnitId = this.currentUnitId.get();
        assert (operationUnitId != null);
        this.writeAheadLog.log(new OClusterStateRecord(this.size, this.recordsSize, this.id, prevSize, prevRecordsSize, operationUnitId));
    }

    private void restoreClusterState(OClusterStateRecord walRecord) {
        this.size = walRecord.getSize();
        this.recordsSize = walRecord.getRecordsSize();
    }

    public void restoreRecord(OWALRecord record) throws IOException {
        if (record instanceof OClusterStateRecord) {
            this.restoreClusterState((OClusterStateRecord)record);
        } else if (record instanceof OAbstractPageWALRecord) {
            this.restorePage((OAbstractPageWALRecord)record);
        } else if (record instanceof OFreePageChangeRecord) {
            this.restoreFreePageListState((OFreePageChangeRecord)record);
        } else {
            OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{record.getClass()});
            assert (false) : "Invalid WAL record type was passed " + record.getClass().getName();
        }
    }

    private void restoreFreePageListState(OFreePageChangeRecord record) {
        this.freePageLists[record.getFreePageIndex()] = record.getPageIndex();
    }

    public void revertRecord(OWALRecord record) throws IOException {
        if (record instanceof OClusterStateRecord) {
            OClusterStateRecord clusterStateRecord = (OClusterStateRecord)record;
            this.recordsSize = clusterStateRecord.getPrevRecordsSize();
            this.size = clusterStateRecord.getPrevSize();
        } else if (record instanceof OAbstractPageWALRecord) {
            this.revertPage((OAbstractPageWALRecord)record);
        } else if (record instanceof OFreePageChangeRecord) {
            this.revertFreePageListState((OFreePageChangeRecord)record);
        } else {
            OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{record.getClass()});
            assert (false) : "Invalid WAL record type was passed " + record.getClass().getName();
        }
    }

    private void revertFreePageListState(OFreePageChangeRecord record) {
        this.freePageLists[record.getFreePageIndex()] = record.getPrevPageIndex();
    }

    private static final class AddEntryResult {
        private final long pagePointer;
        private final ORecordVersion recordVersion;
        private final int recordsSizeDiff;

        public AddEntryResult(long pagePointer, ORecordVersion recordVersion, int recordsSizeDiff) {
            this.pagePointer = pagePointer;
            this.recordVersion = recordVersion;
            this.recordsSizeDiff = recordsSizeDiff;
        }
    }

    private static final class FindFreePageResult {
        private final long pageIndex;
        private final int freePageIndex;

        private FindFreePageResult(long pageIndex, int freePageIndex) {
            this.pageIndex = pageIndex;
            this.freePageIndex = freePageIndex;
        }
    }
}

