/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationLock;
import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.hashindex.local.cache.O2QCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OClusterAwareWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPagesRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class OLocalPaginatedStorage
extends OStorageLocalAbstract {
    private static final int ONE_KB = 1024;
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final Map<String, OLocalPaginatedCluster> clusterMap = new LinkedHashMap<String, OLocalPaginatedCluster>();
    private OLocalPaginatedCluster[] clusters = new OLocalPaginatedCluster[0];
    private String storagePath;
    private final OStorageVariableParser variableParser;
    private int defaultClusterId = -1;
    private static String[] ALL_FILE_EXTENSIONS = new String[]{".ocf", ".pls", ".pcl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".wal", ".wmr", ".hib", ".him", ".hit"};
    private OModificationLock modificationLock = new OModificationLock();
    private ODiskCache diskCache;
    private OWriteAheadLog writeAheadLog;
    private ScheduledExecutorService fuzzyCheckpointExecutor;
    private ExecutorService checkpointExecutor;
    private OStorageTransaction transaction = null;
    private volatile boolean wereDataRestoredAfterOpen = false;
    private boolean makeFullCheckPointAfterClusterCreate = OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CLUSTER_CREATE.getValueAsBoolean();

    public OLocalPaginatedStorage(String name, String filePath, String mode) throws IOException {
        super(name, filePath, mode);
        File f = new File(this.url);
        this.storagePath = f.exists() || !this.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getParent()));
        this.storagePath = OIOUtils.getPathFromDatabaseName((String)this.storagePath);
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
    }

    private void initWal() throws IOException {
        ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
        if (OGlobalConfiguration.USE_WAL.getValueAsBoolean()) {
            this.fuzzyCheckpointExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.checkpointExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.writeAheadLog = new OWriteAheadLog(this);
            int fuzzyCheckpointDelay = OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger();
            this.fuzzyCheckpointExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        OLocalPaginatedStorage.this.makeFuzzyCheckpoint();
                    }
                    catch (Throwable e) {
                        OLogManager.instance().error((Object)this, "Error during background fuzzy checkpoint creation for storage " + OLocalPaginatedStorage.this.name, e, new Object[0]);
                    }
                }
            }, fuzzyCheckpointDelay, fuzzyCheckpointDelay, TimeUnit.SECONDS);
        } else {
            this.writeAheadLog = null;
        }
        this.diskCache = new O2QCache(OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L, OGlobalConfiguration.DISK_CACHE_WRITE_QUEUE_LENGTH.getValueAsInteger(), directMemory, this.writeAheadLog, OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, this, false);
    }

    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.lock.acquireExclusiveLock();
        try {
            this.addUser();
            if (this.status != OStorage.STATUS.CLOSED) {
                return;
            }
            try {
                if (!this.exists()) {
                    throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
                }
                this.initWal();
                this.status = OStorage.STATUS.OPEN;
                this.addDefaultClusters();
                int i = 0;
                while (i < this.configuration.clusters.size()) {
                    block15: {
                        OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                        if (clusterConfig != null) {
                            int pos = this.createClusterFromConfig(clusterConfig);
                            try {
                                if (pos == -1) {
                                    this.clusters[i].open();
                                    break block15;
                                }
                                if (clusterConfig.getName().equals("default")) {
                                    this.defaultClusterId = pos;
                                }
                                this.clusters[pos].open();
                            }
                            catch (FileNotFoundException e) {
                                OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters[i].getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", new Object[0]);
                                this.clusterMap.remove(this.clusters[i].getName());
                                this.clusters[i] = null;
                            }
                        } else {
                            this.clusters = Arrays.copyOf(this.clusters, this.clusters.length + 1);
                            this.clusters[i] = null;
                        }
                    }
                    ++i;
                }
                this.restoreIfNeeded();
            }
            catch (Exception e) {
                this.close(true);
                throw new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode, e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    private void restoreIfNeeded() throws IOException {
        boolean wasSoftlyClosed = true;
        OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
        int n = this.clusters.length;
        int n2 = 0;
        while (n2 < n) {
            OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
            if (cluster != null && !cluster.wasSoftlyClosed()) {
                wasSoftlyClosed = false;
            }
            ++n2;
        }
        if (!wasSoftlyClosed) {
            OLogManager.instance().warn((Object)this, "Storage " + this.name + " was not closed properly. Will try to restore from write ahead log.", new Object[0]);
            try {
                try {
                    this.restoreFromWAL();
                    this.makeFullCheckpoint();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Exception during storage data restore.", (Throwable)e, new Object[0]);
                    OLogManager.instance().info((Object)this, "Storage data restore was completed", new Object[0]);
                }
            }
            finally {
                OLogManager.instance().info((Object)this, "Storage data restore was completed", new Object[0]);
            }
        }
    }

    private void restoreFromWAL() throws IOException {
        OWALRecord checkPointRecord;
        if (this.writeAheadLog == null) {
            OLogManager.instance().error((Object)this, "Restore is not possible because write ahead logging is switched off.", new Object[0]);
            return;
        }
        if (this.writeAheadLog.begin() == null) {
            OLogManager.instance().error((Object)this, "Restore is not possible because write ahead log is empty.", new Object[0]);
            return;
        }
        OLogManager.instance().info((Object)this, "Try to find last checkpoint.", new Object[0]);
        OLogSequenceNumber lastCheckPoint = this.writeAheadLog.getLastCheckpoint();
        if (lastCheckPoint == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent will restore from beginning.", new Object[0]);
            this.restoreFromBegging();
        }
        if ((checkPointRecord = this.writeAheadLog.read(lastCheckPoint)) == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent will restore from beginning.", new Object[0]);
            this.restoreFromBegging();
            return;
        }
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "Found checkpoint is fuzzy checkpoint.", new Object[0]);
            boolean fuzzyCheckPointIsComplete = this.checkFuzzyCheckPointIsComplete(lastCheckPoint);
            if (!fuzzyCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "Fuzzy checkpoint is not complete.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFuzzyCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Will restore from previous checkpoint.", new Object[0]);
                    this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                } else {
                    OLogManager.instance().warn((Object)this, "Will restore from beginning.", new Object[0]);
                    this.restoreFromBegging();
                }
            } else {
                this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
            }
            return;
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "Found checkpoint is full checkpoint.", new Object[0]);
            boolean fullCheckPointIsComplete = this.checkFullCheckPointIsComplete(lastCheckPoint);
            if (!fullCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "Full checkpoint is not complete.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFullCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Will restore from previous checkpoint.", new Object[0]);
                } else {
                    OLogManager.instance().warn((Object)this, "Will restore from beginning.", new Object[0]);
                    this.restoreFromBegging();
                }
            } else {
                this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
            }
            return;
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private boolean checkFullCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
        while (lsn != null) {
            OWALRecord walRecord = this.writeAheadLog.read(lsn);
            if (walRecord instanceof OCheckpointEndRecord) {
                return true;
            }
            lsn = this.writeAheadLog.next(lsn);
        }
        return false;
    }

    private boolean checkFuzzyCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
        while (lsn != null) {
            OWALRecord walRecord = this.writeAheadLog.read(lsn);
            if (walRecord instanceof OFuzzyCheckpointEndRecord) {
                return true;
            }
            lsn = this.writeAheadLog.next(lsn);
        }
        return false;
    }

    private void restoreFromCheckPoint(OAbstractCheckPointStartRecord checkPointRecord) throws IOException {
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            this.restoreFromFuzzyCheckPoint((OFuzzyCheckpointStartRecord)checkPointRecord);
            return;
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            this.restoreFromFullCheckPoint((OFullCheckpointStartRecord)checkPointRecord);
            return;
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private void restoreFromFullCheckPoint(OFullCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from full checkpoint is started. Restore is performed from LSN %s", new Object[]{checkPointRecord.getLsn()});
        OLogSequenceNumber lsn = this.writeAheadLog.next(checkPointRecord.getLsn());
        this.restoreFrom(lsn);
    }

    private void restoreFromFuzzyCheckPoint(OFuzzyCheckpointStartRecord checkPointRecord) throws IOException {
        OLogSequenceNumber startLSN;
        OLogManager.instance().info((Object)this, "Data restore procedure from fuzzy checkpoint is started.", new Object[0]);
        OLogSequenceNumber dirtyPagesLSN = this.writeAheadLog.next(checkPointRecord.getLsn());
        ODirtyPagesRecord dirtyPagesRecord = (ODirtyPagesRecord)this.writeAheadLog.read(dirtyPagesLSN);
        Set<ODirtyPage> dirtyPages = dirtyPagesRecord.getDirtyPages();
        if (dirtyPages.isEmpty()) {
            startLSN = dirtyPagesLSN;
        } else {
            ODirtyPage[] pages = dirtyPages.toArray(new ODirtyPage[dirtyPages.size()]);
            Arrays.sort(pages, new Comparator<ODirtyPage>(){

                @Override
                public int compare(ODirtyPage pageOne, ODirtyPage pageTwo) {
                    return pageOne.getLsn().compareTo(pageTwo.getLsn());
                }
            });
            startLSN = pages[0].getLsn();
        }
        if (startLSN.compareTo(this.writeAheadLog.begin()) < 0) {
            startLSN = this.writeAheadLog.begin();
        }
        this.restoreFrom(startLSN);
    }

    private void restoreFromBegging() throws IOException {
        OLogManager.instance().info((Object)this, "Date restore procedure is started.", new Object[0]);
        OLogSequenceNumber lsn = this.writeAheadLog.begin();
        this.restoreFrom(lsn);
    }

    private void restoreFrom(OLogSequenceNumber lsn) throws IOException {
        this.wereDataRestoredAfterOpen = true;
        HashMap<OOperationUnitId, List<OWALRecord>> operationUnits = new HashMap<OOperationUnitId, List<OWALRecord>>();
        while (lsn != null) {
            OWALRecord walRecord = this.writeAheadLog.read(lsn);
            if (walRecord instanceof OAtomicUnitStartRecord) {
                ArrayList<OWALRecord> operationList = new ArrayList<OWALRecord>();
                operationUnits.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), operationList);
                operationList.add(walRecord);
            } else if (walRecord instanceof OOperationUnitRecord) {
                OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)walRecord;
                OOperationUnitId unitId = operationUnitRecord.getOperationUnitId();
                List records = (List)operationUnits.get(unitId);
                assert (records != null);
                records.add(walRecord);
                if (operationUnitRecord instanceof OAtomicUnitEndRecord) {
                    OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                    if (atomicUnitEndRecord.isRollback()) {
                        this.undoOperation(records);
                    } else {
                        this.redoOperation(records);
                    }
                    operationUnits.remove(unitId);
                }
            } else {
                OLogManager.instance().warn((Object)this, "Record %s will be skipped during data restore.", new Object[]{walRecord});
            }
            lsn = this.writeAheadLog.next(lsn);
        }
        this.rollbackAllUnfinishedWALOperations(operationUnits);
    }

    private void redoOperation(List<OWALRecord> records) throws IOException {
        int i = 0;
        while (i < records.size()) {
            OWALRecord record = records.get(i);
            if (!this.checkFirstAtomicUnitRecord(i, record) && !this.checkLastAtomicUnitRecord(i, record, records.size())) {
                if (record instanceof OClusterAwareWALRecord) {
                    int clusterId = ((OClusterAwareWALRecord)((Object)record)).getClusterId();
                    OLocalPaginatedCluster paginatedCluster = this.getClusterById(clusterId);
                    if (paginatedCluster == null) {
                        assert (false);
                        OLogManager.instance().error((Object)this, "Cluster with id %d is absent so record %s will be skipped.", new Object[]{clusterId, record});
                    } else {
                        paginatedCluster.restoreRecord(record);
                    }
                } else {
                    OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{record.getClass()});
                    assert (false) : "Invalid WAL record type was passed " + record.getClass().getName();
                }
            }
            ++i;
        }
    }

    private boolean checkFirstAtomicUnitRecord(int index, OWALRecord record) {
        boolean isAtomicUnitStartRecord = record instanceof OAtomicUnitStartRecord;
        if (isAtomicUnitStartRecord && index != 0) {
            OLogManager.instance().error((Object)this, "Record %s should be the first record in WAL record list.", new Object[]{OAtomicUnitStartRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitStartRecord.class.getName() + " should be the first record in WAL record list.";
        }
        if (index == 0 && !isAtomicUnitStartRecord) {
            OLogManager.instance().error((Object)this, "Record %s should be the first record in WAL record list.", new Object[]{OAtomicUnitStartRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitStartRecord.class.getName() + " should be the first record in WAL record list.";
        }
        return isAtomicUnitStartRecord;
    }

    private boolean checkLastAtomicUnitRecord(int index, OWALRecord record, int size) {
        boolean isAtomicUnitEndRecord = record instanceof OAtomicUnitEndRecord;
        if (isAtomicUnitEndRecord && index != size - 1) {
            OLogManager.instance().error((Object)this, "Record %s should be the last record in WAL record list.", new Object[]{OAtomicUnitEndRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitEndRecord.class.getName() + " should be the last record in WAL record list.";
        }
        if (index == size - 1 && !isAtomicUnitEndRecord) {
            OLogManager.instance().error((Object)this, "Record %s should be the last record in WAL record list.", new Object[]{OAtomicUnitEndRecord.class.getName()});
            assert (false) : "Record " + OAtomicUnitEndRecord.class.getName() + " should be the last record in WAL record list.";
        }
        return isAtomicUnitEndRecord;
    }

    private void rollbackAllUnfinishedWALOperations(Map<OOperationUnitId, List<OWALRecord>> operationUnits) throws IOException {
        for (List<OWALRecord> operationUnit : operationUnits.values()) {
            OAtomicUnitStartRecord atomicUnitStartRecord;
            if (operationUnit.isEmpty() || !(atomicUnitStartRecord = (OAtomicUnitStartRecord)operationUnit.get(0)).isRollbackSupported()) continue;
            OAtomicUnitEndRecord atomicUnitEndRecord = new OAtomicUnitEndRecord(atomicUnitStartRecord.getOperationUnitId(), true);
            this.writeAheadLog.log(atomicUnitEndRecord);
            operationUnit.add(atomicUnitEndRecord);
            this.undoOperation(operationUnit);
        }
    }

    private void undoOperation(List<OWALRecord> operationUnit) throws IOException {
        int i = operationUnit.size() - 1;
        while (i >= 0) {
            OWALRecord record = operationUnit.get(i);
            if (this.checkFirstAtomicUnitRecord(i, record)) {
                assert (((OAtomicUnitStartRecord)record).isRollbackSupported());
            } else if (this.checkLastAtomicUnitRecord(i, record, operationUnit.size())) {
                assert (((OAtomicUnitEndRecord)record).isRollback());
            } else if (record instanceof OClusterAwareWALRecord) {
                OClusterAwareWALRecord clusterAwareWALRecord = (OClusterAwareWALRecord)((Object)record);
                int clusterId = clusterAwareWALRecord.getClusterId();
                OLocalPaginatedCluster localPaginatedCluster = this.getClusterById(clusterId);
                if (localPaginatedCluster == null) {
                    assert (false);
                    OLogManager.instance().error((Object)this, "Cluster with id %d is absent so record %s will be skipped.", new Object[]{clusterId, record});
                } else {
                    localPaginatedCluster.revertRecord(record);
                }
            } else {
                OLogManager.instance().error((Object)this, "Invalid WAL record type was passed %s. Given record will be skipped.", new Object[]{record.getClass()});
                assert (false) : "Invalid WAL record type was passed " + record.getClass().getName();
            }
            --i;
        }
    }

    public boolean wereDataRestoredAfterOpen() {
        return this.wereDataRestoredAfterOpen;
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                if (this.status != OStorage.STATUS.CLOSED) {
                    throw new OStorageException("Cannot create new storage '" + this.name + "' because it is not closed");
                }
                this.addUser();
                File storageFolder = new File(this.storagePath);
                if (!storageFolder.exists()) {
                    storageFolder.mkdirs();
                }
                if (this.exists()) {
                    throw new OStorageException("Cannot create new storage '" + this.name + "' because it already exists");
                }
                this.initWal();
                this.status = OStorage.STATUS.OPEN;
                this.doAddCluster("internal", null, false, null);
                this.doAddCluster("index", null, false, null);
                this.doAddCluster("manindex", null, false, null);
                this.defaultClusterId = this.doAddCluster("default", null, false, null);
                this.configuration.create();
                if (OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE.getValueAsBoolean()) {
                    this.makeFullCheckpoint();
                }
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage '" + this.name + "'", e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean exists() {
        return this.exists(this.storagePath);
    }

    private boolean exists(String path) {
        return new File(String.valueOf(path) + "/" + "internal" + ".pcl").exists();
    }

    @Override
    public void close(boolean force) {
        this.doClose(force, true);
    }

    private void doClose(boolean force, boolean flush) {
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (!this.checkForClose(force)) {
                return;
            }
            try {
                this.status = OStorage.STATUS.CLOSING;
                this.makeFullCheckpoint();
                if (this.writeAheadLog != null) {
                    this.fuzzyCheckpointExecutor.shutdown();
                    if (!this.fuzzyCheckpointExecutor.awaitTermination(OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.SECONDS)) {
                        throw new OStorageException("Can not terminate fuzzy checkpoint task");
                    }
                    this.checkpointExecutor.shutdown();
                    if (!this.checkpointExecutor.awaitTermination(OGlobalConfiguration.WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.SECONDS)) {
                        throw new OStorageException("Can not terminate full checkpoint task");
                    }
                }
                OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
                int n = this.clusters.length;
                int n2 = 0;
                while (n2 < n) {
                    OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
                    if (cluster != null) {
                        cluster.close(flush);
                    }
                    ++n2;
                }
                this.clusters = new OLocalPaginatedCluster[0];
                this.clusterMap.clear();
                if (this.configuration != null) {
                    this.configuration.close();
                }
                this.level2Cache.shutdown();
                super.close(force);
                if (this.writeAheadLog != null) {
                    this.writeAheadLog.close();
                }
                this.diskCache.close();
                Orient.instance().unregisterStorage(this);
                this.status = OStorage.STATUS.CLOSED;
            }
            catch (InterruptedException ie) {
                OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)ie, OStorageException.class, new Object[0]);
                Thread.interrupted();
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)e, OStorageException.class, new Object[0]);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a local database", timer, "db.*.close");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void delete() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean check(boolean verbose, OCommandOutputListener listener) {
        this.lock.acquireExclusiveLock();
        try {
            long start = System.currentTimeMillis();
            OPageDataVerificationError[] pageErrors = this.diskCache.checkStoredPages(verbose ? listener : null);
            listener.onMessage("Check of storage completed in " + (System.currentTimeMillis() - start) + "ms. " + (pageErrors.length > 0 ? String.valueOf(pageErrors.length) + " with errors." : " without errors."));
            boolean bl = pageErrors.length == 0;
            return bl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public ODataLocal getDataSegmentById(int dataSegmentId) {
        OLogManager.instance().error((Object)this, "getDataSegmentById: Local paginated storage does not support data segments. null will be returned for data segment %d.", new Object[]{dataSegmentId});
        return null;
    }

    @Override
    public int getDataSegmentIdByName(String dataSegmentName) {
        OLogManager.instance().error((Object)this, "getDataSegmentIdByName: Local paginated storage does not support data segments. -1 will be returned for data segment %s.", new Object[]{dataSegmentName});
        return -1;
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    public void enableFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.makeFullCheckPointAfterClusterCreate = true;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void disableFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            this.makeFullCheckPointAfterClusterCreate = false;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public boolean isMakeFullCheckPointAfterClusterCreate() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            boolean bl = this.makeFullCheckPointAfterClusterCreate;
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int addDataSegment(String segmentName, String directory) {
        OLogManager.instance().error((Object)this, "addDataSegment: Local paginated storage does not support data segments, segment %s will not be added in directory %s.", new Object[]{segmentName, directory});
        return -1;
    }

    @Override
    public int addCluster(String clusterType, String clusterName, String location, String dataSegmentName, boolean forceListBased, Object ... parameters) {
        this.checkOpeness();
        this.lock.acquireExclusiveLock();
        try {
            int n = this.doAddCluster(clusterName, location, true, parameters);
            return n;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error in creation of new cluster '" + clusterName + "' of type: " + clusterType, e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return -1;
    }

    private int doAddCluster(String clusterName, String location, boolean fullCheckPoint, Object[] parameters) throws IOException {
        int clusterPos = this.clusters.length;
        int i = 0;
        while (i < this.clusters.length) {
            if (this.clusters[i] == null) {
                clusterPos = i;
                break;
            }
            ++i;
        }
        return this.addClusterInternal(clusterName, clusterPos, location, fullCheckPoint, parameters);
    }

    @Override
    public int addCluster(String clusterType, String clusterName, int requestedId, String location, String dataSegmentName, boolean forceListBased, Object ... parameters) {
        this.lock.acquireExclusiveLock();
        try {
            if (requestedId < 0) {
                throw new OConfigurationException("Cluster id must be positive!");
            }
            if (requestedId < this.clusters.length && this.clusters[requestedId] != null) {
                throw new OConfigurationException("Requested cluster ID is occupied!");
            }
            int n = this.addClusterInternal(clusterName, requestedId, location, true, parameters);
            return n;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error in creation of new cluster '" + clusterName + "' of type: " + clusterType, e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return -1;
    }

    private int addClusterInternal(String clusterName, int clusterPos, String location, boolean fullCheckPoint, Object ... parameters) throws IOException {
        OLocalPaginatedCluster cluster;
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase();
            cluster = new OLocalPaginatedCluster();
            cluster.configure(this, clusterPos, clusterName, location, -1, parameters);
        } else {
            cluster = null;
        }
        int createdClusterId = this.registerCluster(cluster);
        if (cluster != null) {
            if (!cluster.exists()) {
                cluster.create(-1);
                if (this.makeFullCheckPointAfterClusterCreate && fullCheckPoint) {
                    this.makeFullCheckpoint();
                }
            } else {
                cluster.open();
            }
            this.configuration.update();
        }
        return createdClusterId;
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.lock.acquireExclusiveLock();
        try {
            if (iClusterId < 0 || iClusterId >= this.clusters.length) {
                throw new IllegalArgumentException("Cluster id '" + iClusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.length - 1) + ") in database '" + this.name + "'");
            }
            OLocalPaginatedCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                return false;
            }
            this.getLevel2Cache().freeCluster(iClusterId);
            if (iTruncate) {
                cluster.truncate();
            }
            cluster.delete();
            this.clusterMap.remove(cluster.getName());
            this.clusters[iClusterId] = null;
            this.configuration.dropCluster(iClusterId);
            this.makeFullCheckpoint();
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error while removing cluster '" + iClusterId + "'", e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    @Override
    public boolean dropDataSegment(String iName) {
        throw new UnsupportedOperationException("dropDataSegment");
    }

    @Override
    public long count(int iClusterId) {
        return this.count(iClusterId, false);
    }

    @Override
    public long count(int iClusterId, boolean countTombstones) {
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id " + iClusterId + " is invalid in database '" + this.name + "'");
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OLocalPaginatedCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                return 0L;
            }
            if (countTombstones) {
                long l = cluster.getEntries();
                return l;
            }
            long l = cluster.getEntries() - cluster.getTombstonesCount();
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OClusterPosition[] getClusterDataRange(int iClusterId) {
        if (iClusterId == -1) {
            return new OClusterPosition[]{OClusterPosition.INVALID_POSITION, OClusterPosition.INVALID_POSITION};
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            OClusterPosition[] oClusterPositionArray;
            if (this.clusters[iClusterId] != null) {
                OClusterPosition[] oClusterPositionArray2 = new OClusterPosition[2];
                oClusterPositionArray2[0] = this.clusters[iClusterId].getFirstPosition();
                oClusterPositionArray = oClusterPositionArray2;
                oClusterPositionArray2[1] = this.clusters[iClusterId].getLastPosition();
            } else {
                oClusterPositionArray = new OClusterPosition[]{};
            }
            OClusterPosition[] oClusterPositionArray3 = oClusterPositionArray;
            return oClusterPositionArray3;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not retrieve information about data range", ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        return this.count(iClusterIds, false);
    }

    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            int[] nArray = iClusterIds;
            int n = iClusterIds.length;
            int n2 = 0;
            while (n2 < n) {
                OLocalPaginatedCluster c;
                int iClusterId = nArray[n2];
                if (iClusterId >= this.clusters.length) {
                    throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
                }
                if (iClusterId > -1 && (c = this.clusters[iClusterId]) != null) {
                    tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
                }
                ++n2;
            }
            long l = tot;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType, int mode, ORecordCallback<OClusterPosition> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        block12: {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and can not be stored.");
            }
            this.checkOpeness();
            OLocalPaginatedCluster cluster = this.getClusterById(rid.getClusterId());
            this.lock.acquireSharedLock();
            try {
                OPhysicalPosition ppos;
                block11: {
                    this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                        if (ppos != null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                            throw throwable;
                        }
                        catch (IOException ioe) {
                            OLogManager.instance().error((Object)this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
                            break block12;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                    return null;
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                return oRecordMetadata;
            }
            finally {
                this.lock.releaseSharedLock();
            }
        }
        return null;
    }

    @Override
    public boolean isHashClustersAreUsed() {
        return OGlobalConfiguration.USE_LHPEPS_CLUSTER.getValueAsBoolean();
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback, boolean loadTombstones) {
        this.checkOpeness();
        return new OStorageOperationResult<ORawBuffer>(this.readRecord(this.getClusterById(iRid.clusterId), iRid, true, loadTombstones));
    }

    /*
     * Loose catch block
     */
    @Override
    protected ORawBuffer readRecord(OCluster clusterSegment, ORecordId rid, boolean atomicLock, boolean loadTombstones) {
        this.checkOpeness();
        if (!rid.isPersistent()) {
            throw new IllegalArgumentException("Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        OLocalPaginatedCluster localPaginatedCluster = (OLocalPaginatedCluster)clusterSegment;
        localPaginatedCluster.getExternalModificationLock().requestModificationLock();
        try {
            ORawBuffer oRawBuffer;
            block16: {
                if (atomicLock) {
                    this.lock.acquireSharedLock();
                }
                this.lockManager.acquireLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                oRawBuffer = localPaginatedCluster.readRecord(rid.clusterPosition);
                this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                if (!atomicLock) break block16;
                this.lock.releaseSharedLock();
            }
            return oRawBuffer;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), rid, OLockManager.LOCK.SHARED);
                            throw throwable;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on reading record " + rid + " (cluster: " + clusterSegment + ')', (Throwable)e, new Object[0]);
                            if (atomicLock) {
                                this.lock.releaseSharedLock();
                            }
                            localPaginatedCluster.getExternalModificationLock().releaseModificationLock();
                            return null;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (atomicLock) {
                            this.lock.releaseSharedLock();
                        }
                        throw throwable2;
                    }
                }
            }
        }
        finally {
            localPaginatedCluster.getExternalModificationLock().releaseModificationLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<ORecordVersion> updateRecord(ORecordId rid, byte[] content, ORecordVersion version, byte recordType, int mode, ORecordCallback<ORecordVersion> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId rid, ORecordVersion version, int mode, ORecordCallback<Boolean> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean updateReplica(int dataSegmentId, ORecordId rid, byte[] content, ORecordVersion recordVersion, byte recordType) throws IOException {
        throw new OStorageException("Support of hash based clusters is required.");
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.modificationLock.requestModificationLock();
            try {
                V v = super.callInLock(iCallable, iExclusiveLock);
                return v;
            }
            finally {
                this.modificationLock.releaseModificationLock();
            }
        }
        return super.callInLock(iCallable, iExclusiveLock);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <V> V callInRecordLock(Callable<V> callable, ORID rid, boolean exclusiveLock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            Set<String> set = this.clusterMap.keySet();
            return set;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkOpeness();
        if (iClusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        if (iClusterName.length() == 0) {
            throw new IllegalArgumentException("Cluster name is empty");
        }
        if (Character.isDigit(iClusterName.charAt(0))) {
            return Integer.parseInt(iClusterName);
        }
        this.lock.acquireSharedLock();
        try {
            OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
            if (segment != null) {
                int n = segment.getId();
                return n;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return -1;
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        this.checkOpeness();
        if (iClusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        this.lock.acquireSharedLock();
        try {
            OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
            if (segment != null) {
                String string = segment.getType();
                return string;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return null;
    }

    @Override
    public void commit(OTransaction clientTx) {
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                try {
                    if (this.writeAheadLog == null) {
                        throw new OStorageException("WAL mode is not active. Transactions are not supported in given mode");
                    }
                    if (this.transaction != null && this.transaction.getClientTx().getId() != clientTx.getId()) {
                        this.rollback(clientTx);
                    }
                    this.transaction = new OStorageTransaction(clientTx, OOperationUnitId.generateId());
                    OLogSequenceNumber startLSN = this.writeAheadLog.log(new OAtomicUnitStartRecord(true, this.transaction.getOperationUnitId()));
                    this.transaction.setStartLSN(startLSN);
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    while (clientTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (ORecordOperation oRecordOperation : clientTx.getCurrentRecordEntries()) {
                            tmpEntries.add(oRecordOperation);
                        }
                        clientTx.clearRecordEntries();
                        if (tmpEntries.isEmpty()) continue;
                        for (ORecordOperation oRecordOperation : tmpEntries) {
                            this.commitEntry(clientTx, oRecordOperation);
                        }
                    }
                    this.writeAheadLog.log(new OAtomicUnitEndRecord(this.transaction.getOperationUnitId(), false));
                    OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), true);
                }
                catch (Exception e) {
                    OLogManager.instance().info((Object)this, "Error during transaction commit, transaction will be rolled back (tx-id=%d)", (Throwable)e, new Object[]{clientTx.getId()});
                    this.rollback(clientTx);
                    if (e instanceof OException) {
                        throw (OException)((Object)e);
                    }
                    throw new OStorageException("Error during transaction commit.", e);
                }
            }
            finally {
                this.transaction = null;
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    private void commitEntry(OTransaction clientTx, ORecordOperation txEntry) throws IOException {
        OLocalPaginatedCluster cluster;
        if (txEntry.type != 2 && !txEntry.getRecord().isDirty()) {
            return;
        }
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        if (rid.clusterId == -1 && txEntry.getRecord() instanceof ODocument && ((ODocument)txEntry.getRecord()).getSchemaClass() != null) {
            rid.clusterId = ((ODocument)txEntry.getRecord()).getSchemaClass().getDefaultClusterId();
        }
        if ((cluster = this.getClusterById(rid.clusterId)).getName().equals("index") || cluster.getName().equals("manindex")) {
            return;
        }
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.type) {
            case 0: {
                break;
            }
            case 3: {
                ORecordId oldRID;
                byte[] stream = txEntry.getRecord().toStream();
                if (stream == null) {
                    OLogManager.instance().warn((Object)this, "Null serialization on committing new record %s in transaction", new Object[]{rid});
                    break;
                }
                ORecordId oRecordId = oldRID = rid.isNew() ? rid.copy() : rid;
                if (rid.isNew()) {
                    txEntry.getRecord().onBeforeIdentityChanged(rid);
                    rid.clusterId = cluster.getId();
                }
                if (rid.isNew()) {
                    OPhysicalPosition ppos = this.createRecord(-1, rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), -1, null).getResult();
                    rid.clusterPosition = ppos.clusterPosition;
                    txEntry.getRecord().getRecordVersion().copyFrom(ppos.recordVersion);
                    txEntry.getRecord().onAfterIdentityChanged(txEntry.getRecord());
                    clientTx.updateIdentityAfterCommit(oldRID, rid);
                    break;
                }
                txEntry.getRecord().getRecordVersion().copyFrom(this.updateRecord(rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), -1, null).getResult());
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                if (stream == null) {
                    OLogManager.instance().warn((Object)this, "Null serialization on committing updated record %s in transaction", new Object[]{rid});
                    break;
                }
                txEntry.getRecord().getRecordVersion().copyFrom(this.updateRecord(rid, stream, txEntry.getRecord().getRecordVersion(), txEntry.getRecord().getRecordType(), -1, null).getResult());
                break;
            }
            case 2: {
                this.deleteRecord(rid, txEntry.getRecord().getRecordVersion(), -1, null);
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    @Override
    public void rollback(OTransaction clientTx) {
        this.checkOpeness();
        this.modificationLock.requestModificationLock();
        try {
            this.lock.acquireExclusiveLock();
            try {
                try {
                    if (this.writeAheadLog == null) {
                        throw new OStorageException("WAL mode is not active. Transactions are not supported in given mode");
                    }
                    if (this.transaction == null) {
                        throw new OStorageException("There is no active transaction, rollback can not be performed.");
                    }
                    if (this.transaction.getClientTx().getId() != clientTx.getId()) {
                        throw new OStorageException("Passed in and active transaction are different transactions. Passed in transaction can not be rolled back.");
                    }
                    this.writeAheadLog.log(new OAtomicUnitEndRecord(this.transaction.getOperationUnitId(), true));
                    List<OWALRecord> operationUnit = this.readOperationUnit(this.transaction.getStartLSN(), this.transaction.getOperationUnitId());
                    this.undoOperation(operationUnit);
                    OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), true);
                    this.transaction = null;
                }
                catch (IOException e) {
                    throw new OStorageException("Error during transaction rollback.", e);
                }
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    private List<OWALRecord> readOperationUnit(OLogSequenceNumber startLSN, OOperationUnitId unitId) throws IOException {
        OLogSequenceNumber beginSequence = this.writeAheadLog.begin();
        if (startLSN == null) {
            startLSN = beginSequence;
        }
        if (startLSN.compareTo(beginSequence) < 0) {
            startLSN = beginSequence;
        }
        ArrayList<OWALRecord> operationUnit = new ArrayList<OWALRecord>();
        OLogSequenceNumber lsn = startLSN;
        while (lsn != null) {
            OWALRecord record = this.writeAheadLog.read(lsn);
            if (!(record instanceof OOperationUnitRecord)) {
                lsn = this.writeAheadLog.next(lsn);
                continue;
            }
            OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)record;
            if (operationUnitRecord.getOperationUnitId().equals(unitId)) {
                operationUnit.add(record);
                if (record instanceof OAtomicUnitEndRecord) break;
            }
            lsn = this.writeAheadLog.next(lsn);
        }
        return operationUnit;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ppos.recordVersion.isTombstone();
    }

    @Override
    public void synch() {
        this.checkOpeness();
        long timer = Orient.instance().getProfiler().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (this.writeAheadLog != null) {
                this.makeFullCheckpoint();
                return;
            }
            try {
                OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
                int n = this.clusters.length;
                int n2 = 0;
                while (n2 < n) {
                    OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
                    if (cluster != null) {
                        cluster.synch();
                    }
                    ++n2;
                }
                if (this.configuration != null) {
                    this.configuration.synch();
                }
            }
            catch (IOException e) {
                throw new OStorageException("Error on synch storage '" + this.name + "'", e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a local database", timer, "db.*.synch");
        }
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.defaultClusterId = defaultClusterId;
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            if (iClusterId >= this.clusters.length) {
                return null;
            }
            String string = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getName() : null;
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public OLocalPaginatedCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            OLocalPaginatedCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
            }
            OLocalPaginatedCluster oLocalPaginatedCluster = cluster;
            return oLocalPaginatedCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public OWriteAheadLog getWALInstance() {
        return this.writeAheadLog;
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.length - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterName + " does not exist in database '" + this.name + "'");
            }
            OCluster oCluster = cluster;
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getURL() {
        return "plocal:" + this.url;
    }

    @Override
    public long getSize() {
        this.lock.acquireSharedLock();
        try {
            long size = 0L;
            OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OLocalPaginatedCluster c = oLocalPaginatedClusterArray[n2];
                if (c != null) {
                    size += c.getRecordsSize();
                }
                ++n2;
            }
            long l = size;
            return l;
        }
        catch (IOException ioe) {
            throw new OStorageException("Can not calculate records size");
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getStoragePath() {
        return this.storagePath;
    }

    @Override
    protected OPhysicalPosition updateRecord(OCluster cluster, ORecordId rid, byte[] recordContent, ORecordVersion recordVersion, byte recordType) {
        throw new UnsupportedOperationException("updateRecord");
    }

    @Override
    protected OPhysicalPosition createRecord(ODataLocal dataSegment, OCluster cluster, byte[] recordContent, byte recordType, ORecordId rid, ORecordVersion recordVersion) {
        throw new UnsupportedOperationException("createRecord");
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        this.lock.acquireSharedLock();
        try {
            OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OLocalPaginatedCluster c = oLocalPaginatedClusterArray[n2];
                if (c != null) {
                    result.add(c);
                }
                ++n2;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return result;
    }

    public void renameCluster(String iOldName, String iNewName) {
        this.clusterMap.put(iNewName, this.clusterMap.remove(iOldName));
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, ORecordVersion recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.deleteRecord(recordId, recordVersion, iMode, callback).getResult();
    }

    @Override
    public void freeze(boolean throwException) {
        this.modificationLock.prohibitModifications(throwException);
        this.synch();
        try {
            OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
                if (cluster != null) {
                    cluster.setSoftlyClosed(true);
                }
                ++n2;
            }
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(true);
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on freeze storage '" + this.name + "'", e);
        }
    }

    @Override
    public void release() {
        try {
            OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
            int n = this.clusters.length;
            int n2 = 0;
            while (n2 < n) {
                OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
                if (cluster != null) {
                    cluster.setSoftlyClosed(false);
                }
                ++n2;
            }
            if (this.configuration != null) {
                this.configuration.setSoftlyClosed(false);
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on release storage '" + this.name + "'", e);
        }
        this.modificationLock.allowModifications();
    }

    @Override
    public boolean wasClusterSoftlyClosed(String clusterName) {
        this.lock.acquireSharedLock();
        try {
            OLocalPaginatedCluster indexCluster = this.clusterMap.get(clusterName);
            boolean bl = indexCluster.wasSoftlyClosed();
            return bl;
        }
        catch (IOException ioe) {
            throw new OStorageException("Error during index consistency check", ioe);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public void makeFuzzyCheckpoint() {
        if (this.writeAheadLog == null) {
            return;
        }
        try {
            this.lock.acquireExclusiveLock();
            try {
                this.writeAheadLog.flush();
                this.writeAheadLog.logFuzzyCheckPointStart();
                this.diskCache.forceSyncStoredChanges();
                this.diskCache.logDirtyPagesTable();
                OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
                int n = this.clusters.length;
                int n2 = 0;
                while (n2 < n) {
                    OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
                    if (cluster != null) {
                        cluster.flushClusterState();
                    }
                    ++n2;
                }
                this.writeAheadLog.logFuzzyCheckPointEnd();
                this.writeAheadLog.flush();
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
        }
        catch (IOException ioe) {
            throw new OStorageException("Error during fuzzy checkpoint creation for storage " + this.name, ioe);
        }
    }

    public void makeFullCheckpoint() {
        if (this.writeAheadLog == null) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.writeAheadLog.flush();
                if (this.configuration != null) {
                    this.configuration.synch();
                }
                this.writeAheadLog.logFullCheckpointStart();
                OLocalPaginatedCluster[] oLocalPaginatedClusterArray = this.clusters;
                int n = this.clusters.length;
                int n2 = 0;
                while (n2 < n) {
                    OLocalPaginatedCluster cluster = oLocalPaginatedClusterArray[n2];
                    if (cluster != null) {
                        cluster.synch();
                    }
                    ++n2;
                }
                this.writeAheadLog.logFullCheckpointEnd();
                this.writeAheadLog.flush();
            }
            catch (IOException ioe) {
                throw new OStorageException("Error during checkpoint creation for storage " + this.name, ioe);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void scheduleFullCheckpoint() {
        this.checkpointExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    OLocalPaginatedStorage.this.makeFullCheckpoint();
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error during background checkpoint creation for storage " + OLocalPaginatedStorage.this.name, t, new Object[0]);
                }
            }
        });
    }

    @Override
    public String getType() {
        return "plocal";
    }

    private int createClusterFromConfig(OStorageClusterConfiguration iConfig) throws IOException {
        OLocalPaginatedCluster cluster = this.clusterMap.get(iConfig.getName());
        if (cluster != null) {
            cluster.configure(this, iConfig);
            return -1;
        }
        cluster = new OLocalPaginatedCluster();
        cluster.configure(this, iConfig);
        return this.registerCluster(cluster);
    }

    private int registerCluster(OLocalPaginatedCluster iCluster) throws IOException {
        int id;
        if (iCluster != null) {
            if (this.clusterMap.containsKey(iCluster.getName())) {
                throw new OConfigurationException("Cannot add segment '" + iCluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(iCluster.getName(), iCluster);
            id = iCluster.getId();
        } else {
            id = this.clusters.length;
        }
        if (id >= this.clusters.length) {
            this.clusters = (OLocalPaginatedCluster[])OArrays.copyOf((Object[])this.clusters, (int)(id + 1));
        }
        this.clusters[id] = iCluster;
        return id;
    }

    private void addDefaultClusters() throws IOException {
        String storageCompression = OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getValueAsString();
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.length, "internal", null, true, 20.0f, 4.0f, storageCompression));
        this.configuration.load();
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.length, "index", null, false, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, storageCompression));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.length, "manindex", null, false, 1.0f, 1.0f, storageCompression));
        this.defaultClusterId = this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.length, "default", null, true, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, OStoragePaginatedClusterConfiguration.DEFAULT_GROW_FACTOR, storageCompression));
    }

    @Override
    public ODiskCache getDiskCache() {
        return this.diskCache;
    }

    public void freeze(boolean throwException, int clusterId) {
        OLocalPaginatedCluster cluster = this.getClusterById(clusterId);
        String name = cluster.getName();
        if ("index".equals(name) || "manindex".equals(name)) {
            throw new IllegalArgumentException("It is impossible to freeze and release index or manual index cluster!");
        }
        cluster.getExternalModificationLock().prohibitModifications(throwException);
        try {
            cluster.synch();
            cluster.setSoftlyClosed(true);
        }
        catch (IOException e) {
            throw new OStorageException("Error on synch cluster '" + name + "'", e);
        }
    }

    public void release(int clusterId) {
        OLocalPaginatedCluster cluster = this.getClusterById(clusterId);
        String name = cluster.getName();
        if ("index".equals(name) || "manindex".equals(name)) {
            throw new IllegalArgumentException("It is impossible to freeze and release index or manualindex cluster!");
        }
        try {
            cluster.setSoftlyClosed(false);
        }
        catch (IOException e) {
            throw new OStorageException("Error on unfreeze storage '" + name + "'", e);
        }
        cluster.getExternalModificationLock().allowModifications();
    }
}

