/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OClusterAwareWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;

public class OClusterStateRecord
extends OOperationUnitRecord
implements OClusterAwareWALRecord {
    private OLogSequenceNumber lsn;
    private long size;
    private long recordsSize;
    private long prevSize;
    private long prevRecordsSize;
    private int clusterId;

    public OClusterStateRecord() {
    }

    public OClusterStateRecord(long size, long recordsSize, int clusterId, long prevSize, long prevRecordsSize, OOperationUnitId operationUnitId) {
        super(operationUnitId);
        this.size = size;
        this.recordsSize = recordsSize;
        this.clusterId = clusterId;
        this.prevSize = prevSize;
        this.prevRecordsSize = prevRecordsSize;
    }

    public long getSize() {
        return this.size;
    }

    public long getRecordsSize() {
        return this.recordsSize;
    }

    @Override
    public int getClusterId() {
        return this.clusterId;
    }

    public long getPrevSize() {
        return this.prevSize;
    }

    public long getPrevRecordsSize() {
        return this.prevRecordsSize;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.prevSize), content, offset);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.prevRecordsSize), content, offset += 8);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.size), content, offset += 8);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(this.recordsSize), content, offset += 8);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.clusterId), content, offset += 8);
        return offset += 4;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.prevSize = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        this.prevRecordsSize = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.size = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.recordsSize = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        this.clusterId = OIntegerSerializer.INSTANCE.deserializeNative(content, offset += 8);
        return offset += 4;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 32 + 4;
    }

    @Override
    public boolean isUpdateMasterRecord() {
        return false;
    }

    @Override
    public OLogSequenceNumber getLsn() {
        return this.lsn;
    }

    @Override
    public void setLsn(OLogSequenceNumber lsn) {
        this.lsn = lsn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OClusterStateRecord that = (OClusterStateRecord)o;
        if (this.clusterId != that.clusterId) {
            return false;
        }
        if (this.prevRecordsSize != that.prevRecordsSize) {
            return false;
        }
        if (this.prevSize != that.prevSize) {
            return false;
        }
        if (this.recordsSize != that.recordsSize) {
            return false;
        }
        return this.size == that.size;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.recordsSize ^ this.recordsSize >>> 32);
        result = 31 * result + (int)(this.prevSize ^ this.prevSize >>> 32);
        result = 31 * result + (int)(this.prevRecordsSize ^ this.prevRecordsSize >>> 32);
        result = 31 * result + this.clusterId;
        return result;
    }
}

