/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord.OPageDiff;
import java.util.Arrays;

public class OBinaryPageDiff
extends OPageDiff<byte[]> {
    public OBinaryPageDiff() {
    }

    public OBinaryPageDiff(byte[] newValue, int pageOffset) {
        super(newValue, pageOffset);
    }

    @Override
    public void restorePageData(long pagePointer) {
        this.directMemory.set(pagePointer + (long)this.pageOffset, (byte[])this.newValue, 0, ((byte[])this.newValue).length);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + ((byte[])this.newValue).length;
    }

    @Override
    public int toStream(byte[] stream, int offset) {
        offset = super.toStream(stream, offset);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(((byte[])this.newValue).length), stream, offset);
        System.arraycopy(this.newValue, 0, stream, offset += 4, ((byte[])this.newValue).length);
        return offset += ((byte[])this.newValue).length;
    }

    @Override
    public int fromStream(byte[] stream, int offset) {
        offset = super.fromStream(stream, offset);
        int len = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset);
        this.newValue = new byte[len];
        System.arraycopy(stream, offset += 4, this.newValue, 0, len);
        return offset += len;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBinaryPageDiff diff = (OBinaryPageDiff)o;
        if (this.pageOffset != diff.pageOffset) {
            return false;
        }
        return Arrays.equals((byte[])this.newValue, (byte[])diff.newValue);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode((byte[])this.newValue);
        result = 31 * result + this.pageOffset;
        return result;
    }
}

