/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.updatePageRecord;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryFactory;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;

public abstract class OPageDiff<T> {
    protected final ODirectMemory directMemory = ODirectMemoryFactory.INSTANCE.directMemory();
    protected T newValue;
    protected int pageOffset;

    OPageDiff() {
    }

    public OPageDiff(T newValue, int pageOffset) {
        this.newValue = newValue;
        this.pageOffset = pageOffset;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public int serializedSize() {
        return 4;
    }

    public int toStream(byte[] stream, int offset) {
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(this.pageOffset), stream, offset);
        return offset += 4;
    }

    public int fromStream(byte[] stream, int offset) {
        this.pageOffset = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset);
        return offset += 4;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OPageDiff oPageDiff = (OPageDiff)o;
        if (this.pageOffset != oPageDiff.pageOffset) {
            return false;
        }
        return this.newValue.equals(oPageDiff.newValue);
    }

    public int hashCode() {
        int result = this.newValue.hashCode();
        result = 31 * result + this.pageOffset;
        return result;
    }

    public abstract void restorePageData(long var1);
}

