/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OClusterMemoryArrayList
extends OClusterMemory
implements OCluster {
    private List<OPhysicalPosition> entries = new ArrayList<OPhysicalPosition>();
    private List<OPhysicalPosition> removed = new ArrayList<OPhysicalPosition>();

    @Override
    protected void clear() {
        this.entries.clear();
        this.removed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.entries.size() - this.removed.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRecordsSize() {
        this.acquireSharedLock();
        try {
            long size = 0L;
            for (OPhysicalPosition e : this.entries) {
                if (e == null) continue;
                size += (long)e.recordSize;
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClusterPosition getFirstPosition() {
        this.acquireSharedLock();
        try {
            OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(this.entries.size() == 0 ? -1L : 0L);
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClusterPosition getLastPosition() {
        this.acquireSharedLock();
        try {
            OClusterPosition oClusterPosition = OClusterPositionFactory.INSTANCE.valueOf(this.entries.size() - 1);
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPhysicalPosition(OPhysicalPosition iPPosition) {
        this.acquireExclusiveLock();
        try {
            if (!this.removed.isEmpty()) {
                OPhysicalPosition recycledPosition = this.removed.remove(this.removed.size() - 1);
                iPPosition.clusterPosition = recycledPosition.clusterPosition;
                iPPosition.recordVersion = recycledPosition.recordVersion.copy();
                if (iPPosition.recordVersion.isTombstone()) {
                    iPPosition.recordVersion.revive();
                }
                iPPosition.recordVersion.increment();
                int positionToStore = recycledPosition.clusterPosition.intValue();
                this.entries.set(positionToStore, iPPosition);
            } else {
                iPPosition.clusterPosition = this.allocateRecord(iPPosition);
                iPPosition.recordVersion.reset();
                this.entries.add(iPPosition);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return true;
    }

    protected OClusterPosition allocateRecord(OPhysicalPosition iPPosition) {
        return OClusterPositionFactory.INSTANCE.valueOf(this.entries.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecordType(OClusterPosition iPosition, byte iRecordType) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)iPosition.intValue()).recordType = iRecordType;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVersion(OClusterPosition iPosition, ORecordVersion iVersion) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)iPosition.intValue()).recordVersion = iVersion;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void convertToTombstone(OClusterPosition iPosition) throws IOException {
        throw new UnsupportedOperationException("convertToTombstone");
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public boolean hasTombstonesSupport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) {
        this.acquireSharedLock();
        try {
            if (iPPosition.clusterPosition.intValue() < 0 || iPPosition.clusterPosition.compareTo(this.getLastPosition()) > 0) {
                OPhysicalPosition oPhysicalPosition = null;
                return oPhysicalPosition;
            }
            OPhysicalPosition oPhysicalPosition = this.entries.get(iPPosition.clusterPosition.intValue());
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhysicalPosition(OClusterPosition iPosition) {
        this.acquireExclusiveLock();
        try {
            int positionToRemove = iPosition.intValue();
            OPhysicalPosition ppos = this.entries.get(positionToRemove);
            this.removed.add(ppos);
            this.entries.set(positionToRemove, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDataSegmentPosition(OClusterPosition iPosition, int iDataSegmentId, long iDataPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get(iPosition.intValue());
            ppos.dataSegmentId = iDataSegmentId;
            ppos.dataSegmentPos = iDataPosition;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) {
        int positionInEntries;
        for (positionInEntries = position.clusterPosition.intValue() + 1; positionInEntries < this.entries.size() && (positionInEntries < 0 || this.entries.get(positionInEntries) == null); ++positionInEntries) {
        }
        if (positionInEntries >= 0 && positionInEntries < this.entries.size()) {
            return new OPhysicalPosition[]{this.entries.get(positionInEntries)};
        }
        return new OPhysicalPosition[0];
    }

    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        int positionInEntries;
        for (positionInEntries = position.clusterPosition.intValue(); positionInEntries < this.entries.size() && (positionInEntries < 0 || this.entries.get(positionInEntries) == null); ++positionInEntries) {
        }
        if (positionInEntries >= 0 && positionInEntries < this.entries.size()) {
            return new OPhysicalPosition[]{this.entries.get(positionInEntries)};
        }
        return new OPhysicalPosition[0];
    }

    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) {
        int positionInEntries;
        for (positionInEntries = position.clusterPosition.intValue() - 1; positionInEntries >= 0 && this.entries.get(positionInEntries) == null; --positionInEntries) {
        }
        if (positionInEntries >= 0 && positionInEntries < this.entries.size()) {
            return new OPhysicalPosition[]{this.entries.get(positionInEntries)};
        }
        return new OPhysicalPosition[0];
    }

    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        int positionInEntries;
        for (positionInEntries = position.clusterPosition.intValue(); positionInEntries >= 0 && this.entries.get(positionInEntries) == null; --positionInEntries) {
        }
        if (positionInEntries >= 0 && positionInEntries < this.entries.size()) {
            return new OPhysicalPosition[]{this.entries.get(positionInEntries)};
        }
        return new OPhysicalPosition[0];
    }

    public String toString() {
        return "OClusterMemory [name=" + this.getName() + ", id=" + this.getId() + ", entries=" + this.entries.size() + ", removed=" + this.removed + "]";
    }
}

