/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class OClusterMemoryHashing
extends OClusterMemory
implements OCluster {
    public static final String TYPE = "MEMORY";
    private NavigableMap<OClusterPosition, OPhysicalPosition> content = new TreeMap<OClusterPosition, OPhysicalPosition>();
    private long tombstonesCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPhysicalPosition(OPhysicalPosition physicalPosition) {
        this.acquireExclusiveLock();
        try {
            if (this.content.containsKey(physicalPosition.clusterPosition)) {
                boolean bl = false;
                return bl;
            }
            this.content.put(physicalPosition.clusterPosition, physicalPosition);
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition physicalPosition) {
        this.acquireSharedLock();
        try {
            if (physicalPosition.clusterPosition.isNew()) {
                OPhysicalPosition oPhysicalPosition = null;
                return oPhysicalPosition;
            }
            OPhysicalPosition oPhysicalPosition = (OPhysicalPosition)this.content.get(physicalPosition.clusterPosition);
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDataSegmentPosition(OClusterPosition clusterPosition, int dataSegmentId, long dataPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition physicalPosition = (OPhysicalPosition)this.content.get(clusterPosition);
            physicalPosition.dataSegmentId = dataSegmentId;
            physicalPosition.dataSegmentPos = dataPosition;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhysicalPosition(OClusterPosition clusterPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition physicalPosition = (OPhysicalPosition)this.content.remove(clusterPosition);
            if (physicalPosition != null && physicalPosition.recordVersion.isTombstone()) {
                --this.tombstonesCount;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecordType(OClusterPosition clusterPosition, byte recordType) {
        this.acquireExclusiveLock();
        try {
            ((OPhysicalPosition)this.content.get((Object)clusterPosition)).recordType = recordType;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateVersion(OClusterPosition clusterPosition, ORecordVersion version) {
        this.acquireExclusiveLock();
        try {
            ((OPhysicalPosition)this.content.get((Object)clusterPosition)).recordVersion = version;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertToTombstone(OClusterPosition clusterPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            ((OPhysicalPosition)this.content.get((Object)clusterPosition)).recordVersion.convertToTombstone();
            ++this.tombstonesCount;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public long getTombstonesCount() {
        return this.tombstonesCount;
    }

    @Override
    public boolean hasTombstonesSupport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.content.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClusterPosition getFirstPosition() {
        this.acquireSharedLock();
        try {
            if (this.content.isEmpty()) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition clusterPosition = (OClusterPosition)this.content.firstKey();
            if (clusterPosition == null) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition oClusterPosition = clusterPosition;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClusterPosition getLastPosition() {
        this.acquireSharedLock();
        try {
            if (this.content.isEmpty()) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition clusterPosition = (OClusterPosition)this.content.lastKey();
            if (clusterPosition == null) {
                OClusterPosition oClusterPosition = OClusterPosition.INVALID_POSITION;
                return oClusterPosition;
            }
            OClusterPosition oClusterPosition = clusterPosition;
            return oClusterPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getRecordsSize() {
        return 0L;
    }

    @Override
    public boolean isHashBased() {
        return true;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        return new OClusterEntryIterator(this);
    }

    @Override
    protected void clear() {
        this.content.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) {
        this.acquireSharedLock();
        try {
            Map.Entry<OClusterPosition, OPhysicalPosition> entry = this.content.higherEntry(position.clusterPosition);
            if (entry != null) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{entry.getValue()};
                return oPhysicalPositionArray;
            }
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            Map.Entry<OClusterPosition, OPhysicalPosition> entry = this.content.ceilingEntry(position.clusterPosition);
            if (entry != null) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{entry.getValue()};
                return oPhysicalPositionArray;
            }
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) {
        this.acquireSharedLock();
        try {
            Map.Entry<OClusterPosition, OPhysicalPosition> entry = this.content.lowerEntry(position.clusterPosition);
            if (entry != null) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{entry.getValue()};
                return oPhysicalPositionArray;
            }
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        this.acquireSharedLock();
        try {
            Map.Entry<OClusterPosition, OPhysicalPosition> entry = this.content.floorEntry(position.clusterPosition);
            if (entry != null) {
                OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{entry.getValue()};
                return oPhysicalPositionArray;
            }
            OPhysicalPosition[] oPhysicalPositionArray = new OPhysicalPosition[]{};
            return oPhysicalPositionArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }
}

