/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.OClusterPositionFactory;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private boolean usingLog;
    private static AtomicInteger txSerial = new AtomicInteger();
    private int autoRetries = OGlobalConfiguration.TX_AUTO_RETRY.getValueAsInteger();

    public OTransactionOptimistic(ODatabaseRecordTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
        this.usingLog = OGlobalConfiguration.TX_USE_LOG.getValueAsBoolean();
    }

    @Override
    public void begin() {
        this.status = OTransaction.TXSTATUS.BEGUN;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() {
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.COMMITTING;
        if (this.database.getStorage() instanceof OStorageProxy) {
            this.database.getStorage().commit(this);
            return;
        }
        involvedIndexes = this.getInvolvedIndexes();
        if (involvedIndexes != null) {
            Collections.sort(involvedIndexes);
        }
        retry = 0;
        while (retry < this.autoRetries) {
            try {
                lockedIndexes = null;
                try {
                    if (involvedIndexes != null) {
                        for (String indexName : involvedIndexes) {
                            var6_7 = (OIndexAbstract)this.database.getMetadata().getIndexManager().getIndexInternal(indexName);
                            if (lockedIndexes == null) {
                                lockedIndexes = new ArrayList<E>();
                            }
                            var6_7.acquireModificationLock();
                            lockedIndexes.add(var6_7);
                        }
                    }
                    indexes = this.database.getMetadata().getIndexManager().getIndexes();
                    indexesToLock = null;
                    if (indexes != null) {
                        indexesToLock = new ArrayList<OIndex<?>>(indexes);
                        Collections.sort(indexesToLock, new Comparator<OIndex<?>>(){

                            @Override
                            public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                                return indexOne.getName().compareTo(indexTwo.getName());
                            }
                        });
                    }
                    if (indexesToLock != null && !indexesToLock.isEmpty()) {
                        if (lockedIndexes == null) {
                            lockedIndexes = new ArrayList<OIndexAbstract>();
                        }
                        for (OIndex var6_9 : indexesToLock) {
                            for (Map.Entry<K, V> entry : this.recordEntries.entrySet()) {
                                record = ((ORecordOperation)entry.getValue()).record.getRecord();
                                if (!(record instanceof ODocument)) continue;
                                doc = (ODocument)record;
                                if (lockedIndexes.contains(var6_9.getInternal()) || doc.getSchemaClass() == null || var6_9.getDefinition() == null || !doc.getSchemaClass().isSubClassOf(var6_9.getDefinition().getClassName())) continue;
                                var6_9.getInternal().acquireModificationLock();
                                lockedIndexes.add((OIndexAbstract)var6_9.getInternal());
                            }
                        }
                        for (OIndexAbstract var6_11 : lockedIndexes) {
                            var6_11.acquireExclusiveLock();
                        }
                    }
                    this.database.getStorage().callInLock(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            OTransactionOptimistic.this.database.getStorage().commit(OTransactionOptimistic.this);
                            ODocument indexEntries = OTransactionOptimistic.this.getIndexChanges();
                            if (indexEntries != null) {
                                for (Map.Entry<String, Object> indexEntry : indexEntries) {
                                    OIndex<?> index = OTransactionOptimistic.this.database.getMetadata().getIndexManager().getIndexInternal(indexEntry.getKey());
                                    index.commit((ODocument)indexEntry.getValue());
                                }
                            }
                            return null;
                        }
                    }, true);
                }
                finally {
                    if (lockedIndexes == null) return;
                    ** for (index : lockedIndexes)
                }
lbl-1000:
                // 1 sources

                {
                    index.releaseExclusiveLock();
                    continue;
                }
lbl52:
                // 2 sources

                for (OIndexAbstract index : lockedIndexes) {
                    index.releaseModificationLock();
                }
                return;
            }
            catch (OTimeoutException e) {
                if (this.autoRetries == 0) {
                    OLogManager.instance().debug((Object)this, "Caught timeout exception during commit, but no automatic retry has been set", (Throwable)e, new Object[0]);
                    throw e;
                }
                OLogManager.instance().debug((Object)this, "Caught timeout exception during commit retrying %d/%d...", new Object[]{retry, this.autoRetries});
                ++retry;
            }
        }
    }

    @Override
    public void rollback() {
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        this.database.getLevel1Cache().clear();
        for (ORecordOperation v : this.recordEntries.values()) {
            v.getRecord().unload();
        }
        for (ORecordOperation v : this.allEntries.values()) {
            v.getRecord().unload();
        }
        this.indexEntries.clear();
    }

    @Override
    public ORecordInternal<?> loadRecord(ORID iRid, ORecordInternal<?> iRecord, String iFetchPlan, boolean ignoreCache, boolean loadTombstone) {
        this.checkTransaction();
        ORecordInternal<?> txRecord = this.getRecord(iRid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            return txRecord;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, iFetchPlan, ignoreCache, false);
    }

    @Override
    public void deleteRecord(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public void saveRecord(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        if (iRecord == null) {
            return;
        }
        this.addRecord(iRecord, iRecord.getIdentity().isValid() ? (byte)1 : 3, iClusterName);
    }

    protected void addRecord(ORecordInternal<?> iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        switch (iStatus) {
            case 3: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord);
                break;
            }
            case 0: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord);
                break;
            }
            case 1: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord);
                break;
            }
            case 2: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, iRecord);
            }
        }
        try {
            if (iRecord.getIdentity().isTemporary()) {
                this.temp2persistent.put(iRecord.getIdentity().copy(), iRecord);
            }
            if (this.status == OTransaction.TXSTATUS.COMMITTING && this.database.getStorage() instanceof OStorageEmbedded) {
                switch (iStatus) {
                    case 1: 
                    case 3: {
                        this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getRecordVersion(), iRecord.getRecordType(), false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, null, null);
                        break;
                    }
                    case 2: {
                        this.database.executeDeleteRecord(iRecord, iRecord.getRecordVersion(), false, false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false);
                    }
                }
                ORecordOperation txRecord = this.getRecordEntry(iRecord.getIdentity());
                if (txRecord == null) {
                    this.allEntries.put(iRecord.getIdentity(), new ORecordOperation(iRecord, iStatus));
                } else if (txRecord.record != iRecord) {
                    String clusterName = this.getDatabase().getClusterNameById(iRecord.getIdentity().getClusterId());
                    if (!clusterName.equals("manindex") && !clusterName.equals("index")) {
                        OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", new Object[]{iRecord.getIdentity()});
                    }
                    txRecord.record = iRecord;
                    txRecord.type = iStatus;
                }
            } else {
                ORecordId rid = (ORecordId)iRecord.getIdentity();
                if (!rid.isValid()) {
                    iRecord.onBeforeIdentityChanged(rid);
                    if (rid.clusterId == -1) {
                        rid.clusterId = iClusterName != null ? this.database.getClusterIdByName(iClusterName) : this.database.getDefaultClusterId();
                    }
                    rid.clusterPosition = OClusterPositionFactory.INSTANCE.valueOf(this.newObjectCounter--);
                    iRecord.onAfterIdentityChanged(iRecord);
                } else {
                    this.database.getLevel1Cache().freeRecord(rid);
                }
                ORecordOperation txEntry = this.getRecordEntry(rid);
                if (txEntry == null) {
                    if (!rid.isTemporary() || iStatus == 3) {
                        txEntry = new ORecordOperation(iRecord, iStatus);
                        this.recordEntries.put(rid, txEntry);
                    }
                } else {
                    txEntry.record = iRecord;
                    switch (txEntry.type) {
                        case 0: {
                            switch (iStatus) {
                                case 1: {
                                    txEntry.type = 1;
                                    break;
                                }
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (iStatus) {
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            switch (iStatus) {
                                case 2: {
                                    this.recordEntries.remove(rid);
                                }
                            }
                        }
                    }
                }
            }
            switch (iStatus) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, iRecord);
                    break;
                }
                case 0: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
                }
            }
        }
        catch (Throwable t) {
            switch (iStatus) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, iRecord);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, iRecord);
                }
            }
        }
    }

    @Override
    public boolean updateReplica(ORecordInternal<?> iRecord) {
        throw new UnsupportedOperationException("updateReplica()");
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.recordEntries.size() + ", idxEntries=" + this.indexEntries.size() + ']';
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }

    public int getAutoRetries() {
        return this.autoRetries;
    }

    public void setAutoRetries(int autoRetries) {
        this.autoRetries = autoRetries;
    }
}

