/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.concur.resource.OSharedResourceIterator;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OLazyRecordMultiIterator;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDEntryProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class OMVRBTreeRID
extends OMVRBTreePersistent<OIdentifiable, OIdentifiable>
implements OTrackedMultiValue<OIdentifiable, OIdentifiable>,
ORecordLazyMultiValue {
    private IdentityHashMap<ORecord<?>, Object> newEntries;
    private boolean autoConvertToRecord = true;
    private Set<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> changeListeners = Collections.newSetFromMap(new WeakHashMap());
    private static final Object NEWMAP_VALUE = new Object();
    private static final long serialVersionUID = 1L;
    private static OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);

    public OMVRBTreeRID(Collection<OIdentifiable> iInitValues) {
        this();
        this.putAll(iInitValues);
    }

    public OMVRBTreeRID() {
        this(new OMVRBTreeRIDProvider(null, ODatabaseRecordThreadLocal.INSTANCE.get().getClusterIdByName("ORIDs")));
    }

    public OMVRBTreeRID(ODocument iRecord) {
        this(new OMVRBTreeRIDProvider(((OIdentifiable)iRecord.field("root")).getIdentity()));
        this.load();
    }

    public OMVRBTreeRID(String iClusterName) {
        this(new OMVRBTreeRIDProvider(iClusterName));
    }

    public OMVRBTreeRID(OMVRBTreeProvider<OIdentifiable, OIdentifiable> iProvider) {
        super(iProvider);
        ((OMVRBTreeRIDProvider)this.dataProvider).setTree(this);
    }

    public OMVRBTreeRID(OMVRBTreeRID iSource) {
        super(new OMVRBTreeRIDProvider((OMVRBTreeRIDProvider)iSource.getProvider()));
        ((OMVRBTreeRIDProvider)this.dataProvider).setTree(this);
        if (iSource.getProvider().isDirty() && ((OMVRBTreeRIDProvider)iSource.getProvider()).isEmbeddedStreaming()) {
            this.putAll(iSource.keySet());
        } else {
            this.load();
        }
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> setOwner(ORecord<?> owner) {
        super.setOwner(owner);
        return this;
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> load() {
        lock.acquireExclusiveLock();
        try {
            this.newEntries = null;
            super.load();
            if (this.root != null) {
                this.setSize(((OMVRBTreeRIDEntryProvider)((OMVRBTreeEntryPersistent)this.root).getProvider()).getTreeSize());
            } else {
                this.setSize(0);
            }
            OMVRBTreeRID oMVRBTreeRID = this;
            return oMVRBTreeRID;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public OIdentifiable internalPut(OIdentifiable e, OIdentifiable v) {
        lock.acquireExclusiveLock();
        try {
            if (e == null) {
                return null;
            }
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            if (e.getIdentity().isNew()) {
                Object record = e.getRecord();
                if (record == null) {
                    throw new OTransactionException("Cannot insert item in mvrb-tree because the transactional item was not found.");
                }
                if (this.newEntries == null) {
                    this.newEntries = new IdentityHashMap();
                } else if (this.newEntries.containsKey(record)) {
                    Object t = record;
                    return t;
                }
                this.newEntries.put((ORecord<?>)record, NEWMAP_VALUE);
                this.setDirty();
                return null;
            }
            OIdentifiable oldValue = super.internalPut(e, null);
            if (oldValue != null) {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.ADD, e, v, oldValue));
            }
            OIdentifiable oIdentifiable = oldValue;
            return oIdentifiable;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public void putAll(Collection<OIdentifiable> coll) {
        long timer = PROFILER.startChrono();
        try {
            for (OIdentifiable rid : coll) {
                this.internalPut(rid, null);
            }
            this.commitChanges();
        }
        finally {
            PROFILER.stopChrono(PROFILER.getProcessMetric("mvrbtree.putAll"), "Put multiple values in a MVRBTreeRID", timer);
        }
    }

    @Override
    public OIdentifiable remove(Object o) {
        lock.acquireExclusiveLock();
        try {
            OIdentifiable removed;
            if (this.hasNewItems() && this.newEntries.containsKey(o)) {
                removed = (OIdentifiable)o;
                this.newEntries.remove(o);
                if (this.newEntries.size() == 0) {
                    this.newEntries = null;
                }
                this.setDirty();
            } else if (this.containsKey(o)) {
                removed = (OIdentifiable)super.remove(o);
                this.setDirty();
            } else {
                removed = null;
            }
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, (OIdentifiable)o, null, (OIdentifiable)o));
            OIdentifiable oIdentifiable = removed;
            return oIdentifiable;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public boolean removeAll(Collection<?> c) {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            if (this.hasNewItems()) {
                Set<ORecord<?>> v = this.newEntries.keySet();
                v.removeAll(c);
                if (this.newEntries.size() == 0) {
                    this.newEntries = null;
                }
            }
            boolean modified = false;
            for (Object o : c) {
                if (this.remove(o) == null) continue;
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public boolean retainAll(Collection<?> c) {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            if (this.hasNewItems()) {
                Set<ORecord<?>> v = this.newEntries.keySet();
                v.retainAll(c);
                if (this.newEntries.size() == 0) {
                    this.newEntries = null;
                }
            }
            boolean modified = false;
            Iterator<OIdentifiable> e = this.iterator();
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public void clear() {
        lock.acquireExclusiveLock();
        try {
            if (this.newEntries != null) {
                this.newEntries.clear();
                this.newEntries = null;
            }
            this.setDirty();
            HashMap origValues = this.changeListeners.isEmpty() ? null : new HashMap(this);
            super.clear();
            if (origValues != null) {
                for (Map.Entry item : origValues.entrySet()) {
                    this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, (OIdentifiable)item.getKey(), null, (OIdentifiable)item.getValue()));
                }
            } else {
                this.setDirty();
            }
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public boolean detach() {
        return this.saveAllNewEntries();
    }

    public int size() {
        lock.acquireExclusiveLock();
        try {
            int tot = this.getTreeSize();
            if (this.newEntries != null) {
                tot += this.newEntries.size();
            }
            int n = tot;
            return n;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public int getTreeSize() {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            int n = super.getTreeSize();
            return n;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public boolean isEmpty() {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            boolean empty = super.isEmpty();
            if (empty && this.newEntries != null) {
                empty = this.newEntries.isEmpty();
            }
            boolean bl = empty;
            return bl;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public boolean containsKey(Object o) {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            boolean found = super.containsKey(o);
            if (!found && this.hasNewItems()) {
                found = this.newEntries.containsKey(o);
            }
            boolean bl = found;
            return bl;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public Iterator<OIdentifiable> iterator() {
        lock.acquireExclusiveLock();
        try {
            OSharedResourceIterator oSharedResourceIterator = new OSharedResourceIterator(lock, this.iterator(this.autoConvertToRecord));
            return oSharedResourceIterator;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public OLazyIterator<OIdentifiable> iterator(boolean iAutoConvertToRecord) {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            if (this.hasNewItems()) {
                if (super.size() == 0) {
                    OLazyRecordIterator oLazyRecordIterator = new OLazyRecordIterator(new HashSet(this.newEntries.keySet()), iAutoConvertToRecord);
                    return oLazyRecordIterator;
                }
                OLazyRecordMultiIterator oLazyRecordMultiIterator = new OLazyRecordMultiIterator(null, new Object[]{this.keySet(), new HashSet(this.newEntries.keySet())}, iAutoConvertToRecord);
                return oLazyRecordMultiIterator;
            }
            OLazyRecordIterator oLazyRecordIterator = new OLazyRecordIterator(this.keySet().iterator(), iAutoConvertToRecord);
            return oLazyRecordIterator;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public Set<OIdentifiable> keySet() {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            Set set = super.keySet();
            return set;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public Collection<OIdentifiable> values() {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            Collection collection = super.values();
            return collection;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public Object[] toArray() {
        lock.acquireExclusiveLock();
        try {
            Object[] result = this.keySet().toArray();
            if (this.newEntries != null && !this.newEntries.isEmpty()) {
                int start = result.length;
                result = Arrays.copyOf(result, start + this.newEntries.size());
                for (ORecord<?> r : this.newEntries.keySet()) {
                    result[start++] = r;
                }
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public <T> T[] toArray(T[] a) {
        lock.acquireExclusiveLock();
        try {
            T[] result = this.keySet().toArray(a);
            if (this.newEntries != null && !this.newEntries.isEmpty()) {
                int start = result.length;
                result = Arrays.copyOf(result, start + this.newEntries.size());
                for (ORecord<?> r : this.newEntries.keySet()) {
                    result[start++] = r;
                }
            }
            T[] TArray = result;
            return TArray;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    protected void saveTreeNode() {
    }

    @Override
    public int commitChanges() {
        lock.acquireExclusiveLock();
        try {
            if (!((OMVRBTreeRIDProvider)this.getProvider()).isEmbeddedStreaming()) {
                this.saveAllNewEntries();
                int n = super.commitChanges();
                return n;
            }
            return 0;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> save() {
        return this;
    }

    protected void setSizeDelta(int iDelta) {
        lock.acquireExclusiveLock();
        try {
            this.setSize(this.getTreeSize() + iDelta);
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public void setDirtyOwner() {
        lock.acquireExclusiveLock();
        try {
            if (this.getOwner() != null) {
                this.getOwner().setDirty();
            }
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public void onAfterTxCommit() {
        lock.acquireExclusiveLock();
        try {
            Set<ORID> nodesInMemory = this.getAllNodesInCache();
            if (nodesInMemory.isEmpty()) {
                return;
            }
            HashSet<ORID> keys = new HashSet<ORID>(nodesInMemory);
            for (ORID rid : keys) {
                if (!rid.getClusterPosition().isTemporary()) continue;
                OMVRBTreeEntryPersistent entry = this.searchNodeInCache(rid);
                this.removeNodeFromCache(rid);
                this.addNodeInCache(entry);
            }
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public boolean saveAllNewEntries() {
        lock.acquireExclusiveLock();
        try {
            if (this.hasNewItems()) {
                HashSet temp = new HashSet(this.newEntries.keySet());
                for (ORecord oRecord : temp) {
                    if (oRecord.getIdentity().isNew()) {
                        oRecord.save();
                    }
                    if (oRecord.getIdentity().isNew()) continue;
                    if (this.newEntries != null) {
                        this.newEntries.remove(oRecord);
                        if (this.newEntries.size() == 0) {
                            this.newEntries = null;
                        }
                    }
                    this.internalPut(oRecord.getIdentity(), null);
                }
                if (!((OMVRBTreeRIDProvider)this.dataProvider).isEmbeddedStreaming()) {
                    super.commitChanges();
                }
                if (this.newEntries != null) {
                    return false;
                }
            }
            return true;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public boolean hasNewItems() {
        lock.acquireExclusiveLock();
        try {
            boolean bl = this.newEntries != null && !this.newEntries.isEmpty();
            return bl;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public String toString() {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
            StringBuilder buffer = new StringBuilder(super.toString());
            if (this.hasNewItems()) {
                buffer.append("{new items (");
                buffer.append(this.newEntries.size());
                buffer.append("): ");
                boolean first = true;
                for (ORecord<?> item : this.newEntries.keySet()) {
                    if (!first) {
                        buffer.append(", ");
                        first = false;
                    }
                    if (item == null) continue;
                    buffer.append(item.toString());
                }
                buffer.append("}");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    protected void setRoot(OMVRBTreeEntry<OIdentifiable, OIdentifiable> iRoot) {
        lock.acquireExclusiveLock();
        try {
            int size = 0;
            if (iRoot != null) {
                size = this.getTreeSize();
            }
            super.setRoot(iRoot);
            if (iRoot != null) {
                this.setSize(size);
            }
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    protected <RET> RET setDirty() {
        lock.acquireExclusiveLock();
        try {
            ((OMVRBTreeRIDProvider)this.getProvider()).setDirty();
            if (((OMVRBTreeRIDProvider)this.getProvider()).isEmbeddedStreaming()) {
                this.setDirtyOwner();
            } else if (ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
                this.save();
            }
            OMVRBTreeRID oMVRBTreeRID = this;
            return (RET)oMVRBTreeRID;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    public IdentityHashMap<ORecord<?>, Object> getTemporaryEntries() {
        return this.newEntries;
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event) {
        lock.acquireExclusiveLock();
        try {
            this.setDirty();
            for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener : this.changeListeners) {
                if (changeListener == null) continue;
                changeListener.onAfterRecordChanged(event);
            }
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        lock.acquireExclusiveLock();
        try {
            this.changeListeners.add(changeListener);
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        lock.acquireExclusiveLock();
        try {
            this.changeListeners.remove(changeListener);
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> changeEvents) {
        lock.acquireExclusiveLock();
        try {
            HashMap<OIdentifiable, OIdentifiable> reverted = new HashMap<OIdentifiable, OIdentifiable>((Map<OIdentifiable, OIdentifiable>)((Object)this));
            ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = changeEvents.listIterator(changeEvents.size());
            while (listIterator.hasPrevious()) {
                OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
                switch (event.getChangeType()) {
                    case ADD: {
                        reverted.remove(event.getKey());
                        break;
                    }
                    case REMOVE: {
                        reverted.put(event.getKey(), event.getOldValue());
                        break;
                    }
                    case UPDATE: {
                        reverted.put(event.getKey(), event.getOldValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
                    }
                }
            }
            HashMap<OIdentifiable, OIdentifiable> hashMap = reverted;
            return hashMap;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return null;
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        lock.acquireExclusiveLock();
        try {
            OSharedResourceIterator oSharedResourceIterator = new OSharedResourceIterator(lock, this.iterator(false));
            return oSharedResourceIterator;
        }
        finally {
            lock.releaseExclusiveLock();
        }
    }

    @Override
    public void convertLinks2Records() {
    }

    @Override
    public boolean convertRecords2Links() {
        return false;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    public static OSharedResourceAdaptiveExternal getLock() {
        return lock;
    }
}

