/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;

public class TFileRecordWriter
extends RecordWriter<WritableComparable, Tuple> {
    private final BytesWritable KEY0 = new BytesWritable(new byte[0]);
    private static InterSedes sedes = InterSedesFactory.getInterSedesInstance();
    TFile.Writer writer = null;
    FSDataOutputStream fileOut = null;

    public TFileRecordWriter(Path file, String codec, Configuration conf) throws IOException {
        FileSystem fs = file.getFileSystem(conf);
        this.fileOut = fs.create(file, false);
        this.writer = new TFile.Writer(this.fileOut, 0x100000, codec, null, conf);
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.fileOut != null) {
            this.fileOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(WritableComparable wc, Tuple t) throws IOException, InterruptedException {
        DataOutputStream outputKey = this.writer.prepareAppendKey(this.KEY0.getLength());
        try {
            outputKey.write(this.KEY0.getBytes(), 0, this.KEY0.getLength());
        }
        finally {
            outputKey.close();
        }
        DataOutputStream outputValue = this.writer.prepareAppendValue(-1);
        try {
            sedes.writeDatum(outputValue, t);
        }
        finally {
            outputValue.close();
        }
    }
}

